/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableOperations {
    protected VariableOperations() {
    }

    public static <C, PM> boolean checkInitType(Variable<C, PM> variable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(variable, context);
        if (env != null) {
            OCLExpression<C> init = variable.getInitExpression();
            Object type = variable.getType();
            if (init != null && init.getType() != null && type != null && !TypeUtil.compatibleTypeMatch(env, init.getType(), type)) {
                result = false;
                message = OCLMessages.bind(OCLMessages.TypeConformanceInit_ERROR_, variable.getName());
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 20, message, new Object[]{variable}));
        }
        return result;
    }
}

