/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.component.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.uml2.diagram.component.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Usage;

public class ComponentRequiredReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ComponentRequiredReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Component)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Component)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistComponentRequired_4007(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTargetGen() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Interface)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistComponentRequired_4007(this.getOldSource(), this.getNewTarget());
    }

    protected boolean canReorientTarget() {
        boolean result = this.canReorientTargetGen();
        if (result) {
            result = this.findUsage(this.getOldSource(), this.getOldTarget()) != null;
        }
        return result;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getRequireds().remove((Object)this.getOldTarget());
        this.getNewSource().getRequireds().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        Component component = this.getOldSource();
        Usage usage = this.findUsage(component, this.getOldTarget());
        if (usage != null) {
            usage.getSuppliers().remove((Object)this.getOldTarget());
            usage.getSuppliers().add((Object)this.getNewTarget());
        }
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Component getOldSource() {
        return (Component)this.referenceOwner;
    }

    protected Component getNewSource() {
        return (Component)this.newEnd;
    }

    protected Interface getOldTarget() {
        return (Interface)this.oldEnd;
    }

    protected Interface getNewTarget() {
        return (Interface)this.newEnd;
    }

    private Usage findUsage(Component component, Interface required) {
        for (Dependency next : component.getClientDependencies()) {
            if (!(next instanceof Usage) || !next.getSuppliers().contains((Object)required)) continue;
            return (Usage)next;
        }
        return null;
    }
}

