/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.common.edit.domain;

import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.impl.FeatureChangeImpl;
import org.eclipse.emf.ecore.change.impl.ListChangeImpl;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2AdapterFactoryEditingDomain
extends AdapterFactoryEditingDomain {
    protected ChangeRecorder changeRecorder = null;

    public UML2AdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack) {
        super(adapterFactory, commandStack);
    }

    public UML2AdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, Map<Resource, Boolean> resourceToReadOnlyMap) {
        super(adapterFactory, commandStack, resourceToReadOnlyMap);
    }

    public UML2AdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, ResourceSet resourceSet) {
        super(adapterFactory, commandStack, resourceSet);
    }

    protected ChangeRecorder createChangeRecorder() {
        return new ChangeRecorder(){
            private boolean featureIsUnique = false;

            protected ListChange createListChange(EList<ListChange> changesList, ChangeKind kind, int index) {
                if (this.featureIsUnique) {
                    UniqueListChangeImpl listChange = new UniqueListChangeImpl();
                    listChange.setKind(kind);
                    listChange.setIndex(index);
                    changesList.add((Object)listChange);
                    return listChange;
                }
                return super.createListChange(changesList, kind, index);
            }

            protected void createRemoveListChange(EList<?> oldList, EList<ListChange> changesList, Object newObject, int index) {
                if (this.featureIsUnique) {
                    ListChange listChange = this.createListChange(changesList, ChangeKind.REMOVE_LITERAL, index);
                    listChange.getValues().add(oldList.remove(index));
                } else {
                    super.createRemoveListChange(oldList, changesList, newObject, index);
                }
            }

            protected void finalizeChange(FeatureChange change, EObject eObject) {
                this.featureIsUnique = change.getFeature().isUnique();
                super.finalizeChange(change, eObject);
            }

            protected FeatureChange createFeatureChange(EObject eObject, EStructuralFeature eStructuralFeature, Object value, boolean isSet) {
                return new UniqueFeatureChangeImpl(eStructuralFeature, value, isSet);
            }
        };
    }

    public ChangeRecorder getChangeRecorder() {
        if (this.changeRecorder == null) {
            this.changeRecorder = this.createChangeRecorder();
        }
        return this.changeRecorder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UniqueFeatureChangeImpl
    extends FeatureChangeImpl {
        protected UniqueFeatureChangeImpl(EStructuralFeature feature, Object value, boolean isSet) {
            super(feature, value, isSet);
        }

        protected ListChange createListChange(EList<ListChange> changesList, ChangeKind kind, int index) {
            if (this.getFeature().isUnique()) {
                UniqueListChangeImpl listChange = new UniqueListChangeImpl();
                listChange.setKind(kind);
                listChange.setIndex(index);
                changesList.add((Object)listChange);
                return listChange;
            }
            return super.createListChange(changesList, kind, index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UniqueListChangeImpl
    extends ListChangeImpl {
        private UniqueListChangeImpl() {
        }

        public void apply(EList<Object> originalList) {
            switch (this.getKind().getValue()) {
                case 0: {
                    if (this.index == -1) {
                        for (Object value : this.getValues()) {
                            if (originalList.contains(value)) continue;
                            originalList.add(value);
                        }
                    } else {
                        EList values = this.getValues();
                        ListIterator v = values.listIterator(values.size());
                        while (v.hasPrevious()) {
                            Object value = v.previous();
                            if (originalList.contains(value)) continue;
                            originalList.add(this.index, value);
                        }
                    }
                    break;
                }
                case 1: {
                    for (Object value : this.getValues()) {
                        originalList.remove(value);
                    }
                    break;
                }
                default: {
                    super.apply(originalList);
                }
            }
        }

        public void applyAndReverse(EList<Object> originalList) {
            switch (this.getKind().getValue()) {
                case 0: {
                    if (this.index == -1) {
                        this.index = originalList.size();
                        for (Object value : this.getValues()) {
                            if (originalList.contains(value)) continue;
                            originalList.add(value);
                        }
                    } else {
                        EList values = this.getValues();
                        ListIterator v = values.listIterator(values.size());
                        while (v.hasPrevious()) {
                            Object value = v.previous();
                            if (originalList.contains(value)) continue;
                            originalList.add(this.index, value);
                        }
                    }
                    this.setKind(ChangeKind.REMOVE_LITERAL);
                    break;
                }
                case 1: {
                    for (Object value : this.getValues()) {
                        originalList.remove(value);
                    }
                    this.setKind(ChangeKind.ADD_LITERAL);
                    break;
                }
                default: {
                    super.applyAndReverse(originalList);
                }
            }
        }
    }
}

