/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLObjectProperty.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.emf.common.util.EList;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>OWL Object Property</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsInverseFunctional <em>isInverseFunctional</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsSymmetric <em>isSymmetric</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsTransitive <em>isTransitive</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#getOWLinverseOf <em>OWLinverseOf</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLObjectProperty()
 * @model
 * @generated
 */
public interface OWLObjectProperty extends Property {
	/**
	 * Returns the value of the '<em><b>isInverseFunctional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Inverse Functional</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isInverseFunctional</em>' attribute.
	 * @see #setIsInverseFunctional(boolean)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLObjectProperty_IsInverseFunctional()
	 * @model required="true"
	 * @generated
	 */
	boolean isIsInverseFunctional();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsInverseFunctional <em>isInverseFunctional</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isInverseFunctional</em>' attribute.
	 * @see #isIsInverseFunctional()
	 * @generated
	 */
	void setIsInverseFunctional(boolean value);

	/**
	 * Returns the value of the '<em><b>isSymmetric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Symmetric</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isSymmetric</em>' attribute.
	 * @see #setIsSymmetric(boolean)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLObjectProperty_IsSymmetric()
	 * @model required="true"
	 * @generated
	 */
	boolean isIsSymmetric();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsSymmetric <em>isSymmetric</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isSymmetric</em>' attribute.
	 * @see #isIsSymmetric()
	 * @generated
	 */
	void setIsSymmetric(boolean value);

	/**
	 * Returns the value of the '<em><b>isTransitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Transitive</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isTransitive</em>' attribute.
	 * @see #setIsTransitive(boolean)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLObjectProperty_IsTransitive()
	 * @model required="true"
	 * @generated
	 */
	boolean isIsTransitive();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsTransitive <em>isTransitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isTransitive</em>' attribute.
	 * @see #isIsTransitive()
	 * @generated
	 */
	void setIsTransitive(boolean value);

	/**
	 * Returns the list of the '<em><b>OWLinverseOf</b></em>' references.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the list of the '<em>OWLinverseOf</em>' references.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLObjectProperty_OWLinverseOf()
	 * @model
	 * @generated
	 */
	EList getOWLinverseOf();


} // OWLObjectProperty
