/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CLifeLineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.keyboardlistener.IKeyPressState;
import org.eclipse.papyrus.uml.diagram.sequence.keyboardlistener.KeyboardListener;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public abstract class UpdateWeakReferenceEditPolicy
extends GraphicalEditPolicy
implements IKeyPressState {
    protected KeyboardListener SHIFTDown = new KeyboardListener(this, 131072, true);
    protected KeyboardListener SHIFTUp = new KeyboardListener(this, 131072, false);
    protected boolean mustMove = true;
    private final MoveMessagePropertyChangeListener moveMessageListener = new MoveMessagePropertyChangeListener();
    protected boolean mustMoveBelowAtMovingUp;
    protected boolean mustMoveBelowAtMovingDown;
    protected static int deltaMoveAtCreationAndDeletion = 40;

    public void activate() {
        super.activate();
        PlatformUI.getWorkbench().getDisplay().addFilter(1, (Listener)this.SHIFTDown);
        PlatformUI.getWorkbench().getDisplay().addFilter(2, (Listener)this.SHIFTUp);
        this.mustMoveBelowAtMovingUp = UMLDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("PREF_MOVE_BELOW_ELEMENTS_AT_MESSAGE_UP");
        this.mustMoveBelowAtMovingDown = UMLDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("PREF_MOVE_BELOW_ELEMENTS_AT_MESSAGE_DOWN");
        deltaMoveAtCreationAndDeletion = UMLDiagramEditorPlugin.getInstance().getPreferenceStore().getInt("PREF_MOVE_BELOW_ELEMENTS_AT_MESSAGE_CREATION");
        UMLDiagramEditorPlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.moveMessageListener);
    }

    public void deactivate() {
        PlatformUI.getWorkbench().getDisplay().removeFilter(1, (Listener)this.SHIFTDown);
        PlatformUI.getWorkbench().getDisplay().removeFilter(2, (Listener)this.SHIFTUp);
        UMLDiagramEditorPlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.moveMessageListener);
        super.deactivate();
    }

    protected static ReconnectRequest createReconnectRequest(EditPart hostEditpart, ConnectionEditPart connectionEditPart, Rectangle location, ArrayList<EditPart> senderList, String reconnectType) {
        ReconnectRequest reconnectRequest = new ReconnectRequest();
        reconnectRequest.setConnectionEditPart(connectionEditPart);
        SenderRequestUtils.addRequestSenders((Request)reconnectRequest, senderList);
        if (hostEditpart != null) {
            SenderRequestUtils.addRequestSender((Request)reconnectRequest, hostEditpart);
        }
        reconnectRequest.setLocation(location.getLocation().getCopy());
        reconnectRequest.setType((Object)reconnectType);
        if ("Reconnection target".equals(reconnectType)) {
            reconnectRequest.setTargetEditPart(connectionEditPart.getTarget());
        } else {
            reconnectRequest.setTargetEditPart(connectionEditPart.getSource());
        }
        return reconnectRequest;
    }

    @Override
    public void setKeyPressState(Boolean isPressed) {
        this.mustMove = isPressed == false;
    }

    protected static void moveRoundedEditPart(EditPart hostEditPart, Point moveDelta, CompoundCommand compoundCommand, EditPart editPartToMove, ArrayList<EditPart> senderList) {
        ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"move");
        SenderRequestUtils.addRequestSenders((Request)changeBoundsRequest, senderList);
        if (hostEditPart != null) {
            SenderRequestUtils.addRequestSender((Request)changeBoundsRequest, hostEditPart);
        }
        GraphicalEditPart gEditPart = (GraphicalEditPart)editPartToMove;
        Point newLocation = new Point(gEditPart.getFigure().getBounds().getTopLeft().x, gEditPart.getFigure().getBounds().getTopLeft().y + moveDelta.y());
        if (editPartToMove.getParent() instanceof CLifeLineEditPart) {
            int stickerHeight = ((CLifeLineEditPart)editPartToMove.getParent()).getStickerHeight();
            if (newLocation.y >= stickerHeight) {
                changeBoundsRequest.setLocation(newLocation);
                changeBoundsRequest.setEditParts(editPartToMove);
                changeBoundsRequest.setMoveDelta(moveDelta);
                changeBoundsRequest.setSizeDelta(new Dimension(0, 0));
                compoundCommand.add(editPartToMove.getCommand((Request)changeBoundsRequest));
            } else {
                compoundCommand.add((Command)UnexecutableCommand.INSTANCE);
            }
        }
    }

    protected static void moveTargetConnectionEditPart(EditPart hostEditPart, Point moveDelta, CompoundCommand compoundCommand, ConnectionEditPart connectionEditPart, ArrayList<EditPart> senderList) {
        PolylineConnectionEx polyline = (PolylineConnectionEx)connectionEditPart.getFigure();
        Point positiononScreen = polyline.getTargetAnchor().getReferencePoint();
        Rectangle newAnchorPositionOnScreen = new Rectangle(positiononScreen.x, positiononScreen.y + moveDelta.y, 0, 0);
        ReconnectRequest reconnectTargetRequest = UpdateWeakReferenceEditPolicy.createReconnectRequest(hostEditPart, connectionEditPart, newAnchorPositionOnScreen, senderList, "Reconnection target");
        reconnectTargetRequest.getExtendedData().put("do not check horizontality", true);
        compoundCommand.add(connectionEditPart.getTarget().getCommand((Request)reconnectTargetRequest));
    }

    protected static void moveSourceConnectionEditPart(EditPart hostEditPart, Point moveDelta, CompoundCommand compoundCommand, ConnectionEditPart connectionEditPart, ArrayList<EditPart> senderList) {
        PolylineConnectionEx polyline = (PolylineConnectionEx)connectionEditPart.getFigure();
        Point anchorPositionOnScreen = polyline.getSourceAnchor().getReferencePoint();
        Rectangle newAnchorPositionOnScreen = new Rectangle(anchorPositionOnScreen.x, anchorPositionOnScreen.y + moveDelta.y, 0, 0);
        ReconnectRequest reconnectSourceRequest = UpdateWeakReferenceEditPolicy.createReconnectRequest(hostEditPart, connectionEditPart, newAnchorPositionOnScreen, senderList, "Reconnection source");
        reconnectSourceRequest.getExtendedData().put("do not check horizontality", true);
        compoundCommand.add(connectionEditPart.getSource().getCommand((Request)reconnectSourceRequest));
    }

    private final class MoveMessagePropertyChangeListener
    implements IPropertyChangeListener {
        private MoveMessagePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property;
            switch (property = event.getProperty()) {
                case "PREF_MOVE_BELOW_ELEMENTS_AT_MESSAGE_UP": {
                    if (UpdateWeakReferenceEditPolicy.this.mustMoveBelowAtMovingUp == (Boolean)event.getNewValue()) break;
                    UpdateWeakReferenceEditPolicy.this.mustMoveBelowAtMovingUp = (Boolean)event.getNewValue();
                    break;
                }
                case "PREF_MOVE_BELOW_ELEMENTS_AT_MESSAGE_DOWN": {
                    if (UpdateWeakReferenceEditPolicy.this.mustMoveBelowAtMovingDown == (Boolean)event.getNewValue()) break;
                    UpdateWeakReferenceEditPolicy.this.mustMoveBelowAtMovingDown = (Boolean)event.getNewValue();
                    break;
                }
                case "PREF_MOVE_BELOW_ELEMENTS_AT_MESSAGE_CREATION": {
                    if (deltaMoveAtCreationAndDeletion == (Integer)event.getNewValue()) break;
                    deltaMoveAtCreationAndDeletion = (Integer)event.getNewValue();
                }
            }
        }
    }
}

