/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture.representation.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.provider.SurrogateItemPropertyDescriptor;

public class StereotypePropertyDescriptor
extends SurrogateItemPropertyDescriptor {
    private static final Collection<EObject> empty = new ArrayList<EObject>();

    public StereotypePropertyDescriptor(IItemPropertyDescriptor inner) {
        super(inner);
    }

    public Collection<?> getChoiceOfValues(Object object) {
        EObject current = (EObject)object;
        while (current != null && !(current instanceof ArchitectureDescriptionLanguage)) {
            current = current.eContainer();
        }
        if (current == null) {
            return empty;
        }
        ArchitectureDescriptionLanguage conf = (ArchitectureDescriptionLanguage)current;
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EPackage p : conf.getProfiles()) {
            result.addAll(this.getAllStereotypes(p));
        }
        return result;
    }

    protected List<EClass> getAllStereotypes(EPackage ePackage) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EClassifier clazz : ePackage.getEClassifiers()) {
            if (!(clazz instanceof EClass)) continue;
            result.add((EClass)clazz);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            result.addAll(this.getAllStereotypes(subPackage));
        }
        return result;
    }

    public IItemLabelProvider getLabelProvider(Object object) {
        return new IItemLabelProvider(){

            public String getText(Object object) {
                if (object instanceof EClass) {
                    return StereotypePropertyDescriptor.this.eClassToString((EClass)object);
                }
                if (object instanceof EList) {
                    EList list = (EList)object;
                    if (list.isEmpty()) {
                        return "";
                    }
                    StringBuilder builder = new StringBuilder("{");
                    int i = 0;
                    while (i != list.size()) {
                        if (i != 0) {
                            builder.append(", ");
                        }
                        builder.append(StereotypePropertyDescriptor.this.eClassToString((EClass)list.get(i)));
                        ++i;
                    }
                    builder.append("}");
                    return builder.toString();
                }
                return "";
            }

            public Object getImage(Object object) {
                return null;
            }
        };
    }

    private String eClassToString(EClass item) {
        return String.valueOf(item.getEPackage().getNsPrefix()) + "#" + item.getName();
    }
}

