/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IEditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.commands.UnsetValueCommand;
import org.eclipse.papyrus.infra.emf.requests.UnsetRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateEditBasedElementCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateRelationshipCommandEx;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.eclipse.papyrus.infra.services.edit.utils.CacheRegistry;
import org.eclipse.papyrus.infra.types.core.notification.AbstractNotifierEditHelper;
import org.eclipse.papyrus.infra.types.core.utils.AdviceUtil;

public class DefaultEditHelper
extends AbstractNotifierEditHelper {
    public static final String Cache_Maps = "Cache_Maps";
    public static final String Element_Type = "Element_Type";
    public static final String Checked_Elements = "Checked_Elements";
    public static final String EditHelper_Advice = "EditHelper_Advice";
    public static final String Client_Context = "Client_Context";

    protected boolean approveRequest(IEditCommandRequest request) {
        Object context;
        if (request instanceof CreateRelationshipRequest) {
            return this.defaultApproveCreateRelationshipRequest((CreateRelationshipRequest)request);
        }
        if (request instanceof CreateElementRequest && (context = request.getEditHelperContext()) instanceof EObject) {
            EObject owner = (EObject)context;
            EReference reference = this.getContainmentFeature((CreateElementRequest)request);
            return reference != null && owner.eClass().getEAllContainments().contains((Object)reference);
        }
        return super.approveRequest(request);
    }

    protected boolean defaultApproveCreateRelationshipRequest(CreateRelationshipRequest request) {
        return true;
    }

    protected EReference getContainmentFeature(CreateElementRequest request) {
        EReference containmentFeature = request.getContainmentFeature();
        if (containmentFeature != null) {
            return containmentFeature;
        }
        containmentFeature = this.computeContainmentFeature(request);
        request.initializeContainmentFeature(containmentFeature);
        return containmentFeature;
    }

    protected EClass getEClassToEdit(CreateElementRequest request) {
        Object context = request.getEditHelperContext();
        if (context instanceof EObject) {
            return ((EObject)context).eClass();
        }
        IElementType type = ElementTypeRegistry.getInstance().getElementType(context);
        if (type != null) {
            return type.getEClass();
        }
        return null;
    }

    protected ICommand getCreateCommand(CreateElementRequest req) {
        return new CreateEditBasedElementCommand(req);
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (noSourceOrTarget && !noSourceAndTarget) {
            return IdentityCommand.INSTANCE;
        }
        return new CreateRelationshipCommandEx(req);
    }

    protected ICommand getDestroyElementWithDependentsCommand(DestroyElementRequest req) {
        ICommand command;
        Map map;
        DestroyDependentsRequest ddr;
        ICommand result = this.getBasicDestroyElementCommand(req);
        EObject initial = (EObject)req.getParameter("DestroyElementRequest.initialElementToDestroy");
        if (initial == null) {
            req.setParameter("DestroyElementRequest.initialElementToDestroy", (Object)req.getElementToDestroy());
        }
        if ((ddr = (DestroyDependentsRequest)req.getParameter("DestroyElementRequest.destroyDependentsRequest")) == null) {
            ddr = new DestroyDependentsRequest(req.getEditingDomain(), req.getElementToDestroy(), req.isConfirmationRequired());
            ddr.addParameters(req.getParameters());
            ddr.setClientContext(req.getClientContext());
            req.setParameter("DestroyElementRequest.destroyDependentsRequest", (Object)ddr);
        } else {
            ddr.setElementToDestroy(req.getElementToDestroy());
        }
        IElementType typeToDestroy = null;
        Map cacheMaps = (Map)req.getParameter(Cache_Maps);
        if (cacheMaps != null && (map = (Map)cacheMaps.get(req.getElementToDestroy())) != null) {
            typeToDestroy = (IElementType)map.get(Element_Type);
        }
        if (typeToDestroy == null) {
            typeToDestroy = ElementTypeRegistry.getInstance().getElementType(req.getElementToDestroy(), req.getClientContext());
        }
        if (typeToDestroy != null && (command = typeToDestroy.getEditCommand((IEditCommandRequest)ddr)) != null) {
            result = result.compose((IUndoableOperation)command);
        }
        return result;
    }

    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        ICommand result = null;
        EObject parent = req.getElementToDestroy();
        if (req.getParameter("DestroyElementRequest.initialElementToDestroy") == null) {
            req.setParameter("DestroyElementRequest.initialElementToDestroy", (Object)parent);
        }
        IElementType parentType = null;
        Map cacheMaps = (Map)req.getParameter(Cache_Maps);
        Set checkedElement = null;
        if (cacheMaps != null) {
            checkedElement = (Set)cacheMaps.get(Checked_Elements);
            checkedElement.add(parent);
            Map parentMap = (Map)cacheMaps.get(parent);
            parentType = parentMap != null ? (IElementType)parentMap.get(Element_Type) : ElementTypeRegistry.getInstance().getElementType(parent, req.getClientContext());
        } else {
            parentType = ElementTypeRegistry.getInstance().getElementType(parent, req.getClientContext());
        }
        if (parentType != null) {
            for (EObject next : parent.eContents()) {
                DestroyDependentsRequest ddr = (DestroyDependentsRequest)req.getParameter("DestroyElementRequest.destroyDependentsRequest");
                if (ddr != null && (checkedElement == null || !checkedElement.add(next)) && ddr.getDependentElementsToDestroy().contains(next)) continue;
                req.setElementToDestroy(next);
                ICommand command = parentType.getEditCommand((IEditCommandRequest)req);
                if (command == null) continue;
                result = result == null ? command : result.compose((IUndoableOperation)command);
            }
        }
        req.setElementToDestroy(parent);
        ICommand destroyParent = this.getDestroyElementWithDependentsCommand(req);
        result = result == null ? destroyParent : result.compose((IUndoableOperation)destroyParent);
        return result;
    }

    protected IEditHelperAdvice[] getEditHelperAdvice(IEditCommandRequest req) {
        IEditHelperAdvice[] advices = null;
        Object editHelperContext = req.getEditHelperContext();
        if (editHelperContext == null) {
            return null;
        }
        Map cacheMaps = (Map)req.getParameter(Cache_Maps);
        if (cacheMaps != null) {
            if (editHelperContext instanceof IEditHelperContext) {
                IElementType type = ((IEditHelperContext)editHelperContext).getElementType();
                if (type != null) {
                    Map contextMap = (Map)cacheMaps.get(type);
                    if (contextMap != null) {
                        advices = (IEditHelperAdvice[])contextMap.get(EditHelper_Advice);
                    }
                } else {
                    EObject contextObject = ((IEditHelperContext)editHelperContext).getEObject();
                    Map contextMap = (Map)cacheMaps.get(contextObject);
                    if (contextMap != null) {
                        advices = (IEditHelperAdvice[])contextMap.get(EditHelper_Advice);
                    }
                }
            } else {
                Map contextMap = (Map)cacheMaps.get(editHelperContext);
                if (contextMap != null) {
                    advices = (IEditHelperAdvice[])contextMap.get(EditHelper_Advice);
                }
            }
        }
        if (advices == null) {
            if (editHelperContext instanceof EObject) {
                IClientContext context = req.getClientContext();
                if (context == null) {
                    try {
                        context = TypeContext.getContext((EObject)((EObject)editHelperContext));
                        req.setClientContext(context);
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
                advices = ElementTypeRegistry.getInstance().getEditHelperAdvice((EObject)editHelperContext, req.getClientContext());
                IElementType[] types = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)editHelperContext, req.getClientContext());
                AdviceUtil.sort((IEditHelperAdvice[])advices, (IElementType[])types, (String)req.getClientContext().getId());
            } else if (editHelperContext instanceof IElementType) {
                if (req.getClientContext() == null) {
                    try {
                        req.setClientContext(TypeContext.getContext((EditingDomain)req.getEditingDomain()));
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
                advices = CacheRegistry.getInstance().getEditHelperAdvice(req.getClientContext(), (IElementType)editHelperContext);
                AdviceUtil.sort((IEditHelperAdvice[])advices, (IElementType)((IElementType)editHelperContext), (String)req.getClientContext().getId());
            } else if (editHelperContext instanceof IEditHelperContext) {
                IClientContext clientContext = ((IEditHelperContext)editHelperContext).getClientContext();
                IElementType elementType = ((IEditHelperContext)editHelperContext).getElementType();
                EObject eObject = ((IEditHelperContext)editHelperContext).getEObject();
                if (clientContext != null) {
                    if (elementType != null) {
                        advices = CacheRegistry.getInstance().getEditHelperAdvice(req.getClientContext(), elementType);
                        AdviceUtil.sort((IEditHelperAdvice[])advices, (IElementType)elementType, (String)req.getClientContext().getId());
                    } else if (eObject != null) {
                        IElementType[] types = ElementTypeRegistry.getInstance().getAllTypesMatching(eObject, req.getClientContext());
                        advices = ElementTypeRegistry.getInstance().getEditHelperAdvice(editHelperContext);
                        AdviceUtil.sort((IEditHelperAdvice[])advices, (IElementType[])types, (String)req.getClientContext().getId());
                    }
                } else if (elementType != null) {
                    if (req.getClientContext() == null) {
                        try {
                            req.setClientContext(TypeContext.getContext((EditingDomain)req.getEditingDomain()));
                        }
                        catch (ServiceException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                    advices = CacheRegistry.getInstance().getEditHelperAdvice(req.getClientContext(), elementType);
                    AdviceUtil.sort((IEditHelperAdvice[])advices, (IElementType)elementType, (String)req.getClientContext().getId());
                } else if (eObject != null) {
                    IClientContext context = req.getClientContext();
                    if (context == null) {
                        try {
                            context = TypeContext.getContext((EObject)eObject);
                            req.setClientContext(context);
                        }
                        catch (ServiceException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                    IElementType[] types = ElementTypeRegistry.getInstance().getAllTypesMatching(eObject, context);
                    advices = ElementTypeRegistry.getInstance().getEditHelperAdvice(editHelperContext);
                    AdviceUtil.sort((IEditHelperAdvice[])advices, (IElementType[])types, (String)req.getClientContext().getId());
                }
            }
        }
        return advices;
    }

    protected ICommand getBasicDestroyElementCommand(DestroyElementRequest req) {
        DestroyElementCommand result = req.getBasicDestroyCommand();
        if (result == null) {
            result = new DestroyElementPapyrusCommand(req);
        } else {
            req.setBasicDestroyCommand(null);
        }
        return result;
    }

    protected ICommand getInsteadCommand(IEditCommandRequest req) {
        Object result = null;
        result = req instanceof UnsetRequest ? new UnsetValueCommand((UnsetRequest)req) : super.getInsteadCommand(req);
        return result;
    }

    protected EReference getContainmentFeatureFromSpecializationType(ISpecializationType specializationType, Object editHelperContext) {
        EReference[] features;
        IContainerDescriptor containerDescriptor;
        if (specializationType != null && (containerDescriptor = specializationType.getEContainerDescriptor()) != null && (features = containerDescriptor.getContainmentFeatures()) != null) {
            int i = 0;
            while (i < features.length) {
                EClass eClass = null;
                if (editHelperContext instanceof EClass) {
                    eClass = (EClass)editHelperContext;
                } else if (editHelperContext instanceof EObject) {
                    eClass = ((EObject)editHelperContext).eClass();
                } else if (editHelperContext instanceof IElementType) {
                    eClass = ((IElementType)editHelperContext).getEClass();
                }
                if (eClass != null && eClass.getEAllReferences().contains((Object)features[i])) {
                    return features[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean initializeWithThisSpecializationType(ISpecializationType specializationType, CreateElementRequest req) {
        EReference containmentFeature = this.getContainmentFeatureFromSpecializationType(specializationType, req);
        if (containmentFeature != null) {
            req.initializeContainmentFeature(containmentFeature);
            return true;
        }
        return false;
    }

    protected boolean isKindOf(EClass a, EClassifier b) {
        if (a.getEAllSuperTypes().contains((Object)b)) {
            return true;
        }
        return a.equals(b);
    }

    protected EReference findDefaultContainmentFeature(EClass ownerType, EClass ownedType) {
        for (EReference eReference : ownerType.getEAllContainments()) {
            if (!this.isKindOf(ownedType, (EClassifier)eReference.getEReferenceType())) continue;
            return eReference;
        }
        return null;
    }

    public void initializeDefaultFeature(CreateElementRequest req) {
        EReference containmentFeature;
        if (req.getContainmentFeature() == null && (containmentFeature = this.computeContainmentFeature(req)) != null) {
            req.initializeContainmentFeature(containmentFeature);
        }
    }

    protected EReference computeContainmentFeature(CreateElementRequest request) {
        return this.computeContainmentFeature(request.getElementType(), request.getContainer(), request.getEditHelperContext());
    }

    protected EReference computeContainmentFeature(IElementType elementType, EObject container, Object editHelperContext) {
        EClass eClass;
        ISpecializationType specializationType = (ISpecializationType)elementType.getAdapter(ISpecializationType.class);
        if (specializationType != null) {
            EReference reference = this.getContainmentFeatureFromSpecializationType(specializationType, editHelperContext);
            if (reference != null) {
                return reference;
            }
            IElementType[] superTypes = specializationType.getAllSuperTypes();
            int i = 0;
            while (i < superTypes.length) {
                IElementType superElementType = superTypes[i];
                if (superElementType instanceof ISpecializationType && (reference = this.getContainmentFeatureFromSpecializationType((ISpecializationType)superElementType, editHelperContext)) != null) {
                    return reference;
                }
                ++i;
            }
        }
        if ((eClass = elementType.getEClass()) != null) {
            EReference defaultFeature = this.getDefaultContainmentFeature(eClass);
            if (defaultFeature != null) {
                return defaultFeature;
            }
            EReference defaultEReference = this.findDefaultContainmentFeature(container.eClass(), eClass);
            if (defaultEReference != null) {
                return defaultEReference;
            }
        }
        return null;
    }
}

