/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.menu.provider;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.navigation.Activator;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.HyperlinkButton;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenuButton;
import org.eclipse.swt.graphics.Image;

public class SelectionMenuLabelProvider
extends ColumnLabelProvider {
    protected boolean isLocalLabelProvider;

    public String getText(Object element) {
        if (element instanceof NavigationMenuButton) {
            return ((NavigationMenuButton)element).getLabel();
        }
        if (element instanceof HyperlinkButton) {
            return ((HyperlinkButton)element).getText();
        }
        if (element instanceof NavigableElement) {
            return ((NavigableElement)element).getLabel();
        }
        if (element instanceof EObject) {
            return this.getName((EObject)element);
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof NavigableElement) {
            return ((NavigableElement)element).getImage();
        }
        if (element instanceof NavigationMenuButton) {
            return ((NavigationMenuButton)element).getIcon();
        }
        if (element instanceof HyperlinkButton) {
            return ((HyperlinkButton)element).getIcon();
        }
        if (element instanceof EObject) {
            ILabelProvider labelProvider = this.getLabelProvider((EObject)element);
            Image icon = null;
            icon = labelProvider.getImage(element);
            if (this.isLocalLabelProvider) {
                labelProvider.dispose();
            }
            return icon;
        }
        return super.getImage(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof HyperlinkButton) {
            return ((HyperlinkButton)element).getToolTip();
        }
        if (element instanceof NavigationMenuButton) {
            return ((NavigationMenuButton)element).getTooltip();
        }
        if (element instanceof NavigableElement) {
            return ((NavigableElement)element).getDescription();
        }
        if (element instanceof EObject) {
            return this.getName((EObject)element);
        }
        return super.getToolTipText(element);
    }

    protected ILabelProvider getLabelProvider(EObject element) {
        ILabelProvider labelProvider = null;
        try {
            labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)element)).getLabelProvider("org.eclipse.papyrus.infra.services.navigation.menu.labelprovider");
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        if (labelProvider == null) {
            labelProvider = new LabelProvider();
            this.isLocalLabelProvider = true;
        } else {
            this.isLocalLabelProvider = false;
        }
        return labelProvider;
    }

    protected String getName(EObject element) {
        ILabelProvider labelProvider = this.getLabelProvider(element);
        String name = labelProvider.getText((Object)element);
        if (this.isLocalLabelProvider) {
            labelProvider.dispose();
        }
        if (name != null) {
            return name;
        }
        return element.toString();
    }
}

