/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class MatchSizeAction
extends SelectionAction {
    public MatchSizeAction(IWorkbenchPart part) {
        super(part);
        this.setText(GEFMessages.MatchSizeAction_Label);
        this.setImageDescriptor(InternalImages.DESC_MATCH_SIZE);
        this.setDisabledImageDescriptor(InternalImages.DESC_MATCH_SIZE_DIS);
        this.setToolTipText(GEFMessages.MatchSizeAction_Tooltip);
        this.setId("org.eclipse.gef.match.size");
    }

    @Override
    protected boolean calculateEnabled() {
        Command cmd = this.createMatchSizeCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    private Command createMatchSizeCommand(List objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof GraphicalEditPart)) {
            return null;
        }
        GraphicalEditPart primarySelection = MatchSizeAction.getPrimarySelectionEditPart(this.getSelectedObjects());
        if (primarySelection == null) {
            return null;
        }
        GraphicalEditPart part = null;
        ChangeBoundsRequest request = null;
        PrecisionDimension preciseDimension = null;
        PrecisionRectangle precisePartBounds = null;
        Command cmd = null;
        CompoundCommand command = new CompoundCommand();
        PrecisionRectangle precisePrimaryBounds = new PrecisionRectangle(primarySelection.getFigure().getBounds().getCopy());
        primarySelection.getFigure().translateToAbsolute((Translatable)precisePrimaryBounds);
        for (Object object : objects) {
            part = (GraphicalEditPart)object;
            if (part.equals(primarySelection)) continue;
            request = new ChangeBoundsRequest("resize");
            precisePartBounds = new PrecisionRectangle(part.getFigure().getBounds().getCopy());
            part.getFigure().translateToAbsolute((Translatable)precisePartBounds);
            preciseDimension = new PrecisionDimension();
            preciseDimension.setPreciseWidth(this.getPreciseWidthDelta(precisePartBounds, precisePrimaryBounds));
            preciseDimension.setPreciseHeight(this.getPreciseHeightDelta(precisePartBounds, precisePrimaryBounds));
            request.setSizeDelta((Dimension)preciseDimension);
            cmd = part.getCommand(request);
            if (cmd == null) continue;
            command.add(cmd);
        }
        return command;
    }

    protected double getPreciseHeightDelta(PrecisionRectangle precisePartBounds, PrecisionRectangle precisePrimaryBounds) {
        return precisePrimaryBounds.preciseHeight() - precisePartBounds.preciseHeight();
    }

    private static GraphicalEditPart getPrimarySelectionEditPart(List editParts) {
        GraphicalEditPart part = null;
        for (Object editPart : editParts) {
            part = (GraphicalEditPart)editPart;
            if (part.getSelected() != 2) continue;
            return part;
        }
        return null;
    }

    protected double getPreciseWidthDelta(PrecisionRectangle precisePartBounds, PrecisionRectangle precisePrimaryBounds) {
        return precisePrimaryBounds.preciseWidth() - precisePartBounds.preciseWidth();
    }

    public void run() {
        this.execute(this.createMatchSizeCommand(this.getSelectedObjects()));
    }
}

