/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.internal.ui.palette.editparts.IPaletteStackEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.PinnablePaletteStackFigure;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.ui.palette.editparts.IPinnableEditPart;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;

public class PinnablePaletteStackEditPart
extends PaletteEditPart
implements IPaletteStackEditPart,
IPinnableEditPart {
    private final PaletteListener paletteListener = (palette, tool) -> {
        if (!this.getFigure().isPinnedOpen() && this.getStack().getChildren().contains(tool) && !this.getStack().getActiveEntry().equals(tool)) {
            this.getStack().setActiveEntry(tool);
        }
        if (!this.getFigure().isPinnedOpen()) {
            this.getFigure().setExpanded(false);
        }
    };

    public PinnablePaletteStackEditPart(PaletteStack model) {
        super(model);
    }

    @Override
    public void activate() {
        this.checkActiveEntrySync();
        this.getPaletteViewer().addPaletteListener(this.paletteListener);
        super.activate();
    }

    private void activeEntryChanged(Object oldValue, Object newValue) {
        GraphicalEditPart part = null;
        IFigure oldFigure = null;
        IFigure newFigure = null;
        int index = -1;
        if (oldValue != null && (part = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(oldValue)) != null) {
            oldFigure = part.getFigure();
            index = this.getModelChildren().indexOf(part.getModel());
        }
        if (newValue != null) {
            part = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(newValue);
            newFigure = part.getFigure();
        }
        this.getFigure().activeEntryChanged(oldFigure, index, newFigure);
    }

    private void checkActiveEntrySync() {
        if (this.getFigure().getActiveFigure() == null) {
            this.activeEntryChanged(null, this.getStack().getActiveEntry());
        }
    }

    @Override
    public IFigure createFigure() {
        return new PinnablePaletteStackFigure();
    }

    public PinnablePaletteStackFigure getFigure() {
        return (PinnablePaletteStackFigure)super.getFigure();
    }

    @Override
    public void deactivate() {
        this.getPaletteViewer().removePaletteListener(this.paletteListener);
        super.deactivate();
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        this.getChildren().forEach(part -> part.eraseTargetFeedback(request));
        super.eraseTargetFeedback(request);
    }

    @Override
    public IFigure getContentPane() {
        return this.getFigure().getContentPane();
    }

    @Override
    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getFigure().getContentPane(child).remove(child);
    }

    @Override
    protected void addChild(EditPart childEP, int index) {
        index = this.updateIndexBasedOnActiveFigure(index, childEP);
        super.addChild(childEP, index);
    }

    @Override
    protected void reorderChild(EditPart childEP, int index) {
        IFigure childFigure = ((GraphicalEditPart)childEP).getFigure();
        if (childFigure == this.getFigure().getActiveFigure()) {
            this.reorderChildInChildrenList((PaletteEditPart)childEP, index);
        } else {
            this.removeChildVisual(childEP);
            this.reorderChildInChildrenList((PaletteEditPart)childEP, index);
            index = this.updateIndexBasedOnActiveFigure(index, childEP);
            this.addChildVisual(childEP, index);
        }
    }

    private void reorderChildInChildrenList(PaletteEditPart childEP, int index) {
        List<? extends PaletteEditPart> children = this.getChildren();
        children.remove(childEP);
        children.add(index, childEP);
    }

    private int updateIndexBasedOnActiveFigure(int index, EditPart childEP) {
        int i = 0;
        while (i < index) {
            PaletteEditPart ep = this.getChildren().get(i);
            if (ep.getFigure() == this.getFigure().getActiveFigure()) {
                return index - 1;
            }
            ++i;
        }
        return index;
    }

    private PaletteStack getStack() {
        return (PaletteStack)this.getModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Active Entry")) {
            this.activeEntryChanged(event.getOldValue(), event.getNewValue());
        } else {
            super.propertyChange(event);
        }
    }

    @Override
    protected void refreshChildren() {
        super.refreshChildren();
        this.checkActiveEntrySync();
    }

    @Override
    protected void refreshVisuals() {
        this.getFigure().setLayoutMode(this.getLayoutSetting());
    }

    @Override
    public void openMenu() {
        this.setExpanded(true);
    }

    public void setExpanded(boolean value) {
        this.getFigure().setExpanded(value);
    }

    @Override
    public boolean isExpanded() {
        return this.getFigure().isExpanded();
    }

    @Override
    public boolean canBePinned() {
        return this.isExpanded();
    }

    @Override
    public boolean isPinnedOpen() {
        return this.getFigure().isPinnedOpen();
    }

    @Override
    public void setPinnedOpen(boolean pinned) {
        this.getFigure().setPinned(pinned);
    }

    @Override
    public PaletteEditPart getActiveEntry() {
        return (PaletteEditPart)this.getViewer().getEditPartRegistry().get(this.getStack().getActiveEntry());
    }
}

