/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.MacInstalledJREs;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;

public class DetectVMInstallationsJob
extends Job {
    private static final Object FAMILY = DetectVMInstallationsJob.class;

    private DetectVMInstallationsJob() {
        super(LaunchingMessages.lookupInstalledJVMs);
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor subMon;
        StandardVMType standardType = (StandardVMType)JavaRuntime.getVMInstallType("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        Collection<File> candidates = this.computeCandidateVMs(standardType);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Set<File> knownVMs = DetectVMInstallationsJob.knownVMs();
        candidates.removeIf(knownVMs::contains);
        ArrayList<VMStandin> systemVMs = Collections.EMPTY_LIST;
        if ("macosx".equals(Platform.getOS())) {
            try {
                systemVMs = new ArrayList<VMStandin>(Arrays.asList(MacInstalledJREs.getInstalledJREs(monitor)));
                systemVMs.removeIf(t -> knownVMs.contains(t.getInstallLocation()));
                for (VMStandin systemVM : systemVMs) {
                    candidates.removeIf(t -> t.equals(systemVM.getInstallLocation()));
                }
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        monitor.beginTask(LaunchingMessages.lookupInstalledJVMs, candidates.size() + systemVMs.size());
        for (File f : candidates) {
            IVMInstall2 vm;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)f.getAbsolutePath(), (int)1);
            VMStandin workingCopy = new VMStandin(standardType, f.getAbsolutePath());
            workingCopy.setInstallLocation(f);
            Object name = f.getName();
            int i = 1;
            while (this.isDuplicateName((String)name)) {
                name = f.getName() + "(" + i++ + ")";
            }
            workingCopy.setName((String)name);
            IVMInstall install = workingCopy.convertToRealVM();
            if (!(install instanceof IVMInstall2) || (vm = (IVMInstall2)((Object)install)).getJavaVersion() == null) {
                standardType.disposeVMInstall(install.getId());
            }
            subMon.done();
        }
        for (VMStandin systemVM : systemVMs) {
            IVMInstall2 vm;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)systemVM.getInstallLocation().getAbsolutePath(), (int)1);
            Object name = systemVM.getName();
            int i = 1;
            while (this.isDuplicateName((String)name)) {
                name = systemVM.getName() + "(" + i++ + ")";
            }
            systemVM.setName((String)name);
            IVMInstall install = systemVM.convertToRealVM();
            if (!(install instanceof IVMInstall2) || (vm = (IVMInstall2)((Object)install)).getJavaVersion() == null) {
                standardType.disposeVMInstall(install.getId());
            }
            subMon.done();
        }
        return Status.OK_STATUS;
    }

    private boolean isDuplicateName(String name) {
        return Stream.of(JavaRuntime.getVMInstallTypes()).flatMap(vmType -> Arrays.stream(vmType.getVMInstalls())).map(IVMInstall::getName).anyMatch(name::equals);
    }

    private Collection<File> computeCandidateVMs(StandardVMType standardType) {
        String jdkHome;
        HashSet<File> rootDirectories = new HashSet<File>();
        if (!"win32".equals(Platform.getOS())) {
            rootDirectories.add(new File("/usr/lib/jvm"));
        }
        rootDirectories.add(new File(System.getProperty("user.home"), ".sdkman/candidates/java"));
        Set directories = rootDirectories.stream().filter(File::isDirectory).map(dir -> dir.listFiles(File::isDirectory)).flatMap(Arrays::stream).filter(Objects::nonNull).collect(Collectors.toSet());
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null) {
            directories.add(new File(javaHome));
        }
        if ((jdkHome = System.getenv("JDK_HOME")) != null) {
            directories.add(new File(jdkHome));
        }
        return directories.stream().filter(Objects::nonNull).filter(File::isDirectory).map(t -> {
            try {
                return t.getCanonicalFile();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).filter(location -> standardType.validateInstallLocation((File)location).isOK()).collect(Collectors.toCollection(HashSet::new));
    }

    private static Set<File> knownVMs() {
        return Stream.of(JavaRuntime.getVMInstallTypes()).map(IVMInstallType::getVMInstalls).flatMap(Arrays::stream).map(IVMInstall::getInstallLocation).filter(Objects::nonNull).map(t -> {
            try {
                return t.getCanonicalFile();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean belongsTo(Object family) {
        return family.equals(FAMILY);
    }

    public static void initialize() {
        boolean forcedDisableVMDetection = Boolean.getBoolean("DetectVMInstallationsJob.disabled");
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode(LaunchingPlugin.getDefault().getBundle().getSymbolicName());
        IEclipsePreferences defaultNode = DefaultScope.INSTANCE.getNode(LaunchingPlugin.getDefault().getBundle().getSymbolicName());
        boolean defaultValue = defaultNode.getBoolean("detectVMsAtStartup", true);
        if (!forcedDisableVMDetection && instanceNode.getBoolean("detectVMsAtStartup", defaultValue)) {
            new DetectVMInstallationsJob().schedule();
        }
    }
}

