/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchShortcut;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.exports.BuildUtilities;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class BaseBuildAction
extends AbstractHandler {
    protected IFile fManifestFile;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IProject project;
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IJavaProject && (project = ((IJavaProject)obj).getProject()).exists()) {
                this.fManifestFile = PDEProject.getManifest((IProject)project);
            }
            if (obj instanceof IResource && (project = ((IResource)obj).getProject()).exists()) {
                this.fManifestFile = PDEProject.getManifest((IProject)project);
            }
        }
        if (this.fManifestFile == null || !this.fManifestFile.exists()) {
            PDEPlugin.log(PDEUIMessages.BaseBuildAction_NoValidManifest);
            return null;
        }
        IRunnableWithProgress op = monitor -> {
            IWorkspaceRunnable wop = monitor1 -> {
                try {
                    this.doBuild(monitor1);
                }
                catch (InvocationTargetException e) {
                    PDEPlugin.logException(e);
                }
            };
            try {
                PDEPlugin.getWorkspace().run(wop, monitor);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
        }
        catch (InterruptedException project) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        return null;
    }

    private void doBuild(IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.BuildAction_Validate, (int)4);
        if (!BaseBuildAction.ensureValid(this.fManifestFile, (IProgressMonitor)subMonitor.split(1))) {
            subMonitor.split(3);
            return;
        }
        subMonitor.setTaskName(PDEUIMessages.BuildAction_Generate);
        this.makeScripts((IProgressMonitor)subMonitor.split(1));
        subMonitor.setTaskName(PDEUIMessages.BuildAction_Update);
        this.refreshLocal((IProgressMonitor)subMonitor.split(1));
        IProject project = this.fManifestFile.getProject();
        IFile generatedFile = (IFile)project.findMember("build.xml");
        if (generatedFile != null) {
            BaseBuildAction.setDefaultValues(generatedFile);
        }
        subMonitor.split(1);
    }

    protected abstract void makeScripts(IProgressMonitor var1) throws InvocationTargetException, CoreException;

    public static boolean ensureValid(IFile file, IProgressMonitor monitor) throws CoreException {
        IProject project = file.getProject();
        if (!project.getWorkspace().isAutoBuilding()) {
            String builderID = "feature.xml".equals(file.getName()) ? "org.eclipse.pde.FeatureBuilder" : "org.eclipse.pde.ManifestBuilder";
            project.build(10, builderID, null, monitor);
        }
        if (BaseBuildAction.hasErrors(file)) {
            MessageDialog.openError(null, (String)PDEUIMessages.BuildAction_ErrorDialog_Title, (String)PDEUIMessages.BuildAction_ErrorDialog_Message);
            return false;
        }
        return true;
    }

    public static boolean hasErrors(IFile file) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            Object att = marker.getAttribute("severity");
            if (att != null && att instanceof Integer && (Integer)att == 2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void refreshLocal(IProgressMonitor monitor) throws CoreException {
        IProject project = this.fManifestFile.getProject();
        project.refreshLocal(1, monitor);
        IFile file = project.getFile("dev.properties");
        if (file.exists()) {
            file.delete(true, false, monitor);
        }
        project.refreshLocal(1, monitor);
    }

    public static void setDefaultValues(IFile generatedFile) {
        try {
            ILaunchConfigurationWorkingCopy launchCopy;
            List configs = AntLaunchShortcut.findExistingLaunchConfigurations((IFile)generatedFile);
            if (configs.isEmpty()) {
                ILaunchConfiguration config = AntLaunchShortcut.createDefaultLaunchConfiguration((IFile)generatedFile);
                launchCopy = config.getWorkingCopy();
            } else {
                launchCopy = ((ILaunchConfiguration)configs.get(0)).getWorkingCopy();
            }
            if (launchCopy == null) {
                return;
            }
            Map<String, String> properties = new HashMap();
            properties = launchCopy.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
            properties.put("basews", TargetPlatform.getWS());
            properties.put("baseos", TargetPlatform.getOS());
            properties.put("basearch", TargetPlatform.getOSArch());
            properties.put("basenl", TargetPlatform.getNL());
            properties.put("eclipse.running", "true");
            properties.put("javacFailOnError", "false");
            properties.put("javacDebugInfo", "on");
            properties.put("javacVerbose", "false");
            IProject project = generatedFile.getProject();
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                PDEPreferencesManager pref = new PDEPreferencesManager("org.eclipse.jdt.core");
                properties.put("javacSource", pref.getString("org.eclipse.jdt.core.compiler.source"));
                properties.put("javacTarget", pref.getString("org.eclipse.jdt.core.compiler.codegen.targetPlatform"));
            } else {
                IJavaProject jProject = JavaCore.create((IProject)project);
                properties.put("javacSource", jProject.getOption("org.eclipse.jdt.core.compiler.source", true));
                properties.put("javacTarget", jProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
            }
            properties.put("bootclasspath", BuildUtilities.getBootClasspath());
            launchCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
            launchCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            launchCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
            launchCopy.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", null);
            launchCopy.doSave();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

