/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.util.ArrayList;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskChoiceCompletionStrategy;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskSetCompletionStrategy;
import org.eclipse.ui.internal.cheatsheets.composite.parser.ITaskParseStrategy;
import org.eclipse.ui.internal.cheatsheets.composite.parser.TaskGroupParseStrategy;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ITaskGroup;

public class TaskGroup
extends AbstractTask
implements ITaskGroup {
    private final ITaskParseStrategy parserStrategy;
    private ArrayList<ICompositeCheatSheetTask> subtasks;
    private final CompletionStrategy completionStrategy;

    public TaskGroup(CompositeCheatSheetModel model, String id, String name, String kind) {
        super(model, id, name, kind);
        if (kind == null) {
            this.kind = "set";
        }
        this.parserStrategy = new TaskGroupParseStrategy();
        this.completionStrategy = this.determineCompletionStrategy(kind);
    }

    private CompletionStrategy determineCompletionStrategy(String kind) {
        if ("choice".equals(kind)) {
            return new TaskChoiceCompletionStrategy();
        }
        return new TaskSetCompletionStrategy();
    }

    @Override
    public ITaskParseStrategy getParserStrategy() {
        return this.parserStrategy;
    }

    @Override
    public ICompositeCheatSheetTask[] getSubtasks() {
        if (this.subtasks == null) {
            return EMPTY;
        }
        return this.subtasks.toArray(new ICompositeCheatSheetTask[this.subtasks.size()]);
    }

    public void addSubtask(ICompositeCheatSheetTask task) {
        if (this.subtasks == null) {
            this.subtasks = new ArrayList();
        }
        this.subtasks.add(task);
        ((AbstractTask)task).setParent(this);
    }

    public void checkState() {
        int newState = this.computeState();
        if (newState != this.state) {
            this.setStateNoNotify(newState);
        }
    }

    public int computeState() {
        return this.completionStrategy.computeState(this);
    }

    public static interface CompletionStrategy {
        public int computeState(TaskGroup var1);
    }
}

