/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.evaluation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> evalVisitor;
    private EvaluationEnvironment<C, O, P, CLS, E> env;
    private boolean done = false;

    protected IterationTemplate(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> v) {
        this.evalVisitor = v;
        this.env = v.getEvaluationEnvironment();
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> IterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getInstance(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> v) {
        return new IterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(v);
    }

    public EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getEvaluationVisitor() {
        return this.evalVisitor;
    }

    public EvaluationEnvironment<C, O, P, CLS, E> getEvalEnvironment() {
        return this.env;
    }

    public final void setDone(boolean done) {
        this.done = done;
    }

    public final boolean isDone() {
        return this.done;
    }

    public Object evaluate(Collection<?> coll, List<Variable<C, PM>> iterators, OCLExpression<C> body, String resultName) {
        if (coll.isEmpty()) {
            return this.env.getValueOf(resultName);
        }
        int numIters = iterators.size();
        Iterator[] javaIters = new Iterator[numIters];
        try {
            this.initializeIterators(iterators, javaIters, coll);
            while (true) {
                Object bodyVal = this.evalVisitor.visitExpression(body);
                Object resultVal = this.evaluateResult(iterators, resultName, bodyVal);
                this.env.replace(resultName, resultVal);
                int curr = this.getNextUnfinishedIterator(javaIters);
                if (!this.moreToGo(curr, numIters)) break;
                this.advanceIterators(iterators, javaIters, coll, curr);
            }
            Object object = this.env.getValueOf(resultName);
            return object;
        }
        finally {
            this.removeIterators(iterators);
        }
    }

    protected void initializeIterators(List<Variable<C, PM>> iterators, Iterator<?>[] javaIters, Collection<?> c) {
        int i = 0;
        int n = javaIters.length;
        while (i < n) {
            javaIters[i] = c.iterator();
            Variable<C, PM> iterDecl = iterators.get(i);
            String iterName = (String)iterDecl.accept(this.evalVisitor);
            Object value = javaIters[i].next();
            this.env.replace(iterName, value);
            ++i;
        }
    }

    protected int getNextUnfinishedIterator(Iterator<?>[] javaIters) {
        int numIters = javaIters.length;
        int curr = 0;
        while (curr < numIters) {
            if (javaIters[curr].hasNext()) break;
            ++curr;
        }
        return curr;
    }

    protected void advanceIterators(List<Variable<C, PM>> iterators, Iterator<?>[] javaIters, Collection<?> c, int curr) {
        int i = 0;
        int n = curr;
        while (i <= n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            String iterName = iterDecl.getName();
            if (i != curr) {
                javaIters[i] = c.iterator();
            }
            Object value = javaIters[i].next();
            this.env.replace(iterName, value);
            ++i;
        }
    }

    protected void removeIterators(List<Variable<C, PM>> iterators) {
        int i = 0;
        int n = iterators.size();
        while (i < n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            String iterName = iterDecl.getName();
            this.env.remove(iterName);
            ++i;
        }
    }

    protected boolean moreToGo(int curr, int numIters) {
        if (this.done) {
            return false;
        }
        return curr < numIters;
    }

    protected Object evaluateResult(List<Variable<C, PM>> iterators, String resultName, Object bodyVal) {
        return bodyVal;
    }

    protected OCLStandardLibrary<C> getOCLStandardLibrary() {
        return this.evalVisitor.getEnvironment().getOCLStandardLibrary();
    }

    protected Object getInvalid() {
        return this.getOCLStandardLibrary().getInvalid();
    }
}

