/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.ManifestResource;
import aQute.bnd.osgi.Resource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.bnd.FileResource;
import org.eclipse.pde.internal.core.project.PDEProject;

public class ProjectJar
extends Jar {
    public static final QualifiedName GENERATED_PROPERTY = new QualifiedName("org.eclipse.pde.core", "bndgenerated");
    private final IContainer outputFolder;
    private IFile manifestFile;
    private final Map<String, IFile> orphanFilesMap = new HashMap<String, IFile>();

    public ProjectJar(IProject project, Predicate<IResource> filter) throws CoreException {
        super(project.getName());
        this.outputFolder = PDEProject.getJavaOutputFolder(project);
        Predicate<IResource> resourceScanner = r -> {
            if (r instanceof IFile) {
                IFile f = (IFile)r;
                try {
                    String path = r.getPersistentProperty(GENERATED_PROPERTY);
                    if (path != null) {
                        this.orphanFilesMap.put(path, f);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return filter.test((IResource)r);
        };
        FileResource.addResources(this, this.outputFolder, resourceScanner);
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IClasspathEntry[] classpath;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getResolvedClasspath(true);
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IPath location;
                IClasspathEntry cp = iClasspathEntryArray[n2];
                if (cp.getEntryKind() == 3 && !cp.isTest() && (location = cp.getOutputLocation()) != null) {
                    IFolder otherOutputFolder = workspaceRoot.getFolder(location);
                    FileResource.addResources(this, (IContainer)otherOutputFolder, resourceScanner);
                }
                ++n2;
            }
        }
        this.manifestFile = PDEProject.getManifest(project);
    }

    public void setManifest(Manifest manifest) {
        super.setManifest(manifest);
        ManifestResource resource = new ManifestResource(manifest);
        this.putResource("META-INF/MANIFEST.MF", (Resource)resource);
        IFile file = this.outputFolder.getFile(IPath.fromOSString((String)"META-INF/MANIFEST.MF"));
        if (!file.getFullPath().equals((Object)this.manifestFile.getFullPath())) {
            block30: {
                if (this.manifestFile.exists()) {
                    try {
                        Throwable throwable = null;
                        Object var5_14 = null;
                        try (InputStream stream = resource.openInputStream();){
                            this.manifestFile.setContents(stream, true, false, null);
                            break block30;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    this.mkdirs((IResource)this.manifestFile);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                try {
                    Throwable e = null;
                    Object var5_16 = null;
                    try (InputStream stream = resource.openInputStream();){
                        this.manifestFile.create(stream, true, null);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.manifestFile.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public boolean putResource(String path, Resource resource, boolean overwrite) {
        if (resource instanceof FileResource) {
            return super.putResource(path, resource, overwrite);
        }
        IFile file = this.outputFolder.getFile(IPath.fromOSString((String)path));
        try {
            if (file.exists()) {
                if (overwrite) {
                    Throwable throwable = null;
                    Object var6_11 = null;
                    try (InputStream stream = resource.openInputStream();){
                        file.setContents(stream, true, false, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            } else {
                this.mkdirs((IResource)file);
                Throwable throwable = null;
                Object var6_13 = null;
                try (InputStream stream = resource.openInputStream();){
                    file.create(stream, true, null);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            file.setPersistentProperty(GENERATED_PROPERTY, path);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.orphanFilesMap.remove(path);
        return super.putResource(path, (Resource)new FileResource(file), overwrite);
    }

    private void mkdirs(IResource resource) throws CoreException {
        IFolder folder;
        if (resource == null) {
            return;
        }
        this.mkdirs((IResource)resource.getParent());
        if (resource instanceof IFolder && !(folder = (IFolder)resource).exists()) {
            folder.create(true, true, null);
        }
    }

    public String toString() {
        return "Project" + super.toString();
    }

    public void close() {
        this.cleanup();
        super.close();
    }

    private void cleanup() {
        for (IFile file : this.orphanFilesMap.values()) {
            try {
                file.delete(true, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

