/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.CatchAllValue;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.ProfileManager;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class PDEState
implements IPDEBuildConstants,
IBuildPropertiesConstants {
    private static final ILog LOGGER = ILog.get();
    private static final String[] MANIFEST_ENTRIES = new String[]{"Bundle-Localization", "Bundle-Name", "Bundle-Vendor", "Eclipse-BundleShape", "Eclipse-SourceBundle", "Eclipse-SourceReferences"};
    private static final int LAST_SUPPORTED_JDK = Integer.parseInt(JavaCore.latestSupportedJavaVersion());
    private StateObjectFactory factory = BundleHelper.getPlatformAdmin().getFactory();
    protected State state = this.factory.createState(false);
    private long id;
    private Properties repositoryVersions;
    private Properties sourceReferences;
    private HashMap<Long, String[]> bundleClasspaths;
    private ProfileManager profileManager;
    private Map<Long, String> patchBundles;
    private List<BundleDescription> addedBundle;
    private List<BundleDescription> unqualifiedBundles;
    private Properties platformProperties;
    private List<BundleDescription> sortedBundles = null;
    private final Set<Dictionary<String, String>> convertedManifests;
    private long lastSortingDate = 0L;
    private String[] eeSources;
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Map<String, List<String>> PRE_JAVA_9_SYSTEM_PACKAGES = Map.of("J2SE-1.2", List.of("java.applet", "java.awt", "java.awt.color", "java.awt.datatransfer", "java.awt.dnd", "java.awt.dnd.peer", "java.awt.event", "java.awt.font", "java.awt.geom", "java.awt.im", "java.awt.image", "java.awt.image.renderable", "java.awt.peer", "java.awt.print", "java.awt.resources", "java.beans", "java.beans.beancontext", "java.io", "java.lang", "java.lang.ref", "java.lang.reflect", "java.math", "java.net", "java.rmi", "java.rmi.activation", "java.rmi.dgc", "java.rmi.registry", "java.rmi.server", "java.security", "java.security.acl", "java.security.cert", "java.security.interfaces", "java.security.spec", "java.sql", "java.text", "java.text.resources", "java.util", "java.util.jar", "java.util.zip"));

    protected long getNextId() {
        return ++this.id;
    }

    public PDEState(PDEUIStateWrapper initialState) {
        this();
        this.state = initialState.getState();
        this.factory = this.state.getFactory();
        this.id = initialState.getNextId();
        this.bundleClasspaths = initialState.getClasspaths();
        this.patchBundles = initialState.getPatchData();
        this.addedBundle = new ArrayList<BundleDescription>();
        this.unqualifiedBundles = new ArrayList<BundleDescription>();
        BundleDescription[] bundleDescriptionArray = this.state.getBundles();
        int n = bundleDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            Dictionary<String, String> manifest = this.loadManifest(new File(bundle.getLocation()));
            this.rememberManifestEntries(bundle, manifest, MANIFEST_ENTRIES);
            ++n2;
        }
    }

    public PDEState() {
        this.state.setResolver(BundleHelper.getPlatformAdmin().createResolver());
        this.id = 0L;
        this.bundleClasspaths = new HashMap();
        this.patchBundles = new HashMap<Long, String>();
        this.convertedManifests = new HashSet<Dictionary<String, String>>(2);
        this.loadPluginTagFile();
        this.loadSourceReferences();
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public boolean addBundleDescription(BundleDescription toAdd) {
        return this.state.addBundle(toAdd);
    }

    public boolean addBundle(Dictionary<String, String> enhancedManifest, File bundleLocation) {
        String oldVersion = this.updateVersionNumber(enhancedManifest);
        try {
            BundleDescription descriptor = this.factory.createBundleDescription(this.state, enhancedManifest, bundleLocation.getAbsolutePath(), this.getNextId());
            this.bundleClasspaths.put(descriptor.getBundleId(), BundleHelper.getClasspath(enhancedManifest));
            String patchValue = this.fillPatchData(enhancedManifest);
            if (patchValue != null) {
                this.patchBundles.put(descriptor.getBundleId(), patchValue);
            }
            this.rememberQualifierTagPresence(descriptor);
            this.rememberManifestConversion(descriptor, enhancedManifest);
            this.rememberManifestEntries(descriptor, enhancedManifest, MANIFEST_ENTRIES);
            this.rememberSourceReference(descriptor, oldVersion);
            if (this.addBundleDescription(descriptor) && this.addedBundle != null) {
                this.addedBundle.add(descriptor);
            }
        }
        catch (BundleException e) {
            Status status = new Status(2, "org.eclipse.pde.build", 15, NLS.bind((String)Messages.exception_stateAddition, (Object)BundleHelper.getManifestHeader(enhancedManifest, "Bundle-Name")), (Throwable)e);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return false;
        }
        return true;
    }

    private void rememberQualifierTagPresence(BundleDescription descriptor) {
        Properties bundleProperties = null;
        bundleProperties = (Properties)descriptor.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            descriptor.setUserObject((Object)bundleProperties);
        }
        bundleProperties.setProperty("qualifier", "marker");
    }

    private void rememberSourceReference(BundleDescription descriptor, String oldVersion) {
        if (this.sourceReferences == null) {
            return;
        }
        Object key = QualifierReplacer.getQualifierKey(descriptor.getSymbolicName(), oldVersion);
        if (key == null || !this.sourceReferences.containsKey(key)) {
            key = descriptor.getSymbolicName() + "," + Version.emptyVersion.toString();
        }
        if (this.sourceReferences.containsKey(key)) {
            Properties bundleProperties = (Properties)descriptor.getUserObject();
            if (bundleProperties == null) {
                bundleProperties = new Properties();
                descriptor.setUserObject((Object)bundleProperties);
            }
            bundleProperties.setProperty("sourceReference", this.sourceReferences.getProperty((String)key));
        }
    }

    private void rememberManifestEntries(BundleDescription descriptor, Dictionary<String, String> manifest, String[] entries) {
        if (entries == null || entries.length == 0) {
            return;
        }
        Properties properties = (Properties)descriptor.getUserObject();
        if (properties == null) {
            properties = new Properties();
            descriptor.setUserObject((Object)properties);
        }
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry2 = stringArray[n2];
            String entry = BundleHelper.getManifestHeader(manifest, entry2);
            if (entry != null) {
                properties.put(entry2, entry);
            }
            ++n2;
        }
    }

    private void rememberManifestConversion(BundleDescription descriptor, Dictionary<String, String> manifest) {
        if (this.convertedManifests == null || !this.convertedManifests.contains(manifest)) {
            return;
        }
        this.convertedManifests.remove(manifest);
        Properties bundleProperties = (Properties)descriptor.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            descriptor.setUserObject((Object)bundleProperties);
        }
        bundleProperties.setProperty("convertedManifest", "marker");
    }

    private void mapVersionReplacedBundle(BundleDescription oldBundle, BundleDescription newBundle) {
        Properties bundleProperties = null;
        bundleProperties = (Properties)oldBundle.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            oldBundle.setUserObject((Object)bundleProperties);
        }
        bundleProperties.setProperty("versionReplacement", String.valueOf(newBundle.getBundleId()));
    }

    private String fillPatchData(Dictionary<String, String> manifest) {
        if (BundleHelper.getManifestHeader(manifest, "Eclipse-ExtensibleAPI") != null) {
            return "Eclipse-ExtensibleAPI: true";
        }
        if (BundleHelper.getManifestHeader(manifest, "Eclipse-PatchFragment") != null) {
            return "Eclipse-PatchFragment: true";
        }
        return null;
    }

    private void loadPluginTagFile() {
        this.repositoryVersions = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(AbstractScriptGenerator.getWorkingDirectory() + "/pluginVersions.properties"));){
                this.repositoryVersions.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadSourceReferences() {
        this.sourceReferences = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(AbstractScriptGenerator.getWorkingDirectory() + "/sourceReferences.properties"));){
                this.sourceReferences.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean addBundle(File bundleLocation) {
        Dictionary<String, String> manifest = this.loadManifest(bundleLocation);
        if (manifest == null) {
            return this.addFlexibleRoot(bundleLocation);
        }
        try {
            this.hasQualifier(bundleLocation, manifest);
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        return this.addBundle(manifest, bundleLocation);
    }

    private boolean addFlexibleRoot(File bundleLocation) {
        if (!new File(bundleLocation, ".settings/org.eclipse.pde.core.prefs").exists()) {
            return false;
        }
        try {
            Properties properties = AbstractScriptGenerator.readProperties(bundleLocation.getAbsolutePath(), ".settings/org.eclipse.pde.core.prefs", 0);
            String root = properties.getProperty("BUNDLE_ROOT_PATH");
            if (root != null) {
                return this.addBundle(new File(bundleLocation, root));
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private String updateVersionNumber(Dictionary<String, String> manifest) {
        String symbolicName;
        String oldVersion;
        String newVersion;
        block4: {
            newVersion = null;
            oldVersion = null;
            symbolicName = BundleHelper.getManifestHeader(manifest, "Bundle-SymbolicName");
            if (symbolicName != null) break block4;
            return null;
        }
        try {
            symbolicName = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName)[0].getValue();
            oldVersion = BundleHelper.getManifestHeader(manifest, "Bundle-Version");
            newVersion = QualifierReplacer.replaceQualifierInVersion(oldVersion, symbolicName, manifest.get("qualifier"), this.repositoryVersions);
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        if (newVersion != null) {
            manifest.put("Bundle-Version", newVersion);
        }
        return oldVersion;
    }

    private void hasQualifier(File bundleLocation, Dictionary<String, String> manifest) throws BundleException {
        ManifestElement[] versionInfo = ManifestElement.parseHeader((String)"Bundle-Version", (String)BundleHelper.getManifestHeader(manifest, "Bundle-Version"));
        if (versionInfo != null && versionInfo[0].getValue().endsWith("qualifier")) {
            manifest.put("qualifier", this.getQualifierPropery(bundleLocation.getAbsolutePath()));
        }
    }

    private String getQualifierPropery(String bundleLocation) {
        String qualifierInfo = null;
        try {
            qualifierInfo = AbstractScriptGenerator.readProperties(bundleLocation, "build.properties", 1).getProperty("qualifier");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (qualifierInfo == null) {
            qualifierInfo = "context";
        }
        return qualifierInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Dictionary<String, String> basicLoadManifest(File bundleLocation) {
        try {
            if ("jar".equalsIgnoreCase(IPath.fromOSString((String)bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile()) {
                Throwable throwable = null;
                Object var3_7 = null;
                try (ZipFile jarFile = new ZipFile(bundleLocation, 1);){
                    InputStream manifestStream;
                    block24: {
                        ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                        if (manifestEntry == null) return null;
                        Throwable throwable2 = null;
                        Object var7_16 = null;
                        try {
                            Hashtable<String, String> hashtable;
                            manifestStream = jarFile.getInputStream(manifestEntry);
                            try {
                                if (manifestStream == null) break block24;
                                hashtable = new Hashtable<String, String>(ManifestElement.parseBundleManifest((InputStream)manifestStream, null));
                                if (manifestStream == null) return hashtable;
                            }
                            catch (Throwable throwable3) {
                                if (manifestStream == null) throw throwable3;
                                manifestStream.close();
                                throw throwable3;
                            }
                            manifestStream.close();
                            return hashtable;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            }
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                            throw throwable2;
                        }
                    }
                    if (manifestStream == null) return null;
                    manifestStream.close();
                    return null;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var3_9 = null;
            try (FileInputStream manifestStream = new FileInputStream(new File(bundleLocation, "META-INF/MANIFEST.MF"));){
                return new Hashtable<String, String>(ManifestElement.parseBundleManifest((InputStream)manifestStream, null));
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        catch (IOException | BundleException throwable) {
            // empty catch block
        }
        return null;
    }

    private boolean enforceSymbolicName(File bundleLocation, Dictionary<String, String> initialManifest) {
        return BundleHelper.getManifestHeader(initialManifest, "Bundle-SymbolicName") != null;
    }

    private void enforceClasspath(Dictionary<String, String> manifest) {
        String classpath = BundleHelper.getManifestHeader(manifest, "Bundle-ClassPath");
        if (classpath == null) {
            manifest.put("Bundle-ClassPath", ".");
        }
    }

    private void enforceVersion(Dictionary<String, String> manifest) {
        String version = BundleHelper.getManifestHeader(manifest, "Bundle-Version");
        if (version == null) {
            manifest.put("Bundle-Version", "0.0.0");
        }
    }

    private Dictionary<String, String> loadManifest(File bundleLocation) {
        Dictionary<String, String> manifest = this.basicLoadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        if (!this.enforceSymbolicName(bundleLocation, manifest)) {
            return null;
        }
        this.enforceVersion(manifest);
        this.enforceClasspath(manifest);
        return manifest;
    }

    public void addBundles(Collection<File> bundles) {
        for (File bundle : bundles) {
            this.addBundle(bundle);
        }
    }

    public void resolveState() {
        Hashtable<String, Object> prop;
        List<Config> configs = AbstractScriptGenerator.getConfigInfos();
        ArrayList properties = new ArrayList();
        String[] javaProfiles = this.getJavaProfiles();
        String ee = null;
        for (Config aConfig : configs) {
            prop = new Hashtable<String, Object>();
            if (AbstractScriptGenerator.getPropertyAsBoolean("resolution.devMode")) {
                ((Dictionary)prop).put("osgi.resolverMode", "development");
            }
            String os = aConfig.getOs();
            String ws = aConfig.getWs();
            String arch = aConfig.getArch();
            if (Config.ANY.equalsIgnoreCase(os)) {
                ((Dictionary)prop).put("osgi.os", CatchAllValue.singleton);
            } else {
                ((Dictionary)prop).put("osgi.os", os);
            }
            if (Config.ANY.equalsIgnoreCase(ws)) {
                ((Dictionary)prop).put("osgi.ws", CatchAllValue.singleton);
            } else {
                ((Dictionary)prop).put("osgi.ws", ws);
            }
            if (Config.ANY.equalsIgnoreCase(arch)) {
                ((Dictionary)prop).put("osgi.arch", CatchAllValue.singleton);
            } else {
                ((Dictionary)prop).put("osgi.arch", arch);
            }
            if (this.platformProperties != null) {
                Enumeration<Object> enumeration = this.platformProperties.keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    ((Dictionary)prop).put(key, this.platformProperties.get(key));
                }
            }
            properties.add(prop);
        }
        Properties profileProps = null;
        boolean added = false;
        String eeJava9 = null;
        int j = javaProfiles.length - 1;
        while (j >= 0) {
            String profileName;
            profileProps = this.profileManager.getProfileProperties(javaProfiles[j]);
            if (profileProps != null && (AbstractScriptGenerator.getImmutableAntProperty(profileName = profileProps.getProperty("osgi.java.profile.name")) != null || j == 0 && !added)) {
                IExecutionEnvironment iExecutionEnvironment = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(javaProfiles[j]);
                String systemPackages = PDEState.getSystemPackages(iExecutionEnvironment, profileProps);
                ee = profileProps.getProperty("org.osgi.framework.executionenvironment");
                prop = new Hashtable();
                ((Dictionary)prop).put("org.osgi.framework.system.packages", systemPackages);
                if (profileName.equals("JavaSE-9")) {
                    eeJava9 = ee;
                }
                ((Dictionary)prop).put("org.osgi.framework.executionenvironment", ee);
                properties.add(prop);
                added = true;
            }
            --j;
        }
        ArrayList<CallSite> eeJava10AndBeyond = new ArrayList<CallSite>();
        int i = 10;
        while (i <= LAST_SUPPORTED_JDK) {
            eeJava10AndBeyond.add((CallSite)((Object)("JavaSE-" + i)));
            ++i;
        }
        prop = new Hashtable();
        Object previousEE = eeJava9;
        for (String string : eeJava10AndBeyond) {
            prop = new Hashtable();
            IExecutionEnvironment env = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(string);
            String systemPackages = PDEState.getSystemPackages(env, null);
            String currentEE = previousEE + "," + string;
            if (systemPackages == null) {
                previousEE = currentEE;
                continue;
            }
            ((Dictionary)prop).put("org.osgi.framework.system.packages", systemPackages);
            ((Dictionary)prop).put("org.osgi.framework.executionenvironment", currentEE);
            previousEE = currentEE;
            properties.add(prop);
        }
        Dictionary[] dictionaryArray = properties.toArray(new Dictionary[properties.size()]);
        this.state.setPlatformProperties(dictionaryArray);
        this.state.resolve(false);
        if (this.unqualifiedBundles != null) {
            this.forceQualifiers();
        }
    }

    public static String getSystemPackages(IExecutionEnvironment environment, Properties profileProperties) {
        String systemPackages = PDEState.querySystemPackages(environment, profileProperties);
        if (systemPackages.isBlank() && profileProperties != null) {
            systemPackages = profileProperties.getProperty("org.osgi.framework.system.packages");
        }
        if (systemPackages == null || systemPackages.isBlank()) {
            if (PDEState.compatibleVMsFor(environment, s -> s).findAny().isPresent()) {
                LOGGER.warn("No JVM system-packages available for environment " + String.valueOf(environment));
            }
            return null;
        }
        return systemPackages;
    }

    public static String querySystemPackages(IExecutionEnvironment environment, Properties preJava9ProfileProperties) {
        Collection systemPackages;
        if (environment == null) {
            return "";
        }
        String eeId = environment.getId();
        Integer releaseVersion = PDEState.readJavaReleaseVersion(eeId);
        if (releaseVersion == null) {
            return "";
        }
        if (releaseVersion <= 8) {
            Optional<Collection> strictVMSystemPackages = PDEState.compatibleVMsFor(environment, vms -> vms.filter(arg_0 -> ((IExecutionEnvironment)environment).isStrictlyCompatible(arg_0))).map(vm -> PDEState.querySystemPackages(vm, null)).filter(Objects::nonNull).findFirst();
            systemPackages = strictVMSystemPackages.orElseGet(() -> {
                IVMInstall targetVM;
                List<String> javaPackages = PRE_JAVA_9_SYSTEM_PACKAGES.get(eeId);
                if (javaPackages == null) {
                    String profileSystemPackages = preJava9ProfileProperties.getProperty("org.osgi.framework.system.packages", "");
                    if (profileSystemPackages.isBlank()) {
                        return List.of();
                    }
                    javaPackages = COMMA.splitAsStream(profileSystemPackages).filter(p -> p.startsWith("java.")).toList();
                }
                if ((targetVM = JavaRuntime.getDefaultVMInstall()) == null) {
                    LOGGER.warn("No default JRE installation selected");
                    return List.of();
                }
                Collection<String> targetVMSystemPackages = PDEState.querySystemPackages(targetVM, null);
                if (targetVMSystemPackages == null) {
                    return List.of();
                }
                Stream<String> targetVMNonJavaPackages = targetVMSystemPackages.stream().filter(p -> !p.startsWith("java."));
                return Stream.concat(javaPackages.stream(), targetVMNonJavaPackages).sorted().toList();
            });
        } else {
            Comparator<IVMInstall> strictlyCompatibleFirst = Comparator.comparing(arg_0 -> ((IExecutionEnvironment)environment).isStrictlyCompatible(arg_0)).reversed();
            systemPackages = PDEState.compatibleVMsFor(environment, vms -> vms.sorted(strictlyCompatibleFirst)).map(vm -> PDEState.querySystemPackages(vm, environment)).filter(Objects::nonNull).findFirst().orElse(List.of());
        }
        return String.join((CharSequence)",", systemPackages);
    }

    private static Integer readJavaReleaseVersion(String eeId) {
        if (eeId.startsWith("JavaSE-")) {
            try {
                return Integer.parseInt(eeId.substring("JavaSE-".length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return switch (eeId) {
            case "JRE-1.1" -> 1;
            case "J2SE-1.2" -> 2;
            case "J2SE-1.3" -> 3;
            case "J2SE-1.4" -> 4;
            case "J2SE-1.5" -> 5;
            case "JavaSE-1.6" -> 6;
            case "JavaSE-1.7" -> 7;
            case "JavaSE-1.8" -> 8;
            default -> null;
        };
    }

    private static Collection<String> querySystemPackages(IVMInstall vm, IExecutionEnvironment environment) {
        try {
            String release = environment != null ? environment.getProfileProperties().getProperty("org.eclipse.jdt.core.compiler.compliance") : null;
            return JavaRuntime.getProvidedVMPackages((IVMInstall)vm, (String)release);
        }
        catch (CoreException e) {
            ILog.of(PDEState.class).log(Status.error((String)("Failed to read system packages for " + String.valueOf(environment)), (Throwable)e));
            return null;
        }
    }

    private static Stream<IVMInstall> compatibleVMsFor(IExecutionEnvironment environment, UnaryOperator<Stream<IVMInstall>> vmInstallsFilter) {
        IVMInstall defaultVM = environment.getDefaultVM();
        if (defaultVM != null) {
            return Stream.of(defaultVM);
        }
        return (Stream)vmInstallsFilter.apply(Arrays.stream(environment.getCompatibleVMs()));
    }

    public State getState() {
        return this.state;
    }

    public BundleDescription[] getDependentBundles(String bundleId, Version version) {
        BundleDescription root = this.state.getBundle(bundleId, version);
        return PDEState.getDependentBundles(root);
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        ExportPackageDescription[] packages = root.getResolvedImports();
        ArrayList<BundleDescription> resolvedImports = new ArrayList<BundleDescription>(packages.length);
        ExportPackageDescription[] exportPackageDescriptionArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription package1 = exportPackageDescriptionArray[n2];
            if (!root.getLocation().equals(package1.getExporter().getLocation()) && !resolvedImports.contains(package1.getExporter())) {
                resolvedImports.add(package1.getExporter());
            }
            ++n2;
        }
        return resolvedImports.toArray(new BundleDescription[resolvedImports.size()]);
    }

    public static BundleDescription[] getRequiredBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        return root.getResolvedRequires();
    }

    public BundleDescription getResolvedBundle(String bundleId, String version) {
        return this.getBundle(bundleId, version, true);
    }

    public BundleDescription getBundle(String bundleId, String version, boolean resolved) {
        if ("0.0.0".equals(version) || version == null) {
            BundleDescription bundle = this.getResolvedBundle(bundleId);
            if (bundle == null && !resolved) {
                bundle = this.getState().getBundle(bundleId, null);
            }
            return bundle;
        }
        Version parsedVersion = Version.parseVersion((String)version);
        BundleDescription description = this.getState().getBundle(bundleId, parsedVersion);
        if (description != null && (!resolved || description.isResolved())) {
            return description;
        }
        if (parsedVersion.getQualifier().indexOf("qualifier") > -1) {
            BundleDescription[] bundles = this.sortByVersion(this.getState().getBundles(bundleId));
            VersionRange qualifierRange = Utils.createVersionRange(version);
            int i = bundles.length - 1;
            while (i >= 0) {
                if (qualifierRange.isIncluded(bundles[i].getVersion()) && (!resolved || bundles[i].isResolved())) {
                    return bundles[i];
                }
                --i;
            }
        }
        return null;
    }

    private BundleDescription[] sortByVersion(BundleDescription[] bundles) {
        if (bundles.length > 1) {
            Arrays.sort(bundles, (o1, o2) -> o1.getVersion().compareTo(o2.getVersion()));
        }
        return bundles;
    }

    public BundleDescription getResolvedBundle(String bundleId) {
        BundleDescription[] description = this.sortByVersion(this.getState().getBundles(bundleId));
        if (description == null) {
            return null;
        }
        int i = description.length - 1;
        while (i >= 0) {
            if (description[i].isResolved()) {
                return description[i];
            }
            --i;
        }
        return null;
    }

    public static BundleDescription[] getDependentBundles(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    public static BundleDescription[] getDependentBundlesWithFragments(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] importedByFragments = PDEState.getImportedByFragments(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] requiredByFragments = PDEState.getRequiredByFragments(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + importedByFragments.length + required.length + requiredByFragments.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(importedByFragments, 0, dependents, imported.length, importedByFragments.length);
        System.arraycopy(required, 0, dependents, imported.length + importedByFragments.length, required.length);
        System.arraycopy(requiredByFragments, 0, dependents, imported.length + importedByFragments.length + required.length, requiredByFragments.length);
        return dependents;
    }

    public static BundleDescription[] getImportedByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList<BundleDescription> importedByFragments = new ArrayList<BundleDescription>();
        BundleDescription[] bundleDescriptionArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription fragment2 = bundleDescriptionArray[n2];
            if (fragment2.isResolved()) {
                PDEState.merge(importedByFragments, PDEState.getImportedBundles(fragment2));
            }
            ++n2;
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static BundleDescription[] getRequiredByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList<BundleDescription> importedByFragments = new ArrayList<BundleDescription>();
        BundleDescription[] bundleDescriptionArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription fragment2 = bundleDescriptionArray[n2];
            if (fragment2.isResolved()) {
                PDEState.merge(importedByFragments, PDEState.getRequiredBundles(fragment2));
            }
            ++n2;
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static void merge(List<BundleDescription> source, BundleDescription[] toAdd) {
        BundleDescription[] bundleDescriptionArray = toAdd;
        int n = toAdd.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription element = bundleDescriptionArray[n2];
            if (!source.contains(element)) {
                source.add(element);
            }
            ++n2;
        }
    }

    public Properties loadPropertyFileIn(Map<String, String> toMerge, File location) {
        Properties result = new Properties();
        result.putAll(toMerge);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream propertyStream = new BufferedInputStream(new FileInputStream(new File(location, "build.properties")));){
                result.load(propertyStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public HashMap<Long, String[]> getExtraData() {
        return this.bundleClasspaths;
    }

    public Map<Long, String> getPatchData() {
        return this.patchBundles;
    }

    public List<BundleDescription> getSortedBundles() {
        if (this.lastSortingDate != this.getState().getTimeStamp()) {
            this.lastSortingDate = this.getState().getTimeStamp();
            BundleDescription[] toSort = this.getState().getResolvedBundles();
            BundleHelper.getPlatformAdmin().getStateHelper().sortBundles(toSort);
            this.sortedBundles = Arrays.asList(toSort);
        }
        return this.sortedBundles;
    }

    public void cleanupOriginalState() {
        BundleDescription[] allBundles;
        if (this.addedBundle == null && this.unqualifiedBundles == null) {
            return;
        }
        for (BundleDescription added : this.addedBundle) {
            this.state.removeBundle(added);
        }
        this.addedBundle.clear();
        for (BundleDescription toAddBack : this.unqualifiedBundles) {
            this.state.removeBundle(toAddBack.getBundleId());
            this.addBundleDescription(toAddBack);
        }
        this.unqualifiedBundles.clear();
        BundleDescription[] bundleDescriptionArray = allBundles = this.state.getBundles();
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            bundle.setUserObject(null);
            ++n2;
        }
        this.state.resolve();
    }

    private String[] getJavaProfiles() {
        return this.getProfileManager().getJavaProfiles();
    }

    private void forceQualifiers() {
        BundleDescription[] resolvedBundles;
        BundleDescription[] bundleDescriptionArray = resolvedBundles = this.state.getResolvedBundles();
        int n = resolvedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription b = bundleDescriptionArray[n2];
            if (b.getVersion().getQualifier().endsWith("qualifier")) {
                this.unqualifiedBundles.add(this.state.removeBundle(b.getBundleId()));
                String newVersion = QualifierReplacer.replaceQualifierInVersion(b.getVersion().toString(), b.getSymbolicName(), this.getQualifierPropery(b.getLocation()), null);
                BundleDescription newBundle = this.state.getFactory().createBundleDescription(b.getBundleId(), b.getSymbolicName(), new Version(newVersion), b.getLocation(), b.getRequiredBundles(), b.getHost(), b.getImportPackages(), b.getExportPackages(), b.isSingleton(), b.attachFragments(), b.dynamicFragments(), b.getPlatformFilter(), b.getExecutionEnvironments(), b.getGenericRequires(), b.getGenericCapabilities(), b.getNativeCodeSpecification());
                this.addBundleDescription(newBundle);
                this.rememberQualifierTagPresence(newBundle);
                this.mapVersionReplacedBundle(b, newBundle);
            }
            ++n2;
        }
        this.state.resolve();
    }

    public BundleDescription getVersionReplacement(BundleDescription bundle) {
        Properties props = (Properties)bundle.getUserObject();
        if (props == null) {
            return bundle;
        }
        String idString = props.getProperty("versionReplacement");
        if (idString == null) {
            return bundle;
        }
        try {
            long newId = Long.parseLong(idString);
            BundleDescription newBundle = this.state.getBundle(newId);
            if (newBundle != null) {
                return newBundle;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bundle;
    }

    public void setPlatformProperties(Properties platformProperties) {
        this.platformProperties = platformProperties;
    }

    public void setEESources(String[] eeSources) {
        this.eeSources = eeSources;
    }

    public ProfileManager getProfileManager() {
        if (this.profileManager == null) {
            this.profileManager = new ProfileManager(this.eeSources, true);
        }
        return this.profileManager;
    }
}

