/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.internal.ids.AbstractTypeId;
import org.eclipse.ocl.pivot.internal.ids.EnumerationLiteralIdImpl;

public class EnumerationIdImpl
extends AbstractTypeId
implements EnumerationId {
    protected final @NonNull PackageId parent;
    protected final @NonNull String name;
    protected final int hashCode;
    private @Nullable EnumerationLiteralIdImpl.EnumerationLiteralIdSingletonScope memberEnumerationLiterals = null;

    private static int computeHashCode(@NonNull ElementId parentId, @NonNull String name) {
        return IdHash.createChildHash(parentId, name);
    }

    public EnumerationIdImpl(@NonNull PackageId parentId, @NonNull String name) {
        this.parent = parentId;
        this.name = name;
        this.hashCode = EnumerationIdImpl.computeHashCode(parentId, name);
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitEnumerationId(this);
    }

    @Override
    public @NonNull String getDisplayName() {
        if (this.parent instanceof NsURIPackageId) {
            return this.name;
        }
        return this.parent + "::" + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull EnumerationLiteralId getEnumerationLiteralId(@NonNull String name) {
        EnumerationLiteralIdImpl.EnumerationLiteralIdSingletonScope memberEnumerationLiterals2 = this.memberEnumerationLiterals;
        if (memberEnumerationLiterals2 == null) {
            EnumerationIdImpl enumerationIdImpl = this;
            synchronized (enumerationIdImpl) {
                memberEnumerationLiterals2 = this.memberEnumerationLiterals;
                if (memberEnumerationLiterals2 == null) {
                    this.memberEnumerationLiterals = memberEnumerationLiterals2 = new EnumerationLiteralIdImpl.EnumerationLiteralIdSingletonScope();
                }
            }
        }
        return memberEnumerationLiterals2.getSingleton(this, name);
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return "Enumeration";
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull PackageId getParent() {
        return this.parent;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.parent + "::" + this.name;
    }

    public static class EnumerationIdSingletonScope
    extends AbstractSingletonScope<EnumerationId, String> {
        public @NonNull EnumerationId getSingleton(@NonNull PackageId parentId, @NonNull String value) {
            return this.getSingletonFor(new EnumerationIdValue(parentId, value));
        }
    }

    private static class EnumerationIdValue
    extends SingletonScope.AbstractKeyAndValue<EnumerationId> {
        private final @NonNull PackageId parentId;
        private final @NonNull String value;

        private EnumerationIdValue(@NonNull PackageId parentId, @NonNull String value) {
            super(EnumerationIdImpl.computeHashCode(parentId, value));
            this.parentId = parentId;
            this.value = value;
        }

        @Override
        public @NonNull EnumerationId createSingleton() {
            return new EnumerationIdImpl(this.parentId, this.value);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof EnumerationIdImpl) {
                EnumerationIdImpl singleton = (EnumerationIdImpl)that;
                return singleton.getName().equals(this.value);
            }
            return false;
        }
    }
}

