/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class LoggingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo levelCombo;
    private final String[] LOG_LEVELS = new String[]{"OFF", "INFO", "DEBUG"};

    public LoggingPreferencePage() {
    }

    public LoggingPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public LoggingPreferencePage(String title) {
        super(title);
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.emf.compare.rcp");
        store.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE});
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        Composite loggingComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(loggingComposite);
        new Label(loggingComposite, 16384).setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.level"));
        this.levelCombo = new Combo(loggingComposite, 4);
        this.levelCombo.setItems(this.LOG_LEVELS);
        this.levelCombo.setLayoutData((Object)this.getDefaultFieldGridData(100));
        this.refreshWidgets();
        return loggingComposite;
    }

    protected GridData getDefaultFieldGridData(int width) {
        GridData gd = new GridData(16384, 128, false, false, 2, 1);
        gd.widthHint = width;
        return gd;
    }

    protected void savePreferences() throws BackingStoreException, IOException {
        String item = this.levelCombo.getItem(this.levelCombo.getSelectionIndex());
        this.getPreferenceStore().setValue("org.eclipse.emf.compare.log.level", item);
    }

    protected void resetPreferences() {
        this.getPreferenceStore().setToDefault("org.eclipse.emf.compare.log.level");
    }

    protected void refreshWidgets() {
        IPreferencesService prefsService = Platform.getPreferencesService();
        String level = prefsService.getString("org.eclipse.emf.compare.rcp", "org.eclipse.emf.compare.log.level", "OFF", null);
        this.levelCombo.select(Arrays.asList(this.LOG_LEVELS).indexOf(level));
        this.levelCombo.pack();
    }

    public boolean performOk() {
        try {
            this.savePreferences();
            this.refreshWidgets();
            return super.performOk();
        }
        catch (IOException | BackingStoreException e) {
            return false;
        }
    }

    protected void performDefaults() {
        this.resetPreferences();
        this.refreshWidgets();
        super.performDefaults();
    }
}

