/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.opposites;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.ocl.ecore.internal.OCLEcorePlugin;
import org.eclipse.ocl.ecore.opposites.AllInstancesContentAdapter;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOppositeEndFinder
implements OppositeEndFinder {
    private static DefaultOppositeEndFinder instanceForDefaultRegistry = null;
    private final Set<EPackage> packages;
    private final Map<EClass, Map<String, Set<EReference>>> oppositeCache;
    private final EPackage.Registry registry;

    public static DefaultOppositeEndFinder getInstance() {
        return DefaultOppositeEndFinder.getInstance(EPackage.Registry.INSTANCE);
    }

    public static DefaultOppositeEndFinder getInstance(EPackage.Registry registry) {
        DefaultOppositeEndFinder result;
        if (registry == EPackage.Registry.INSTANCE) {
            if (instanceForDefaultRegistry == null) {
                instanceForDefaultRegistry = new DefaultOppositeEndFinder(EPackage.Registry.INSTANCE);
            }
            result = instanceForDefaultRegistry;
        } else {
            result = new DefaultOppositeEndFinder(registry);
        }
        return result;
    }

    public DefaultOppositeEndFinder(EPackage.Registry registry) {
        this.registry = registry;
        this.packages = new HashSet<EPackage>();
        this.oppositeCache = new HashMap<EClass, Map<String, Set<EReference>>>();
    }

    @Override
    public void findOppositeEnds(EClassifier classifier, String name, List<EReference> ends) {
        if (classifier instanceof EClass) {
            Set<EReference> refs;
            EClass eClass = (EClass)classifier;
            this.updateOppositeCache();
            Map<String, Set<EReference>> oppositesOnEClass = this.oppositeCache.get(eClass);
            if (oppositesOnEClass != null && (refs = oppositesOnEClass.get(name)) != null) {
                Set<EReference> references = oppositesOnEClass.get(name);
                for (EReference ref : references) {
                    ends.add(ref);
                }
            }
            if (ends.isEmpty()) {
                for (EClassifier sup : eClass.getESuperTypes()) {
                    this.findOppositeEnds(sup, name, ends);
                }
            }
        }
    }

    @Override
    public Map<String, EReference> getAllOppositeEnds(EClassifier classifier) {
        HashMap<String, EReference> result = new HashMap<String, EReference>();
        if (classifier instanceof EClass) {
            EClass eClass = (EClass)classifier;
            this.updateOppositeCache();
            Map<String, Set<EReference>> oppositesOnClass = this.oppositeCache.get(eClass);
            if (oppositesOnClass != null) {
                for (String oppositeName : oppositesOnClass.keySet()) {
                    Set<EReference> refs = oppositesOnClass.get(oppositeName);
                    if (refs.size() <= 0) continue;
                    result.put(oppositeName, refs.iterator().next());
                }
            }
            for (EClassifier sup : eClass.getESuperTypes()) {
                Map<String, EReference> supOppositeEnds = this.getAllOppositeEnds(sup);
                for (String supOppositeEndName : supOppositeEnds.keySet()) {
                    if (result.containsKey(supOppositeEndName)) continue;
                    result.put(supOppositeEndName, supOppositeEnds.get(supOppositeEndName));
                }
            }
        }
        return result;
    }

    private synchronized void updateOppositeCache() {
        for (Object pkg : this.registry.values()) {
            EPackage ePackage;
            if (!(pkg instanceof EPackage) || !this.packages.add(ePackage = (EPackage)pkg)) continue;
            this.cachePackage(ePackage);
        }
    }

    private void cachePackage(EPackage ePackage) {
        for (EClassifier c : ePackage.getEClassifiers()) {
            if (!(c instanceof EClass)) continue;
            EClass eClass = (EClass)c;
            for (EReference ref : eClass.getEReferences()) {
                String oppositeName;
                EAnnotation ann = ref.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
                if (ann == null || (oppositeName = (String)ann.getDetails().get((Object)"Property.oppositeRoleName")) == null) continue;
                this.cache((EClass)ref.getEType(), oppositeName, ref);
            }
        }
    }

    private void cache(EClass c, String oppositeName, EReference ref) {
        Set<EReference> set;
        Map<String, Set<EReference>> cache = this.oppositeCache.get(c);
        if (cache == null) {
            cache = new HashMap<String, Set<EReference>>();
            this.oppositeCache.put(c, cache);
        }
        if ((set = cache.get(oppositeName)) == null) {
            set = new HashSet<EReference>();
            cache.put(oppositeName, set);
        }
        set.add(ref);
    }

    @Override
    public Collection<EObject> navigateOppositePropertyWithForwardScope(EReference property, EObject target) {
        return this.navigateOppositePropertyWithSymmetricScope(property, target);
    }

    @Override
    public Collection<EObject> navigateOppositePropertyWithBackwardScope(EReference property, EObject target) {
        return this.navigateOppositePropertyWithSymmetricScope(property, target);
    }

    private Collection<EObject> navigateOppositePropertyWithSymmetricScope(EReference property, EObject target) {
        Object result = null;
        if (property.isContainment()) {
            Object propertyValue;
            EObject resultCandidate = target.eContainer();
            if (resultCandidate != null && property.getEContainingClass().isInstance((Object)resultCandidate) && ((propertyValue = resultCandidate.eGet((EStructuralFeature)property)) == target || propertyValue instanceof Collection && ((Collection)propertyValue).contains(target))) {
                result = Collections.singleton(resultCandidate);
            }
        } else {
            ECrossReferenceAdapter crossReferenceAdapter = this.getCrossReferenceAdapter(target);
            if (crossReferenceAdapter != null) {
                result = CollectionUtil.createNewBag();
                Collection settings = crossReferenceAdapter.getInverseReferences(target);
                for (EStructuralFeature.Setting setting : settings) {
                    if (setting.getEStructuralFeature() != property) continue;
                    result.add(setting.getEObject());
                }
            } else {
                OCLEcorePlugin.warning(10, "Trying to reverse-navigate reference of " + target + " without ECrossReferenceAdapter attached");
            }
        }
        return result;
    }

    private ECrossReferenceAdapter getCrossReferenceAdapter(EObject target) {
        ECrossReferenceAdapter result = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)target);
        if (result == null && target.eContainer() != null) {
            result = this.getCrossReferenceAdapter(target.eContainer());
        }
        return result;
    }

    @Override
    public Set<EObject> getAllInstancesSeeing(EClass cls, Notifier context) {
        return AllInstancesContentAdapter.getInstanceForRootContextOf(context).allInstances(cls);
    }

    @Override
    public Set<EObject> getAllInstancesSeenBy(EClass cls, Notifier context) {
        return this.getAllInstancesSeeing(cls, context);
    }
}

