/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageSort;

public class DestructionOccurrenceUtil {
    public static void reorderDestructionOccurrence(List<InteractionFragment> reorderedFragments) {
        int size = reorderedFragments.size();
        ArrayList<InteractionFragment> destructionOccurrenceList = new ArrayList<InteractionFragment>(size);
        int i = 0;
        while (i < size) {
            InteractionFragment o = reorderedFragments.get(i);
            if (o instanceof DestructionOccurrenceSpecification) {
                destructionOccurrenceList.add(o);
            }
            ++i;
        }
        reorderedFragments.removeAll(destructionOccurrenceList);
        reorderedFragments.addAll(destructionOccurrenceList);
    }

    public static void constraintDestructionOccurrence(Message mess, List<InteractionFragment> constraint) {
        if (mess.getMessageSort() != MessageSort.DELETE_MESSAGE_LITERAL) {
            return;
        }
        DestructionOccurrenceUtil.addDestructionOccurrenceConstraint(mess.getReceiveEvent(), constraint);
        DestructionOccurrenceUtil.addDestructionOccurrenceConstraint(mess.getSendEvent(), constraint);
    }

    public static void addDestructionOccurrenceConstraint(MessageEnd end, List<InteractionFragment> constraint) {
        Lifeline lifeline;
        DestructionOccurrenceSpecification d;
        InteractionFragment frag;
        if (end instanceof InteractionFragment && (frag = (InteractionFragment)end).getCovereds().size() > 0 && (d = DestructionOccurrenceUtil.findDestructionOccurrence(lifeline = (Lifeline)frag.getCovereds().get(0))) != null) {
            constraint.add((InteractionFragment)d);
        }
    }

    public static DestructionOccurrenceSpecification findDestructionOccurrence(Lifeline lifeline) {
        EList list = lifeline.getCoveredBys();
        for (InteractionFragment f : list) {
            if (!(f instanceof DestructionOccurrenceSpecification)) continue;
            return (DestructionOccurrenceSpecification)f;
        }
        return null;
    }
}

