/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class AddTypeParameterProposalCore
extends LinkedCorrectionProposalCore {
    private IBinding fBinding;
    private CompilationUnit fAstRoot;
    private final String fTypeParamName;
    private final ITypeBinding[] fBounds;

    public AddTypeParameterProposalCore(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, String name, ITypeBinding[] bounds, int relevance) {
        super("", targetCU, (ASTRewrite)null, relevance);
        Assert.isTrue((binding != null && Bindings.isDeclarationBinding(binding) ? 1 : 0) != 0);
        Assert.isTrue((binding instanceof IMethodBinding || binding instanceof ITypeBinding ? 1 : 0) != 0);
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        this.fTypeParamName = name;
        this.fBounds = bounds;
        if (binding instanceof IMethodBinding) {
            Object[] args = new String[]{BasicElementLabels.getJavaElementName(this.fTypeParamName), ASTResolving.getMethodSignature((IMethodBinding)binding)};
            this.setDisplayName(Messages.format(CorrectionMessages.AddTypeParameterProposal_method_label, args));
        } else {
            Object[] args = new String[]{BasicElementLabels.getJavaElementName(this.fTypeParamName), ASTResolving.getTypeSignature((ITypeBinding)binding)};
            this.setDisplayName(Messages.format(CorrectionMessages.AddTypeParameterProposal_type_label, args));
        }
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        Javadoc javadoc;
        List otherTypeParams;
        ListRewrite listRewrite;
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        if (boundNode != null) {
            declNode = boundNode;
            this.createImportRewrite(this.fAstRoot);
        } else {
            CompilationUnit newRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
            this.createImportRewrite(newRoot);
        }
        AST ast = declNode.getAST();
        TypeParameter newTypeParam = ast.newTypeParameter();
        newTypeParam.setName(ast.newSimpleName(this.fTypeParamName));
        if (this.fBounds != null && this.fBounds.length > 0) {
            List typeBounds = newTypeParam.typeBounds();
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(declNode, this.getImportRewrite());
            ITypeBinding[] iTypeBindingArray = this.fBounds;
            int n = this.fBounds.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding fBound = iTypeBindingArray[n2];
                Type newBound = this.getImportRewrite().addImport(fBound, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.TYPE_BOUND);
                typeBounds.add(newBound);
                ++n2;
            }
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (declNode instanceof TypeDeclaration) {
            declaration = (TypeDeclaration)declNode;
            listRewrite = rewrite.getListRewrite((ASTNode)declaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            otherTypeParams = declaration.typeParameters();
            javadoc = declaration.getJavadoc();
        } else {
            declaration = (MethodDeclaration)declNode;
            listRewrite = rewrite.getListRewrite(declNode, MethodDeclaration.TYPE_PARAMETERS_PROPERTY);
            otherTypeParams = declaration.typeParameters();
            javadoc = declaration.getJavadoc();
        }
        listRewrite.insertLast((ASTNode)newTypeParam, null);
        if (javadoc != null && otherTypeParams != null) {
            ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            Set<String> previousNames = JavadocTagsSubProcessorCore.getPreviousTypeParamNames(otherTypeParams, null);
            String name = "<" + this.fTypeParamName + ">";
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@param");
            TextElement text = ast.newTextElement();
            text.setText(name);
            newTag.fragments().add(text);
            JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, previousNames);
        }
        return rewrite;
    }
}

