/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.StringBufferToStringBuilderFixCore;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.TextEditGroup;

public class StringConcatToTextBlockFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private static final String JAVA_STRING = "java.lang.String";
    private static final String JAVA_STRINGBUFFER = "java.lang.StringBuffer";
    private static final String JAVA_STRINGBUILDER = "java.lang.StringBuilder";
    private static final String NLSComment = "$NON-NLS-1$";
    private static final String NLSCommentPrefix = "$NON-NLS-";

    public static List<String> unescapeBlock(String escapedText) {
        StringBuilder transformed = new StringBuilder();
        int readIndex = 0;
        int bsIndex = 0;
        ArrayList<String> parts = new ArrayList<String>();
        while ((bsIndex = escapedText.indexOf("\\", readIndex)) >= 0) {
            if (escapedText.startsWith("\\n", bsIndex) || escapedText.startsWith("\\u005cn", bsIndex)) {
                transformed.append(escapedText.substring(readIndex, bsIndex));
                parts.add(StringConcatToTextBlockFixCore.escapeTrailingWhitespace(transformed.toString()) + System.lineSeparator());
                transformed = new StringBuilder();
                readIndex = bsIndex + (escapedText.startsWith("\\n", bsIndex) ? 2 : 7);
                continue;
            }
            if (escapedText.startsWith("\\\"", bsIndex) || escapedText.startsWith("\\u005c\"", bsIndex)) {
                transformed.append(escapedText.substring(readIndex, bsIndex));
                int quoteCount = 1;
                int index = escapedText.startsWith("\\\"", bsIndex) ? 2 : 7;
                while (escapedText.startsWith("\\\"", bsIndex + index) || escapedText.startsWith("\\u005c\"", bsIndex + index)) {
                    ++quoteCount;
                    index += escapedText.startsWith("\\\"", bsIndex + index) ? 2 : 7;
                }
                int i = 0;
                while (i < quoteCount / 3) {
                    transformed.append("\\\"\"\"");
                    ++i;
                }
                if (i > 0 && quoteCount % 3 != 0) {
                    transformed.append("\\");
                }
                int j = 0;
                while (j < quoteCount % 3) {
                    transformed.append("\"");
                    ++j;
                }
                readIndex = bsIndex + index;
                continue;
            }
            if (escapedText.startsWith("\\t", bsIndex) || escapedText.startsWith("\\u005ct", bsIndex)) {
                transformed.append(escapedText.substring(readIndex, bsIndex));
                transformed.append("\t");
                readIndex = bsIndex + (escapedText.startsWith("\\t", bsIndex) ? 2 : 7);
                continue;
            }
            if (escapedText.startsWith("\\'", bsIndex) || escapedText.startsWith("\\u005c'", bsIndex)) {
                transformed.append(escapedText.substring(readIndex, bsIndex));
                transformed.append("'");
                readIndex = bsIndex + (escapedText.startsWith("\\'", bsIndex) ? 2 : 7);
                continue;
            }
            transformed.append(escapedText.substring(readIndex, bsIndex));
            transformed.append("\\").append(escapedText.charAt(bsIndex + 1));
            readIndex = bsIndex + 2;
        }
        if (readIndex < escapedText.length()) {
            transformed.append(escapedText.substring(readIndex));
        }
        if (transformed.length() > 0) {
            parts.add(transformed.toString());
        }
        return parts;
    }

    private static String escapeTrailingWhitespace(String unescaped) {
        if (unescaped.length() == 0) {
            return "";
        }
        int whitespaceStart = unescaped.length() - 1;
        StringBuilder trailingWhitespace = new StringBuilder();
        if (unescaped.charAt(whitespaceStart) == ' ') {
            --whitespaceStart;
            trailingWhitespace.append("\\s");
        } else if (unescaped.charAt(whitespaceStart) == '\t') {
            --whitespaceStart;
            trailingWhitespace.append("\\t");
        }
        return unescaped.substring(0, whitespaceStart + 1) + String.valueOf(trailingWhitespace);
    }

    private static boolean hasNLSMarker(ASTNode node, ICompilationUnit cu) throws AbortSearchException {
        boolean hasNLS = false;
        List<Comment> commentList = ASTNodes.getTrailingComments(node);
        if (commentList.isEmpty()) {
            ASTNode n = node;
            while (!(n instanceof Statement) && commentList.isEmpty()) {
                n = n.getParent();
                commentList = ASTNodes.getTrailingComments(n);
            }
        }
        if (commentList.size() > 0 && commentList.get(0) instanceof LineComment) {
            LineComment lineComment = (LineComment)commentList.get(0);
            try {
                String comment = cu.getBuffer().getText(lineComment.getStartPosition() + 2, lineComment.getLength() - 2).trim();
                hasNLS = comment.startsWith(NLSComment);
                if (comment.substring(NLSComment.length()).contains(NLSCommentPrefix)) {
                    throw new AbortSearchException();
                }
            }
            catch (IndexOutOfBoundsException | JavaModelException e) {
                throw new AbortSearchException();
            }
        }
        return hasNLS;
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean includeStringBufferBuilder) {
        if (!JavaModelUtil.is15OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        StringConcatFinder finder = new StringConcatFinder(operations, true);
        compilationUnit.accept((ASTVisitor)finder);
        if (includeStringBufferBuilder) {
            HashSet<String> excludedNames = new HashSet<String>();
            StringBufferFinder finder2 = new StringBufferFinder(operations, excludedNames);
            compilationUnit.accept((ASTVisitor)finder2);
            Map<ExpressionStatement, ChangeStringBufferToTextBlock> conversions = finder2.getConversionMap();
            for (CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation : operations) {
                if (!(operation instanceof ChangeStringBufferToTextBlock)) continue;
                for (Statement s : ((ChangeStringBufferToTextBlock)operation).getStatements()) {
                    if (!conversions.containsKey(s)) continue;
                    ChangeStringBufferToTextBlock op = conversions.get(s);
                    op.resetAssignmentToConvert();
                }
            }
        }
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new StringBufferToStringBuilderFixCore(FixMessages.StringConcatToTextBlockFix_convert_msg, compilationUnit, ops);
    }

    public static StringConcatToTextBlockFixCore createStringConcatToTextBlockFix(ASTNode exp) {
        CompilationUnit root = (CompilationUnit)exp.getRoot();
        if (!JavaModelUtil.is15OrHigher(root.getJavaElement().getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        StringConcatFinder finder = new StringConcatFinder(operations, true);
        exp.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            StringBufferFinder finder2 = new StringBufferFinder(operations, new HashSet<String>());
            exp.accept((ASTVisitor)finder2);
        }
        if (operations.isEmpty()) {
            return null;
        }
        return new StringConcatToTextBlockFixCore(FixMessages.StringConcatToTextBlockFix_convert_msg, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{(CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation)operations.get(0)});
    }

    protected StringConcatToTextBlockFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static class ChangeStringBufferToTextBlock
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final List<MethodInvocation> fToStringList;
        private final List<Statement> fStatements;
        private final List<StringLiteral> fLiterals;
        private String fIndent;
        private final Set<String> fExcludedNames;
        private final BodyDeclaration fLastBodyDecl;
        private final boolean fNonNLS;
        private ExpressionStatement fAssignmentToConvert;

        public ChangeStringBufferToTextBlock(List<MethodInvocation> toStringList, List<Statement> statements, List<StringLiteral> literals, ExpressionStatement assignmentToConvert, Set<String> excludedNames, BodyDeclaration lastBodyDecl, boolean nonNLS) {
            this.fToStringList = toStringList;
            this.fStatements = statements;
            this.fLiterals = literals;
            this.fAssignmentToConvert = assignmentToConvert;
            this.fIndent = "\t";
            this.fExcludedNames = excludedNames;
            this.fLastBodyDecl = lastBodyDecl;
            this.fNonNLS = nonNLS;
        }

        public List<Statement> getStatements() {
            return this.fStatements;
        }

        public void resetAssignmentToConvert() {
            this.fAssignmentToConvert = null;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ImportRewrite importRewriter;
            String tab_option;
            IJavaProject project;
            String DEFAULT_NAME = "str";
            BodyDeclaration bodyDecl = ASTNodes.getFirstAncestorOrNull((ASTNode)this.fToStringList.get(0), BodyDeclaration.class);
            if (bodyDecl != null && bodyDecl != this.fLastBodyDecl) {
                this.fExcludedNames.clear();
            }
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            IJavaElement root = cuRewrite.getRoot().getJavaElement();
            if (root != null && (project = root.getJavaProject()) != null && "space".equals(tab_option = project.getOption("org.eclipse.jdt.core.formatter.tabulation.char", true))) {
                this.fIndent = "";
                int i = 0;
                while (i < CodeFormatterUtil.getTabWidth(project)) {
                    this.fIndent = String.valueOf(this.fIndent) + " ";
                    ++i;
                }
            }
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.StringConcatToTextBlockCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            StringBuilder buf = new StringBuilder();
            ArrayList parts = new ArrayList();
            this.fLiterals.stream().forEach(t -> {
                String value = t.getEscapedValue();
                parts.addAll(StringConcatToTextBlockFixCore.unescapeBlock(value.substring(1, value.length() - 1)));
            });
            buf.append("\"\"\"\n");
            boolean newLine = false;
            boolean allWhiteSpaceStart = true;
            boolean allEmpty = true;
            for (String part : parts) {
                if (buf.length() > 4 && !newLine) {
                    buf.append("\\").append(System.lineSeparator());
                }
                newLine = part.endsWith(System.lineSeparator());
                allWhiteSpaceStart = allWhiteSpaceStart && (part.isEmpty() || Character.isWhitespace(part.charAt(0)));
                allEmpty = allEmpty && part.isEmpty();
                buf.append(this.fIndent).append(part);
            }
            if (newLine || allEmpty) {
                buf.append(this.fIndent);
            } else if (allWhiteSpaceStart) {
                buf.append("\\").append(System.lineSeparator());
                buf.append(this.fIndent);
            } else {
                int readIndex = buf.length() - 1;
                int count = 0;
                while (readIndex >= 0 && buf.charAt(readIndex) == '\"' && count <= 3) {
                    --readIndex;
                    ++count;
                }
                if (readIndex >= 0 && buf.charAt(readIndex) == '\\') {
                    --count;
                }
                int i = count;
                while (i > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                    --i;
                }
                i = count;
                while (i > 0) {
                    buf.append("\\\"");
                    --i;
                }
            }
            buf.append("\"\"\"");
            MethodInvocation firstToStringCall = this.fToStringList.get(0);
            AST ast = firstToStringCall.getAST();
            if (!(this.fToStringList.size() != 1 || this.fNonNLS || ASTNodes.getLeadingComments((ASTNode)this.fStatements.get(0)).size() != 0 || firstToStringCall.getLocationInParent() != Assignment.RIGHT_HAND_SIDE_PROPERTY && firstToStringCall.getLocationInParent() != VariableDeclarationFragment.INITIALIZER_PROPERTY)) {
                TextBlock textBlock = (TextBlock)rewrite.createStringPlaceholder(buf.toString(), 102);
                rewrite.replace((ASTNode)firstToStringCall, (ASTNode)textBlock, group);
                for (Statement statement : this.fStatements) {
                    rewrite.remove((ASTNode)statement, group);
                }
            } else {
                importRewriter = cuRewrite.getImportRewrite();
                ITypeBinding binding = firstToStringCall.resolveTypeBinding();
                if (binding != null) {
                    HashSet<String> excludedNames = new HashSet<String>(ASTNodes.getAllLocalVariablesInBlock((ASTNode)this.fStatements.get(0)));
                    excludedNames.addAll(this.fExcludedNames);
                    String newVarName = DEFAULT_NAME;
                    if (excludedNames.contains(DEFAULT_NAME)) {
                        newVarName = ChangeStringBufferToTextBlock.createName(DEFAULT_NAME, excludedNames);
                    }
                    this.fExcludedNames.add(newVarName);
                    Type t2 = importRewriter.addImport(binding, ast);
                    if (!this.fNonNLS || StringConcatToTextBlockFixCore.hasNLSMarker((ASTNode)this.fStatements.get(0), cuRewrite.getCu())) {
                        TextBlock textBlock = (TextBlock)rewrite.createStringPlaceholder(buf.toString(), 102);
                        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
                        newFragment.setName(ast.newSimpleName(newVarName));
                        newFragment.setInitializer((Expression)textBlock);
                        VariableDeclarationStatement newStmt = ast.newVariableDeclarationStatement(newFragment);
                        newStmt.setType(t2);
                        ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.fStatements.get(0), (ASTNode)newStmt, group);
                    } else {
                        StringBuilder builder = new StringBuilder();
                        builder.append("String ");
                        builder.append(newVarName);
                        builder.append(" = ");
                        builder.append(buf.toString());
                        builder.append("; //$NON-NLS-1$");
                        VariableDeclarationStatement newStmt = (VariableDeclarationStatement)rewrite.createStringPlaceholder(builder.toString(), 60);
                        ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.fStatements.get(0), (ASTNode)newStmt, group);
                    }
                    int i = 1;
                    while (i < this.fStatements.size()) {
                        rewrite.remove((ASTNode)this.fStatements.get(i), group);
                        ++i;
                    }
                    for (MethodInvocation toStringCall : this.fToStringList) {
                        SimpleName name = ast.newSimpleName(newVarName);
                        rewrite.replace((ASTNode)toStringCall, (ASTNode)name, group);
                    }
                }
            }
            if (this.fAssignmentToConvert != null) {
                importRewriter = cuRewrite.getImportRewrite();
                Assignment assignment = (Assignment)this.fAssignmentToConvert.getExpression();
                ITypeBinding binding = assignment.resolveTypeBinding();
                if (binding != null) {
                    Type t3 = importRewriter.addImport(binding, ast);
                    VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
                    newFragment.setName(ast.newSimpleName(((SimpleName)assignment.getLeftHandSide()).getFullyQualifiedName()));
                    newFragment.setInitializer((Expression)rewrite.createCopyTarget((ASTNode)assignment.getRightHandSide()));
                    VariableDeclarationStatement newStmt = ast.newVariableDeclarationStatement(newFragment);
                    newStmt.setType(t3);
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.fAssignmentToConvert, (ASTNode)newStmt, group);
                }
            }
        }

        private static String createName(String nameRoot, Set<String> excludedNames) {
            String candidate;
            int i = 1;
            while (excludedNames.remove(candidate = nameRoot + i++)) {
            }
            return candidate;
        }
    }

    public static class ChangeStringConcatToTextBlock
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final InfixExpression fInfix;
        private String fIndent;
        private final boolean isTagged;

        public ChangeStringConcatToTextBlock(InfixExpression infix, boolean isTagged) {
            this.fInfix = infix;
            this.fIndent = "\t";
            this.isTagged = isTagged;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            String tab_option;
            IJavaProject project;
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.StringConcatToTextBlockCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            IJavaElement root = cuRewrite.getRoot().getJavaElement();
            if (root != null && (project = root.getJavaProject()) != null && "space".equals(tab_option = project.getOption("org.eclipse.jdt.core.formatter.tabulation.char", true))) {
                this.fIndent = "";
                int i = 0;
                while (i < CodeFormatterUtil.getTabWidth(project)) {
                    this.fIndent = String.valueOf(this.fIndent) + " ";
                    ++i;
                }
            }
            StringBuilder buf = new StringBuilder();
            Stream<Expression> expressions = Stream.concat(Stream.of(this.fInfix.getLeftOperand(), this.fInfix.getRightOperand()), this.fInfix.extendedOperands().stream());
            final ArrayList parts = new ArrayList();
            expressions.forEach(new Consumer<Expression>(){

                @Override
                public void accept(Expression t) {
                    String value = ((StringLiteral)t).getEscapedValue();
                    parts.addAll(StringConcatToTextBlockFixCore.unescapeBlock(value.substring(1, value.length() - 1)));
                }
            });
            buf.append("\"\"\"\n");
            boolean newLine = false;
            boolean allWhiteSpaceStart = true;
            boolean allEmpty = true;
            for (String part : parts) {
                if (buf.length() > 4 && !newLine) {
                    buf.append("\\").append(System.lineSeparator());
                }
                newLine = part.endsWith(System.lineSeparator());
                allWhiteSpaceStart = allWhiteSpaceStart && (part.isEmpty() || Character.isWhitespace(part.charAt(0)));
                allEmpty = allEmpty && part.isEmpty();
                buf.append(this.fIndent).append(part);
            }
            if (newLine || allEmpty) {
                buf.append(this.fIndent);
            } else if (allWhiteSpaceStart) {
                buf.append("\\").append(System.lineSeparator());
                buf.append(this.fIndent);
            } else {
                int i = buf.length() - 1;
                int count = 0;
                while (i >= 0 && buf.charAt(i) == '\"' && count <= 3) {
                    --i;
                    ++count;
                }
                if (i >= 0 && buf.charAt(i) == '\\') {
                    --count;
                }
                i = count;
                while (i > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                    --i;
                }
                i = count;
                while (i > 0) {
                    buf.append("\\\"");
                    --i;
                }
                i = buf.length() - 1;
                if (buf.charAt(i) == ' ') {
                    buf.deleteCharAt(i);
                    buf.append("\\s");
                } else if (buf.charAt(i) == '\t') {
                    buf.deleteCharAt(i);
                    buf.append("\\t");
                }
            }
            buf.append("\"\"\"");
            if (!this.isTagged) {
                TextBlock textBlock = (TextBlock)rewrite.createStringPlaceholder(buf.toString(), 102);
                rewrite.replace((ASTNode)this.fInfix, (ASTNode)textBlock, group);
            } else {
                ASTNode stmt = ASTNodes.getFirstAncestorOrNull((ASTNode)this.fInfix, Statement.class, FieldDeclaration.class);
                ICompilationUnit cu = (ICompilationUnit)((CompilationUnit)this.fInfix.getRoot()).getJavaElement();
                StringBuilder buffer = new StringBuilder();
                buffer.append(cu.getBuffer().getText(stmt.getStartPosition(), this.fInfix.getStartPosition() - stmt.getStartPosition()));
                buffer.append(buf.toString());
                buffer.append(cu.getBuffer().getText(this.fInfix.getStartPosition() + this.fInfix.getLength(), stmt.getStartPosition() + stmt.getLength() - this.fInfix.getStartPosition() - this.fInfix.getLength()));
                ASTNode newStmt = rewrite.createStringPlaceholder(buffer.toString(), stmt.getNodeType());
                ASTNodes.replaceButKeepComment(rewrite, stmt, newStmt, group);
            }
        }
    }

    public static final class StringBufferFinder
    extends ASTVisitor {
        private final List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fOperations;
        private List<StringLiteral> fLiterals = new ArrayList<StringLiteral>();
        private List<Statement> statementList = new ArrayList<Statement>();
        private Set<Statement> ignoredConstructorStatements = new HashSet<Statement>();
        private SimpleName originalVarName;
        private Map<ExpressionStatement, ChangeStringBufferToTextBlock> conversions = new HashMap<ExpressionStatement, ChangeStringBufferToTextBlock>();
        private static final String APPEND = "append";
        private static final String TO_STRING = "toString";
        private BodyDeclaration fLastBodyDecl;
        private final Set<String> fExcludedNames;
        private final Set<IBinding> fRemovedDeclarations = new HashSet<IBinding>();

        public StringBufferFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, Set<String> excludedNames) {
            super(true);
            this.fOperations = operations;
            this.fExcludedNames = excludedNames;
        }

        public Map<ExpressionStatement, ChangeStringBufferToTextBlock> getConversionMap() {
            return this.conversions;
        }

        private boolean isStringBufferType(Type type) {
            if (type instanceof ArrayType) {
                return false;
            }
            ITypeBinding typeBinding = type.resolveBinding();
            return typeBinding != null && (typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRINGBUFFER) || typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRINGBUILDER));
        }

        public boolean visit(ClassInstanceCreation node) {
            int startIndex;
            if (!this.isStringBufferType(node.getType())) {
                return false;
            }
            List args = node.arguments();
            Statement statement = ASTNodes.getFirstAncestorOrNull((ASTNode)node, Statement.class);
            if (statement.getLocationInParent() != Block.STATEMENTS_PROPERTY || !(statement instanceof VariableDeclarationStatement) && !(statement instanceof ExpressionStatement)) {
                return false;
            }
            if (this.ignoredConstructorStatements.contains(statement)) {
                this.statementList.remove(statement);
                return false;
            }
            boolean nonNLS = false;
            CompilationUnit cu = (CompilationUnit)node.getRoot();
            ICompilationUnit icu = (ICompilationUnit)cu.getJavaElement();
            if (args.size() == 1 && args.get(0) instanceof StringLiteral) {
                this.fLiterals.add((StringLiteral)args.get(0));
            } else if (args.size() > 0) {
                Object e = args.get(0);
                if (e instanceof InfixExpression) {
                    InfixExpression infix = (InfixExpression)e;
                    if (!this.processInfixExpression(infix)) {
                        return this.failure();
                    }
                } else if (!(args.get(0) instanceof NumberLiteral)) {
                    this.statementList.remove(statement);
                    return false;
                }
            }
            try {
                this.extractConcatenatedAppends((ASTNode)node);
            }
            catch (AbortSearchException e) {
                return this.failure();
            }
            Block block = (Block)statement.getParent();
            List stmtList = block.statements();
            int i = startIndex = stmtList.indexOf(statement);
            Statement previousStatement = null;
            while (++i < stmtList.size()) {
                Statement s = (Statement)stmtList.get(i);
                if (!(s instanceof ExpressionStatement)) break;
                Expression exp = ((ExpressionStatement)s).getExpression();
                if (exp instanceof MethodInvocation) {
                    class MethodVisitor
                    extends ASTVisitor {
                        private boolean valid = false;

                        MethodVisitor() {
                        }

                        public boolean isValid() {
                            return this.valid;
                        }

                        public boolean visit(SimpleName simpleName) {
                            if (simpleName.getFullyQualifiedName().equals(StringBufferFinder.APPEND) && simpleName.getLocationInParent() == MethodInvocation.NAME_PROPERTY) {
                                return true;
                            }
                            if (simpleName.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY && simpleName.getFullyQualifiedName().equals(StringBufferFinder.this.originalVarName.getFullyQualifiedName()) && ((MethodInvocation)simpleName.getParent()).getName().getFullyQualifiedName().equals(StringBufferFinder.APPEND)) {
                                StringBufferFinder.this.extractConcatenatedAppends((ASTNode)simpleName);
                                this.valid = true;
                                return false;
                            }
                            return true;
                        }
                    }
                    MethodVisitor methodVisitor = new MethodVisitor();
                    try {
                        s.accept((ASTVisitor)methodVisitor);
                        if (!methodVisitor.isValid()) break;
                        this.statementList.add(s);
                    }
                    catch (AbortSearchException e) {
                        return this.failure();
                    }
                } else {
                    ClassInstanceCreation cic;
                    SimpleName name;
                    Assignment assignment;
                    Expression expression;
                    if (!(exp instanceof Assignment) || !((expression = (assignment = (Assignment)exp).getLeftHandSide()) instanceof SimpleName) || !(name = (SimpleName)expression).getFullyQualifiedName().equals(this.originalVarName.getFullyQualifiedName()) || i - startIndex != 1 && !this.ignoredConstructorStatements.contains(previousStatement)) break;
                    Expression rightSide = ASTNodes.getUnparenthesedExpression(assignment.getRightHandSide());
                    if (rightSide instanceof ClassInstanceCreation && this.isStringBufferType((cic = (ClassInstanceCreation)rightSide).getType())) {
                        List cicArgs = cic.arguments();
                        this.ignoredConstructorStatements.add(s);
                        this.statementList.add(s);
                        if (!cicArgs.isEmpty() || !this.fLiterals.isEmpty()) {
                            return this.failure();
                        }
                    }
                }
                previousStatement = s;
            }
            Statement endStatement = (Statement)stmtList.get(i - 1);
            int lastStatementEnd = endStatement.getStartPosition() + endStatement.getLength();
            IBinding varBinding = null;
            if (this.originalVarName == null || (varBinding = this.originalVarName.resolveBinding()) == null) {
                return this.failure();
            }
            if (!this.fLiterals.isEmpty()) {
                try {
                    nonNLS = StringConcatToTextBlockFixCore.hasNLSMarker((ASTNode)this.fLiterals.get(0), icu);
                    int j = 1;
                    while (j < this.fLiterals.size()) {
                        if (nonNLS != StringConcatToTextBlockFixCore.hasNLSMarker((ASTNode)this.fLiterals.get(j), icu)) {
                            return this.failure();
                        }
                        ++j;
                    }
                }
                catch (AbortSearchException e) {
                    return this.failure();
                }
            }
            CheckValidityVisitor checkValidityVisitor = new CheckValidityVisitor(lastStatementEnd, varBinding);
            try {
                block.accept((ASTVisitor)checkValidityVisitor);
            }
            catch (AbortSearchException abortSearchException) {
                // empty catch block
            }
            if (!checkValidityVisitor.isValid() || checkValidityVisitor.getToStringList().size() == 0) {
                return this.failure();
            }
            ExpressionStatement assignmentToConvert = checkValidityVisitor.getNextAssignment();
            ArrayList<Statement> statements = new ArrayList<Statement>(this.statementList);
            ArrayList<StringLiteral> literals = new ArrayList<StringLiteral>(this.fLiterals);
            ArrayList<MethodInvocation> toStringList = new ArrayList<MethodInvocation>(checkValidityVisitor.getToStringList());
            BodyDeclaration bodyDecl = ASTNodes.getFirstAncestorOrNull((ASTNode)node, BodyDeclaration.class);
            if (statements.get(0) instanceof VariableDeclarationStatement) {
                this.fRemovedDeclarations.add(this.originalVarName.resolveBinding());
            }
            ChangeStringBufferToTextBlock operation = new ChangeStringBufferToTextBlock(toStringList, statements, literals, (ExpressionStatement)(this.fRemovedDeclarations.contains(this.originalVarName.resolveBinding()) ? assignmentToConvert : null), this.fExcludedNames, this.fLastBodyDecl, nonNLS);
            this.fLastBodyDecl = bodyDecl;
            this.fOperations.add(operation);
            this.conversions.put(assignmentToConvert, operation);
            this.statementList.clear();
            this.fLiterals.clear();
            return true;
        }

        private void extractConcatenatedAppends(ASTNode node) throws AbortSearchException {
            ASTNode parent = node.getParent();
            while (!(parent instanceof Statement)) {
                if (parent instanceof MethodInvocation) {
                    MethodInvocation methodCall = (MethodInvocation)parent;
                    if (!methodCall.getName().getFullyQualifiedName().equals(APPEND)) {
                        throw new AbortSearchException();
                    }
                    Expression arg = (Expression)methodCall.arguments().get(0);
                    if (arg instanceof StringLiteral) {
                        this.fLiterals.add((StringLiteral)arg);
                    } else if (arg instanceof InfixExpression) {
                        InfixExpression infix = (InfixExpression)arg;
                        if (!this.processInfixExpression(infix)) {
                            throw new AbortSearchException();
                        }
                    } else {
                        throw new AbortSearchException();
                    }
                }
                parent = parent.getParent();
            }
        }

        private boolean failure() {
            this.statementList.clear();
            this.fLiterals.clear();
            return false;
        }

        private boolean processInfixExpression(InfixExpression infix) {
            if (infix.getOperator() == InfixExpression.Operator.PLUS) {
                Expression left = infix.getLeftOperand();
                Expression right = infix.getRightOperand();
                List extendedOps = infix.extendedOperands();
                if (left instanceof StringLiteral && right instanceof StringLiteral) {
                    ArrayList<StringLiteral> extendedLiterals = new ArrayList<StringLiteral>();
                    for (Expression extendedOp : extendedOps) {
                        if (extendedOp instanceof StringLiteral) {
                            extendedLiterals.add((StringLiteral)extendedOp);
                            continue;
                        }
                        return false;
                    }
                    this.fLiterals.add((StringLiteral)left);
                    this.fLiterals.add((StringLiteral)right);
                    this.fLiterals.addAll(extendedLiterals);
                } else {
                    return false;
                }
            }
            return true;
        }

        public boolean visit(VariableDeclarationStatement visited) {
            Type type = visited.getType();
            return this.isStringBufferType(type) && visited.fragments().size() == 1;
        }

        public boolean visit(VariableDeclarationFragment node) {
            VariableDeclarationStatement varDeclStmt = ASTNodes.getFirstAncestorOrNull((ASTNode)node, VariableDeclarationStatement.class);
            if (varDeclStmt == null || varDeclStmt.fragments().size() != 1) {
                return false;
            }
            this.originalVarName = node.getName();
            this.statementList.clear();
            this.statementList.add((Statement)varDeclStmt);
            return true;
        }

        public boolean visit(Assignment visited) {
            ITypeBinding typeBinding = visited.resolveTypeBinding();
            if (typeBinding == null || !typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRINGBUFFER) && !typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRINGBUILDER)) {
                return false;
            }
            if (!(visited.getLeftHandSide() instanceof SimpleName)) {
                return false;
            }
            ExpressionStatement statement = ASTNodes.getFirstAncestorOrNull((ASTNode)visited, ExpressionStatement.class);
            if (statement == null) {
                return false;
            }
            this.originalVarName = (SimpleName)visited.getLeftHandSide();
            this.statementList.add((Statement)statement);
            return true;
        }

        private class CheckValidityVisitor
        extends ASTVisitor {
            private boolean valid = true;
            private ExpressionStatement nextAssignment = null;
            private int lastStatementEnd;
            private IBinding varBinding;
            private List<MethodInvocation> toStringList = new ArrayList<MethodInvocation>();

            public CheckValidityVisitor(int lastStatementEnd, IBinding varBinding) {
                this.lastStatementEnd = lastStatementEnd;
                this.varBinding = varBinding;
            }

            public boolean isValid() {
                return this.valid;
            }

            public ExpressionStatement getNextAssignment() {
                return this.nextAssignment;
            }

            public List<MethodInvocation> getToStringList() {
                return this.toStringList;
            }

            public boolean visit(SimpleName name) {
                IBinding binding;
                if (name.getStartPosition() > this.lastStatementEnd && this.varBinding.isEqualTo(binding = name.resolveBinding())) {
                    this.valid = false;
                    if (name.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                        Assignment assignment = (Assignment)name.getParent();
                        ASTNode parent = assignment.getParent();
                        if (parent instanceof ExpressionStatement && (assignment.getRightHandSide() instanceof ClassInstanceCreation || assignment.getRightHandSide() instanceof NullLiteral)) {
                            this.valid = true;
                            this.nextAssignment = (ExpressionStatement)parent;
                        }
                    } else if (name.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY) {
                        MethodInvocation invocation = (MethodInvocation)name.getParent();
                        if (invocation.getName().getFullyQualifiedName().equals(StringBufferFinder.TO_STRING)) {
                            this.valid = true;
                            this.toStringList.add(invocation);
                            return true;
                        }
                        this.valid = false;
                    } else {
                        this.valid = false;
                    }
                    throw new AbortSearchException();
                }
                return true;
            }
        }
    }

    public static final class StringConcatFinder
    extends ASTVisitor {
        private final List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fOperations;
        private final boolean fAllConcats;

        public StringConcatFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, boolean allConcats) {
            super(true);
            this.fOperations = operations;
            this.fAllConcats = allConcats;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean visit(InfixExpression visited) {
            if (visited.getOperator() != InfixExpression.Operator.PLUS || visited.extendedOperands().isEmpty()) {
                return false;
            }
            if (visited.getLocationInParent() == InfixExpression.LEFT_OPERAND_PROPERTY || visited.getLocationInParent() == InfixExpression.RIGHT_OPERAND_PROPERTY) {
                return false;
            }
            ITypeBinding typeBinding = visited.resolveTypeBinding();
            if (typeBinding == null || !typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRING)) {
                return false;
            }
            Expression leftHand = visited.getLeftOperand();
            if (!(leftHand instanceof StringLiteral)) {
                return false;
            }
            boolean hasComments = false;
            StringLiteral leftLiteral = (StringLiteral)leftHand;
            CompilationUnit cUnit = (CompilationUnit)leftLiteral.getRoot();
            String literal = leftLiteral.getLiteralValue();
            if (!(literal.isEmpty() || this.fAllConcats || literal.endsWith("\n"))) {
                return false;
            }
            Expression rightHand = visited.getRightOperand();
            if (!(rightHand instanceof StringLiteral)) {
                return false;
            }
            StringLiteral rightLiteral = (StringLiteral)rightHand;
            ICompilationUnit cu = (ICompilationUnit)cUnit.getJavaElement();
            hasComments = hasComments || this.hasNLS(ASTNodes.getTrailingComments((ASTNode)rightLiteral), cu);
            literal = rightLiteral.getLiteralValue();
            if (!(literal.isEmpty() || this.fAllConcats || literal.endsWith("\n"))) {
                return false;
            }
            List extendedOperands = visited.extendedOperands();
            if (extendedOperands.isEmpty()) {
                return false;
            }
            int lineNo = this.getLineOfOffset(cUnit, leftLiteral.getStartPosition());
            int endPosition = this.getLineOffset(cUnit, lineNo + 1) == -1 ? cUnit.getLength() : this.getLineOffset(cUnit, lineNo + 1);
            hasComments = hasComments || this.hasNLS(ASTNodes.getCommentsForRegion(cUnit, leftLiteral.getStartPosition(), endPosition - leftLiteral.getStartPosition()), cu);
            lineNo = this.getLineOfOffset(cUnit, rightLiteral.getStartPosition());
            endPosition = this.getLineOffset(cUnit, lineNo + 1) == -1 ? cUnit.getLength() : this.getLineOffset(cUnit, lineNo + 1);
            hasComments = hasComments || this.hasNLS(ASTNodes.getCommentsForRegion(cUnit, rightLiteral.getStartPosition(), endPosition - rightLiteral.getStartPosition()), cu);
            int i = 0;
            while (i < extendedOperands.size()) {
                block30: {
                    block29: {
                        Expression operand = (Expression)extendedOperands.get(i);
                        if (!(operand instanceof StringLiteral)) break block29;
                        StringLiteral stringLiteral = (StringLiteral)operand;
                        lineNo = this.getLineOfOffset(cUnit, stringLiteral.getStartPosition());
                        endPosition = this.getLineOffset(cUnit, lineNo + 1) == -1 ? cUnit.getLength() : this.getLineOffset(cUnit, lineNo + 1);
                        hasComments = hasComments || this.hasNLS(ASTNodes.getCommentsForRegion(cUnit, stringLiteral.getStartPosition(), endPosition - stringLiteral.getStartPosition()), cu);
                        String string = stringLiteral.getLiteralValue();
                        if (!string.isEmpty() && (this.fAllConcats || string.endsWith("\n") || i == extendedOperands.size() - 1)) break block30;
                    }
                    return false;
                }
                ++i;
            }
            boolean isTagged = false;
            if (!hasComments) {
                List<Comment> comments = ASTNodes.getCommentsForRegion(cUnit, visited.getStartPosition(), visited.getLength());
                if (!comments.isEmpty()) {
                    try {
                        IBuffer buffer = cu.getBuffer();
                        for (Comment comment : comments) {
                            if (!(comment instanceof LineComment)) {
                                return false;
                            }
                            if (buffer.getText(comment.getStartPosition() + 2, comment.getLength() - 2).trim().isEmpty()) continue;
                            return false;
                        }
                    }
                    catch (JavaModelException comment) {}
                }
            } else if (ASTNodes.getFirstAncestorOrNull((ASTNode)visited, Annotation.class) == null) {
                NLSLine nlsLine = this.scanCurrentLine(cu, leftHand);
                if (nlsLine == null) {
                    return false;
                }
                isTagged = nlsLine.getElements()[0].hasTag();
                if (!this.isConsistent(nlsLine, isTagged)) {
                    return false;
                }
                nlsLine = this.scanCurrentLine(cu, rightHand);
                if (nlsLine == null || !this.isConsistent(nlsLine, isTagged)) {
                    return false;
                }
                int i2 = 0;
                while (i2 < extendedOperands.size()) {
                    Expression operand = (Expression)extendedOperands.get(i2);
                    nlsLine = this.scanCurrentLine(cu, operand);
                    if (nlsLine == null || !this.isConsistent(nlsLine, isTagged)) {
                        return false;
                    }
                    ++i2;
                }
            }
            if (!isTagged || ASTNodes.getFirstAncestorOrNull((ASTNode)visited, Statement.class, FieldDeclaration.class) != null) {
                this.fOperations.add(new ChangeStringConcatToTextBlock(visited, isTagged));
            }
            return false;
        }

        private NLSLine scanCurrentLine(ICompilationUnit cu, Expression exp) {
            CompilationUnit cUnit = (CompilationUnit)exp.getRoot();
            int startLine = cUnit.getLineNumber(exp.getStartPosition());
            int endOfLine = cUnit.getPosition(startLine + 1, 0);
            try {
                NLSLine[] lines = NLSScanner.scan(cu.getBuffer().getText(exp.getStartPosition(), endOfLine - exp.getStartPosition()));
                if (lines.length > 0) {
                    return lines[0];
                }
            }
            catch (IndexOutOfBoundsException | JavaModelException | InvalidInputException | BadLocationException throwable) {
                // empty catch block
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean hasNLS(List<Comment> trailingComments, ICompilationUnit cu) {
            if (trailingComments.isEmpty()) return false;
            if (cu == null) return false;
            try {
                Comment comment;
                IBuffer buffer = cu.getBuffer();
                Iterator<Comment> iterator = trailingComments.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while (!((comment = iterator.next()) instanceof LineComment) || !buffer.getText(comment.getStartPosition(), comment.getLength()).contains("$NON-NLS"));
                return true;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return false;
        }

        private int getLineOfOffset(CompilationUnit astRoot, int offset) {
            return astRoot.getLineNumber(offset) - 1;
        }

        private int getLineOffset(CompilationUnit astRoot, int line) {
            return astRoot.getPosition(line + 1, 0);
        }

        private boolean isConsistent(NLSLine nlsLine, boolean isTagged) {
            NLSElement[] elements;
            NLSElement[] nLSElementArray = elements = nlsLine.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                NLSElement element = nLSElementArray[n2];
                if (element.hasTag() != isTagged) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

