/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.logicalstructures;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaModifiers;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class JDIPlaceholderVariable
extends PlatformObject
implements IJavaVariable {
    private final String fName;
    private final IJavaValue fValue;
    private IJavaValue fLogicalParent;

    public JDIPlaceholderVariable(String name, IJavaValue value) {
        this.fName = name;
        this.fValue = value;
    }

    public JDIPlaceholderVariable(String name, IJavaValue value, IJavaValue logicalParent) {
        this(name, value);
        this.fLogicalParent = logicalParent;
    }

    @Override
    public String getSignature() throws DebugException {
        return ((IJavaValue)this.getValue()).getSignature();
    }

    @Override
    public String getGenericSignature() throws DebugException {
        return ((IJavaValue)this.getValue()).getGenericSignature();
    }

    @Override
    public IJavaType getJavaType() throws DebugException {
        return ((IJavaValue)this.getValue()).getJavaType();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public IValue getValue() {
        return this.fValue;
    }

    public String getName() {
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        return ((IJavaValue)this.getValue()).getReferenceTypeName();
    }

    public boolean hasValueChanged() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPackagePrivate() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    public String getModelIdentifier() {
        return this.getValue().getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return ((IJavaValue)this.getValue()).getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getValue().getLaunch();
    }

    public void setValue(String expression) {
    }

    public void setValue(IValue value) {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) {
        return false;
    }

    public boolean verifyValue(IValue value) {
        return false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IJavaVariable.class.equals(adapter) || IJavaModifiers.class.equals(adapter)) {
            return (T)this;
        }
        return (T)super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JDIPlaceholderVariable) {
            JDIPlaceholderVariable var = (JDIPlaceholderVariable)obj;
            if (this.fLogicalParent != null) {
                return var.getName().equals(this.getName()) && this.fLogicalParent.equals(var.fLogicalParent);
            }
            return var.getName().equals(this.getName()) && var.getValue().equals(this.getValue());
        }
        return false;
    }

    public int hashCode() {
        if (this.fLogicalParent != null) {
            return this.fLogicalParent.hashCode() + this.fName.hashCode();
        }
        return this.fName.hashCode() + this.fValue.hashCode();
    }
}

