/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.bcoview.views;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Scanner;
import org.eclipse.jdt.core.dom.AST;
import org.objectweb.asm.util.Printer;

public class HelpUtils {
    private static final String SPECS_HTML = "https://docs.oracle.com/javase/specs/jvms/se" + AST.getJLSLatest() + "/html/jvms-6.html";
    private static String fullSpec;
    private static String htmlHead;

    private static String checkOpcodeName(String opcodeName) {
        int sepIndex = ((String)(opcodeName = ((String)opcodeName).toLowerCase())).indexOf(95);
        if (sepIndex > 0) {
            if (Character.isDigit(((String)opcodeName).charAt(sepIndex + 1))) {
                opcodeName = ((String)opcodeName).substring(0, sepIndex);
                switch (((String)opcodeName).charAt(0)) {
                    case 'd': {
                        opcodeName = (String)opcodeName + "_d";
                        break;
                    }
                    case 'f': {
                        opcodeName = (String)opcodeName + "_f";
                        break;
                    }
                    case 'l': {
                        opcodeName = (String)opcodeName + "_l";
                        break;
                    }
                    default: {
                        opcodeName = (String)opcodeName + "_n";
                    }
                }
            }
            if (((String)opcodeName).startsWith("if_acmp")) {
                opcodeName = "if_acmp_cond";
            } else if (((String)opcodeName).startsWith("if_icmp")) {
                opcodeName = "if_icmp_cond";
            } else if (((String)opcodeName).startsWith("if_")) {
                opcodeName = "if_cond";
            } else if (((String)opcodeName).startsWith("aload_")) {
                opcodeName = "aload_n";
            } else if (((String)opcodeName).startsWith("iconst_")) {
                opcodeName = "iconst_i";
            }
        } else if (((String)opcodeName).startsWith("if")) {
            opcodeName = "if_cond";
        }
        return opcodeName;
    }

    private static String getOpcodeName(int opcode) {
        if (opcode < 0 || opcode >= Printer.OPCODES.length) {
            return null;
        }
        String opcodeName = Printer.OPCODES[opcode];
        if (opcodeName == null) {
            return null;
        }
        return opcodeName;
    }

    private static URL toUrl(String href) {
        try {
            return new URL(href);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL getHelpIndex() {
        return HelpUtils.toUrl(SPECS_HTML);
    }

    private static String readFullSpec() {
        String firstInterestingLine = "<a name=\"jvms-6-100\">";
        URL helpResource = HelpUtils.toUrl(SPECS_HTML);
        StringBuilder sb = new StringBuilder();
        boolean foundContentStart = false;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(helpResource.openStream(), "UTF-8"));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (!foundContentStart && line.contains(firstInterestingLine)) {
                        foundContentStart = true;
                        htmlHead = HelpUtils.readHtmlHead(sb.toString());
                        sb = new StringBuilder();
                    }
                    sb.append(line).append('\n');
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            sb.append("Error trying access JVM specification at ").append(SPECS_HTML);
            sb.append(":");
            sb.append(e);
        }
        return sb.toString();
    }

    public static StringBuilder getOpcodeHelpFor(int opcode) {
        if (fullSpec == null) {
            fullSpec = HelpUtils.readFullSpec();
        }
        StringBuilder sb = new StringBuilder();
        String opcodeName = HelpUtils.getOpcodeName(opcode);
        if (opcodeName == null) {
            return sb;
        }
        return HelpUtils.getOpcodeHelpFor(opcodeName);
    }

    public static StringBuilder getOpcodeHelpFor(String opcodeName) {
        if (fullSpec == null) {
            fullSpec = HelpUtils.readFullSpec();
        }
        StringBuilder sb = new StringBuilder();
        if (opcodeName != null) {
            opcodeName = HelpUtils.checkOpcodeName(opcodeName);
        }
        sb.append(htmlHead);
        String patternStart = "jvms-6.5." + opcodeName + "\"";
        String patternEnd = "<div class=\"section-execution\"";
        String startSection = "<div class=\"section-execution\"><div class=\"titlepage\"><div><div>";
        Throwable throwable = null;
        Object var6_8 = null;
        try (Scanner in = new Scanner(fullSpec);){
            boolean foundStart = false;
            boolean checkEnd = false;
            while (in.hasNextLine()) {
                String line = in.nextLine();
                if (checkEnd && line.contains(patternEnd)) {
                    break;
                }
                if (!foundStart && line.contains(patternStart)) {
                    foundStart = true;
                    checkEnd = true;
                    sb.append(startSection);
                }
                if (!foundStart) continue;
                sb.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int endHeadIdx = sb.indexOf("</head>");
        if (endHeadIdx > 0) {
            sb.insert(endHeadIdx, "\n<base href='" + SPECS_HTML + "'>\n");
        }
        sb.append("</body></html>");
        return sb;
    }

    private static String readHtmlHead(String head) {
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner in = new Scanner(head);){
            while (in.hasNextLine()) {
                String line = in.nextLine();
                if (line.contains("<body")) {
                    sb.append(line.substring(0, line.indexOf("<body")));
                    break;
                }
                sb.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return sb.toString();
    }
}

