/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.query;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.exported.IQueryDialogFactoryStrategy;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.query.IQueryWidgetCompositeFactoryFactory;
import org.eclipse.papyrus.emf.facet.util.core.Logger;

public class QueryWidgetCompositeFactoryImpl
implements IQueryWidgetCompositeFactoryFactory {
    private static final String EXTENSION_POINT = "org.eclipse.papyrus.emf.facet.efacet.sdk.ui.queryFactoryDialogRegistration";
    private static final String DIALOG_FACTORY = "dialogFactory";
    private static final String MANAGED_TYPE_NAME = "managedQueryTypeName";
    private Map<String, IQueryDialogFactoryStrategy> extensions;

    @Override
    public IQueryDialogFactoryStrategy getQueryDialogFactoryStrategy(String managedTypeName) {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementName = element.getAttribute(MANAGED_TYPE_NAME);
            if (elementName.equals(managedTypeName)) {
                try {
                    Object object = element.createExecutableExtension(DIALOG_FACTORY);
                    if (object instanceof IQueryDialogFactoryStrategy) {
                        IQueryDialogFactoryStrategy strategy = (IQueryDialogFactoryStrategy)object;
                        this.extensions.put(elementName, strategy);
                    } else {
                        String errorMsg = NLS.bind((String)"The attribut {0} must contains a class implementing {1}", (Object)DIALOG_FACTORY, (Object)IQueryDialogFactoryStrategy.class.getName());
                        Logger.logError((String)errorMsg, (Plugin)Activator.getDefault());
                    }
                }
                catch (InvalidRegistryObjectException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
                catch (CoreException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            ++n2;
        }
        return this.extensions.get(managedTypeName);
    }

    @Override
    public List<String> getRegisteredQueryWidgetsComposite() {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, IQueryDialogFactoryStrategy>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                this.extensions.put(element.getAttribute(MANAGED_TYPE_NAME), null);
                ++n2;
            }
        }
        return new LinkedList<String>(this.extensions.keySet());
    }
}

