/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.Concern;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.Stakeholder;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureContextRule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureDomainRule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class RepresentationKindRule {
    @Inject
    @Extension
    private ArchitectureExtensions _architectureExtensions;
    @Inject
    @Extension
    private ArchitectureContextRule _architectureContextRule;
    @Inject
    @Extension
    private ArchitectureDomainRule _architectureDomainRule;
    private final HashMap<ArrayList<?>, RepresentationKind> _createCache_merged = CollectionLiterals.newHashMap();

    public RepresentationKind merged(RepresentationKind representation) {
        return this.merged(representation, this._architectureExtensions.currentScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepresentationKind merged(RepresentationKind representation, Object scope) {
        RepresentationKind _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{representation, scope});
        HashMap<ArrayList<?>, RepresentationKind> hashMap = this._createCache_merged;
        synchronized (hashMap) {
            RepresentationKind _copy;
            if (this._createCache_merged.containsKey(_cacheKey)) {
                return this._createCache_merged.get(_cacheKey);
            }
            _result = _copy = (RepresentationKind)EcoreUtil.copy((EObject)representation);
            this._createCache_merged.put(_cacheKey, _result);
        }
        this._init_merged(_result, representation, scope);
        return _result;
    }

    private void _init_merged(RepresentationKind result, RepresentationKind representation, Object scope) {
        Functions.Function1 _function = it -> it.isContainment() || it.isContainer() || !it.isChangeable();
        Functions.Function1 _function_1 = it -> ArchitecturePackage.Literals.AD_ELEMENT.isSuperTypeOf(it.getEReferenceType());
        Consumer<EReference> _function_2 = xref -> {
            boolean _isSuperTypeOf_4;
            boolean _isSuperTypeOf_3;
            boolean _isSuperTypeOf_2;
            boolean _isSuperTypeOf_1;
            EClass _eReferenceType;
            EClass type = _eReferenceType = xref.getEReferenceType();
            boolean _matched = false;
            boolean _isSuperTypeOf = ArchitecturePackage.Literals.CONCERN.isSuperTypeOf(type);
            if (_isSuperTypeOf) {
                _matched = true;
                UnaryOperator _function_3 = it -> this._architectureExtensions.mergedConcern(it.getName());
                this._architectureExtensions.eGetAsList((EObject)result, (EStructuralFeature)xref, Concern.class).replaceAll(_function_3);
            }
            if (!_matched && (_isSuperTypeOf_1 = ArchitecturePackage.Literals.STAKEHOLDER.isSuperTypeOf(type))) {
                _matched = true;
                UnaryOperator _function_4 = it -> this._architectureExtensions.mergedStakeholder(it.getName());
                this._architectureExtensions.eGetAsList((EObject)result, (EStructuralFeature)xref, Stakeholder.class).replaceAll(_function_4);
            }
            if (!_matched && (_isSuperTypeOf_2 = ArchitecturePackage.Literals.REPRESENTATION_KIND.isSuperTypeOf(type))) {
                _matched = true;
                UnaryOperator _function_5 = it -> this.merged((RepresentationKind)it);
                this._architectureExtensions.eGetAsList((EObject)result, (EStructuralFeature)xref, RepresentationKind.class).replaceAll(_function_5);
            }
            if (!_matched && (_isSuperTypeOf_3 = ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT.isSuperTypeOf(type))) {
                _matched = true;
                UnaryOperator _function_6 = it -> this._architectureContextRule.merged((ArchitectureContext)it);
                this._architectureExtensions.eGetAsList((EObject)result, (EStructuralFeature)xref, ArchitectureContext.class).replaceAll(_function_6);
            }
            if (!_matched && (_isSuperTypeOf_4 = ArchitecturePackage.Literals.ARCHITECTURE_DOMAIN.isSuperTypeOf(type))) {
                _matched = true;
                UnaryOperator _function_7 = it -> this._architectureDomainRule.merged((ArchitectureDomain)it);
                this._architectureExtensions.eGetAsList((EObject)result, (EStructuralFeature)xref, ArchitectureDomain.class).replaceAll(_function_7);
            }
        };
        IterableExtensions.filter((Iterable)IterableExtensions.reject((Iterable)representation.eClass().getEAllReferences(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
        ArchitectureExtensions.logf("Copied %s to %s", representation, result);
    }
}

