/*******************************************************************************
 * Copyright (c) 2000, 2011 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.sun.jdi;

import java.util.List;
/**
 * See http://docs.oracle.com/javase/6/docs/jdk/api/jpda/jdi/com/sun/jdi/ThreadGroupReference.html
 */
public interface ThreadGroupReference extends ObjectReference {
	public String name();
	public ThreadGroupReference parent();
	public void resume();
	public void suspend();
	public List<ThreadGroupReference> threadGroups();
	public List<ThreadReference> threads();
}
