/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Objects;

public class ComparisonDifference
implements Comparable<ComparisonDifference> {
    private static final String FIELD = "field/property '%s'";
    private static final String TOP_LEVEL_OBJECTS = "Top level actual and expected objects";
    private static final String TEMPLATE = "%s differ:%n- actual value   : %s%n- expected value : %s%s";
    final List<String> path;
    final String concatenatedPath;
    final Object actual;
    final Object expected;
    final Optional<String> additionalInformation;

    public ComparisonDifference(List<String> path, Object actual, Object other) {
        this(path, actual, other, null);
    }

    public ComparisonDifference(List<String> path, Object actual, Object other, String additionalInformation) {
        java.util.Objects.requireNonNull(path, "a path can't be null");
        this.path = Collections.unmodifiableList(path);
        this.concatenatedPath = String.join((CharSequence)".", this.path);
        this.actual = actual;
        this.expected = other;
        this.additionalInformation = Optional.ofNullable(additionalInformation);
    }

    public static ComparisonDifference rootComparisonDifference(Object actual, Object other, String additionalInformation) {
        return new ComparisonDifference(Lists.list(""), actual, other, additionalInformation);
    }

    public String getPath() {
        return this.concatenatedPath;
    }

    public Object getActual() {
        return this.actual;
    }

    public Object getExpected() {
        return this.expected;
    }

    public Optional<String> getDescription() {
        return this.additionalInformation;
    }

    public String toString() {
        return this.additionalInformation.isPresent() ? String.format("ComparisonDifference [path=%s, actual=%s, expected=%s, additionalInformation=%s]", this.concatenatedPath, this.actual, this.expected, this.additionalInformation.get()) : String.format("ComparisonDifference [path=%s, actual=%s, expected=%s]", this.concatenatedPath, this.actual, this.expected);
    }

    public String multiLineDescription() {
        return this.multiLineDescription(ConfigurationProvider.CONFIGURATION_PROVIDER.representation());
    }

    public String multiLineDescription(Representation representation) {
        String expectedRepresentation;
        String actualRepresentation = representation.toStringOf(this.actual);
        boolean sameRepresentation = Objects.areEqual(actualRepresentation, expectedRepresentation = representation.toStringOf(this.expected));
        String unambiguousActualRepresentation = sameRepresentation ? representation.unambiguousToStringOf(this.actual) : actualRepresentation;
        String unambiguousExpectedRepresentation = sameRepresentation ? representation.unambiguousToStringOf(this.expected) : expectedRepresentation;
        String additionalInfo = this.additionalInformation.map(ComparisonDifference::formatOnNewline).orElse("");
        return String.format(TEMPLATE, this.getObjectPathDescription(), unambiguousActualRepresentation, unambiguousExpectedRepresentation, additionalInfo);
    }

    private String getObjectPathDescription() {
        return this.concatenatedPath.isEmpty() ? TOP_LEVEL_OBJECTS : String.format(FIELD, this.getPath());
    }

    private static String formatOnNewline(String info) {
        return String.format("%n%s", info);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ComparisonDifference)) {
            return false;
        }
        ComparisonDifference castOther = (ComparisonDifference)other;
        return java.util.Objects.equals(this.concatenatedPath, castOther.concatenatedPath) && java.util.Objects.equals(this.actual, castOther.actual) && java.util.Objects.equals(this.expected, castOther.expected) && java.util.Objects.equals(this.additionalInformation, castOther.additionalInformation);
    }

    public int hashCode() {
        return java.util.Objects.hash(this.concatenatedPath, this.actual, this.expected, this.additionalInformation);
    }

    @Override
    public int compareTo(ComparisonDifference other) {
        return String.join((CharSequence)"", this.path).compareTo(String.join((CharSequence)"", other.path));
    }
}

