/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.commands;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.util.StringConstants;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.PropertiesSetStyle;

public class ModifyPortsColorCommand
extends AbstractTransactionalCommand {
    private IGraphicalEditPart ep;
    private Integer color;

    public ModifyPortsColorCommand(TransactionalEditingDomain editingDomain, IGraphicalEditPart ep, Integer color) {
        super(editingDomain, "Modify Ports Color", null);
        this.ep = ep;
        this.color = color;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        PropertiesSetStyle style;
        List ports = this.getPorts();
        if (ports != null && this.color != null && !ports.isEmpty() && (style = (PropertiesSetStyle)this.ep.getNotationView().getNamedStyle(NotationPackage.eINSTANCE.getPropertiesSetStyle(), StringConstants.PORTS_PROPERTIES_STYLE_NAME)) != null && style.hasProperty(StringConstants.PORTS_COLOR_PROPERTY_NAME)) {
            style.setProperty(StringConstants.PORTS_COLOR_PROPERTY_NAME, (Object)this.color);
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newCancelledCommandResult();
    }

    private List getPorts() {
        LinkedList ports = new LinkedList();
        for (Object obj : this.ep.getChildren()) {
            if (!(obj instanceof TerminalEditPart)) continue;
            ports.add(obj);
        }
        return ports;
    }

    public boolean canExecute() {
        if (this.ep.getNotationView() != null && this.ep.getNotationView().getNamedStyle(NotationPackage.eINSTANCE.getPropertiesSetStyle(), StringConstants.PORTS_PROPERTIES_STYLE_NAME) != null) {
            List ports = this.getPorts();
            return ports != null && !ports.isEmpty() && super.canExecute();
        }
        return false;
    }
}

