/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.compatibility.EMF_2_9;
import org.eclipse.ocl.pivot.internal.resource.StandalonePlatformURIHandlerImpl;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.URIUtil;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StandaloneProjectMap
implements ProjectManager {
    private static final String PLUGIN_ID = "org.eclipse.ocl.pivot";
    private static final Logger logger = Logger.getLogger(StandaloneProjectMap.class);
    private static @Nullable Set<@NonNull String> alreadyLogged = null;
    public static final @NonNull TracingOption PROJECT_MAP_ADD_EPACKAGE = new TracingOption("org.eclipse.ocl.pivot", "projectMap/addEPackage");
    public static final @NonNull TracingOption PROJECT_MAP_ADD_GEN_MODEL = new TracingOption("org.eclipse.ocl.pivot", "projectMap/addGenModel");
    public static final @NonNull TracingOption PROJECT_MAP_ADD_GENERATED_PACKAGE = new TracingOption("org.eclipse.ocl.pivot", "projectMap/addGeneratedPackage");
    public static final @NonNull TracingOption PROJECT_MAP_ADD_URI_MAP = new TracingOption("org.eclipse.ocl.pivot", "projectMap/addURIMap");
    public static final @NonNull TracingOption PROJECT_MAP_CONFIGURE = new TracingOption("org.eclipse.ocl.pivot", "projectMap/configure");
    public static final @NonNull TracingOption PROJECT_MAP_GET = new TracingOption("org.eclipse.ocl.pivot", "projectMap/get");
    public static final @NonNull TracingOption PROJECT_MAP_INSTALL = new TracingOption("org.eclipse.ocl.pivot", "projectMap/install");
    public static final @NonNull TracingOption PROJECT_MAP_RESOLVE = new TracingOption("org.eclipse.ocl.pivot", "projectMap/resolve");
    public static boolean TEST_MAY_INITIALIZE_GLOBAL_FACILITIES = !EMFPlugin.IS_ECLIPSE_RUNNING;
    public static @Nullable WeakHashMap<@NonNull StandaloneProjectMap, @Nullable Object> liveStandaloneProjectMaps = null;
    private static @Nullable Map<@NonNull String, @NonNull Integer> tracedURI2traces = null;
    private static int instanceCounter = 0;
    private final int instanceCount = ++instanceCounter;
    protected final boolean isGlobal;
    private @Nullable Map<@NonNull String, @NonNull Exception> exceptionMap = null;
    private Map<@NonNull String, @NonNull ProjectManager.IProjectDescriptor> project2descriptor = null;
    protected boolean initializedPlatformResourceMap = false;
    protected @Nullable Map<@NonNull URI, @NonNull ProjectManager.IPackageDescriptor> nsURI2package = null;
    protected @Nullable Map<@NonNull URI, @NonNull ProjectManager.IResourceDescriptor> uri2resource = null;

    public static @Nullable StandaloneProjectMap findAdapter(@NonNull ResourceSet resourceSet) {
        return (StandaloneProjectMap)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), StandaloneProjectMap.class);
    }

    public static @NonNull StandaloneProjectMap getAdapter(@NonNull ResourceSet resourceSet) {
        StandaloneProjectMap adapter = StandaloneProjectMap.findAdapter(resourceSet);
        if (adapter == null) {
            adapter = new StandaloneProjectMap(false);
            adapter.initializeResourceSet(resourceSet);
        }
        return adapter;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EPackage.Registry getPackageRegistry(@Nullable ResourceSet resourceSet) {
        assert (resourceSet != null || TEST_MAY_INITIALIZE_GLOBAL_FACILITIES);
        if (resourceSet == null) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull EPackage.Registry globalRegistry = EPackage.Registry.INSTANCE;
            return globalRegistry;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        return packageRegistry;
    }

    public static Resource.Factory.Registry getResourceFactoryRegistry(@Nullable ResourceSet resourceSet) {
        assert (resourceSet != null || TEST_MAY_INITIALIZE_GLOBAL_FACILITIES);
        return resourceSet != null ? resourceSet.getResourceFactoryRegistry() : Resource.Factory.Registry.INSTANCE;
    }

    public static @NonNull URIConverter getURIConverter(@Nullable ResourceSet resourceSet) {
        assert (resourceSet != null || TEST_MAY_INITIALIZE_GLOBAL_FACILITIES);
        return resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
    }

    public static @NonNull Map<URI, URI> getURIMap(@Nullable ResourceSet resourceSet) {
        assert (resourceSet != null || TEST_MAY_INITIALIZE_GLOBAL_FACILITIES);
        return resourceSet != null ? resourceSet.getURIConverter().getURIMap() : URIConverter.URI_MAP;
    }

    public static void initStatics() {
        GenModelReader.initStatics();
        new PluginReader(null);
    }

    public static void initializeURIResourceMap(@Nullable ResourceSet resourceSet) {
        ResourceSetImpl resourceSetImpl;
        Map uriResourceMap;
        if (resourceSet instanceof ResourceSetImpl && (uriResourceMap = (resourceSetImpl = (ResourceSetImpl)resourceSet).getURIResourceMap()) == null) {
            resourceSetImpl.setURIResourceMap(new HashMap());
        }
    }

    public static synchronized void addTrace(String nsURI, int bitMask) {
        if (nsURI != null) {
            Integer oldMask;
            Map<@NonNull String, @NonNull Integer> tracedURI2traces2 = tracedURI2traces;
            if (tracedURI2traces2 == null) {
                tracedURI2traces = tracedURI2traces2 = new HashMap<String, Integer>();
            }
            if ((oldMask = tracedURI2traces2.get(nsURI)) != null) {
                bitMask |= oldMask.intValue();
            }
            tracedURI2traces2.put(nsURI, bitMask);
        }
    }

    public static synchronized void removeTrace(String nsURI) {
        Map<String, Integer> tracedURI2traces2;
        if (nsURI != null && (tracedURI2traces2 = tracedURI2traces) != null) {
            tracedURI2traces2.remove(nsURI);
            if (tracedURI2traces2.isEmpty()) {
                tracedURI2traces = null;
            }
        }
    }

    public StandaloneProjectMap(boolean isGlobal) {
        this.isGlobal = isGlobal;
        if (liveStandaloneProjectMaps != null) {
            liveStandaloneProjectMaps.put(this, null);
            PivotUtilInternal.debugPrintln("Create " + this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        }
    }

    @Override
    public void addResourceDescriptor(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor) {
        Map<@NonNull URI, @NonNull ProjectManager.IResourceDescriptor> uri2resource2 = this.uri2resource;
        if (uri2resource2 == null) {
            this.uri2resource = uri2resource2 = new HashMap<URI, ProjectManager.IResourceDescriptor>();
        }
        uri2resource2.put(resourceDescriptor.getPlatformPluginURI(), resourceDescriptor);
        uri2resource2.put(resourceDescriptor.getPlatformResourceURI(), resourceDescriptor);
    }

    @Override
    public void configure(@Nullable ResourceSet resourceSet, @NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
        Map<@NonNull String, @NonNull ProjectManager.IProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
        if (projectDescriptors != null) {
            for (ProjectManager.IProjectDescriptor projectDescriptor : projectDescriptors.values()) {
                projectDescriptor.configure(resourceSet, resourceLoadStrategy, conflictHandler);
            }
        }
    }

    @Override
    public void configureLoadFirst(@NonNull ResourceSet resourceSet, String nsURI) {
        URI ecoreURI = URI.createURI((String)nsURI);
        ProjectManager.IPackageDescriptor packageDescriptor = this.getPackageDescriptor(ecoreURI);
        if (packageDescriptor != null) {
            packageDescriptor.configure(resourceSet, LoadFirstStrategy.INSTANCE, null);
        }
    }

    protected @NonNull ProjectManager.IProjectDescriptor createProjectDescriptor(@NonNull String projectName, @NonNull URI locationURI) {
        return new ProjectDescriptor(this, projectName, locationURI);
    }

    protected void finalize() throws Throwable {
        WeakHashMap<@NonNull StandaloneProjectMap, @Nullable Object> liveStandaloneProjectMaps2 = liveStandaloneProjectMaps;
        if (liveStandaloneProjectMaps2 != null) {
            PivotUtilInternal.debugPrintln("Finalize " + this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)));
            ArrayList<@NonNull StandaloneProjectMap> keySet = new ArrayList<StandaloneProjectMap>(liveStandaloneProjectMaps2.keySet());
            if (!keySet.isEmpty()) {
                StringBuilder s = new StringBuilder();
                s.append(" live");
                for (StandaloneProjectMap projectMap : keySet) {
                    s.append(" @" + Integer.toHexString(System.identityHashCode(projectMap)));
                }
                System.out.println(s);
            }
        }
    }

    protected @NonNull String @NonNull [] getClassPathEntries() {
        String property = System.getProperty("java.class.path", "");
        String separator = System.getProperty("path.separator", ";");
        assert (property != null);
        assert (separator != null);
        return property.split(separator);
    }

    @Override
    public @Nullable ProjectManager.IPackageDescriptor getPackageDescriptor(@NonNull URI nsURI) {
        return this.nsURI2package != null ? this.nsURI2package.get(nsURI) : null;
    }

    public @Nullable ProjectManager.IProjectDescriptor getProjectDescriptor(@NonNull String projectName) {
        Map<@NonNull String, @NonNull ProjectManager.IProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
        if (projectDescriptors == null) {
            return null;
        }
        return projectDescriptors.get(projectName);
    }

    protected @NonNull ProjectManager.IProjectDescriptor getProjectDescriptorInternal(@NonNull URI platformURI) {
        @NonNull String projectName = platformURI.segment(1);
        this.getProjectDescriptors();
        ProjectManager.IProjectDescriptor projectDescriptor = this.project2descriptor.get(projectName);
        if (projectDescriptor == null) {
            @NonNull URI locationURI = platformURI.trimSegments(platformURI.segmentCount() - 2).appendSegment("");
            projectDescriptor = this.createProjectDescriptor(projectName, locationURI);
            this.project2descriptor.put(projectName, projectDescriptor);
        }
        return projectDescriptor;
    }

    public @Nullable Map<@NonNull String, @NonNull Exception> getExceptionMap() {
        return this.exceptionMap;
    }

    public @Nullable URI getLocation(@NonNull String projectName) {
        Map<@NonNull String, @NonNull ProjectManager.IProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
        if (projectDescriptors == null) {
            return null;
        }
        ProjectManager.IProjectDescriptor projectDescriptor = projectDescriptors.get(projectName);
        if (projectDescriptor == null) {
            return null;
        }
        return projectDescriptor.getLocationURI();
    }

    protected synchronized @Nullable Map<@NonNull String, @NonNull ProjectManager.IProjectDescriptor> getProjectDescriptors() {
        Map<@NonNull String, @NonNull ProjectManager.IProjectDescriptor> project2descriptor2 = this.project2descriptor;
        if (project2descriptor2 == null) {
            this.project2descriptor = project2descriptor2 = new HashMap<String, ProjectManager.IProjectDescriptor>();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = factory.newSAXParser();
                if (saxParser != null) {
                    this.scanClassPath(project2descriptor2, saxParser);
                }
            }
            catch (Exception e) {
                this.logException("Failed to  create SAXParser", e);
                return null;
            }
        }
        return project2descriptor2;
    }

    public @Nullable Set<@NonNull String> getProjectNames() {
        Map<@NonNull String, @NonNull ProjectManager.IProjectDescriptor> project2descriptor2 = this.getProjectDescriptors();
        if (project2descriptor2 == null) {
            return null;
        }
        return project2descriptor2.keySet();
    }

    @Override
    public @Nullable ProjectManager.IResourceDescriptor getResourceDescriptor(@NonNull URI uri) {
        Map<@NonNull URI, @NonNull ProjectManager.IResourceDescriptor> uri2resource2 = this.uri2resource;
        if (uri2resource2 == null) {
            return null;
        }
        return uri2resource2.get(uri);
    }

    public Notifier getTarget() {
        return null;
    }

    public synchronized void initializeGenModelLocationMap(boolean force) {
        if (force || this.nsURI2package == null) {
            HashMap<@NonNull URI, @NonNull ProjectManager.IPackageDescriptor> nsURI2package2 = new HashMap<URI, ProjectManager.IPackageDescriptor>();
            this.nsURI2package = nsURI2package2;
            Map<@NonNull String, @NonNull ProjectManager.IProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
            if (projectDescriptors != null) {
                for (ProjectManager.IProjectDescriptor projectDescriptor : projectDescriptors.values()) {
                    projectDescriptor.initializeGenModelLocationMap(nsURI2package2);
                }
            }
        }
    }

    public synchronized void initializePackageRegistry(@Nullable ResourceSet resourceSet) {
        this.getProjectDescriptors();
        for (ProjectManager.IProjectDescriptor projectDescriptor : this.project2descriptor.values()) {
            Collection<ProjectManager.IResourceDescriptor> resourceDescriptors = projectDescriptor.getResourceDescriptors();
            if (resourceDescriptors == null) continue;
            for (ProjectManager.IResourceDescriptor resourceDescriptor : resourceDescriptors) {
                assert (resourceDescriptor != null);
                if (!resourceDescriptor.hasEcoreModel()) continue;
                ProjectManager.IResourceLoadStatus resourceLoadStatus = resourceDescriptor.getResourceLoadStatus(resourceSet);
                resourceLoadStatus.setConflictHandler(MapToFirstConflictHandlerWithLog.INSTANCE);
            }
        }
    }

    public synchronized void initializePlatformResourceMap(boolean force) {
        if (force || !this.initializedPlatformResourceMap) {
            this.initializedPlatformResourceMap = true;
            this.getProjectDescriptors();
            for (ProjectManager.IProjectDescriptor projectDescriptor : this.project2descriptor.values()) {
                projectDescriptor.initializePlatformResourceMap();
            }
        }
    }

    @Override
    public void initializeResourceSet(@Nullable ResourceSet resourceSet) {
        StandaloneProjectMap.initializeURIResourceMap(resourceSet);
        this.initializePlatformResourceMap(false);
        this.initializeURIMap(resourceSet);
        this.initializeGenModelLocationMap(false);
        this.initializePackageRegistry(resourceSet);
        if (resourceSet != null) {
            EList eAdapters;
            URIConverter uriConverter = resourceSet.getURIConverter();
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                StandalonePlatformURIHandlerImpl.install(uriConverter, this);
            }
            if (!(eAdapters = resourceSet.eAdapters()).contains(this)) {
                eAdapters.add(this);
            }
        }
    }

    public synchronized void initializeURIMap(@Nullable ResourceSet resourceSet) {
        this.getProjectDescriptors();
        Map<URI, URI> uriMap = StandaloneProjectMap.getURIMap(resourceSet);
        for (String project : this.project2descriptor.keySet()) {
            ProjectManager.IProjectDescriptor projectDescriptor = this.project2descriptor.get(project);
            assert (projectDescriptor != null);
            projectDescriptor.initializeURIMap(uriMap);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(StandaloneProjectMap.class);
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    protected void logException(@NonNull String message, @NonNull Exception e) {
        Map<String, Exception> exceptionMap2;
        Set<@NonNull String> alreadyLogged2 = alreadyLogged;
        if (alreadyLogged2 == null) {
            alreadyLogged = alreadyLogged2 = new HashSet<String>();
        }
        if (alreadyLogged2.add(message)) {
            logger.info((Object)message, (Throwable)e);
        }
        if ((exceptionMap2 = this.exceptionMap) == null) {
            this.exceptionMap = exceptionMap2 = new HashMap<String, Exception>();
        }
        exceptionMap2.put(message, e);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof ResourceSet) {
            int eventType = notification.getEventType();
            int featureID = notification.getFeatureID(ResourceSet.class);
            if (featureID == 0) {
                Object newValues;
                if (eventType == 3) {
                    Object newValue = notification.getNewValue();
                    if (newValue instanceof Resource) {
                        this.notifyAddedDynamicResource((ResourceSet)notifier, (Resource)newValue);
                    }
                } else if (eventType == 5 && (newValues = notification.getNewValue()) instanceof Iterable) {
                    for (Object newValue : (Iterable)newValues) {
                        if (!(newValue instanceof Resource)) continue;
                        this.notifyAddedDynamicResource((ResourceSet)notifier, (Resource)newValue);
                    }
                }
            }
        }
    }

    protected void notifyAddedDynamicResource(@NonNull ResourceSet resourceSet, @NonNull Resource resource) {
        URI uri;
        ProjectManager.IResourceDescriptor resourceDescriptor;
        Map<URI, ProjectManager.IResourceDescriptor> uri2resource2;
        if (resourceSet instanceof ResourceSetImpl && (uri2resource2 = this.uri2resource) != null && (resourceDescriptor = uri2resource2.get(uri = resource.getURI())) != null) {
            resourceDescriptor.addedDynamicResource(resourceSet, resource);
        }
    }

    protected @Nullable ProjectManager.IProjectDescriptor registerBundle(@NonNull File file, @NonNull SAXParser saxParser) {
        block32: {
            ProjectManager.IProjectDescriptor iProjectDescriptor;
            JarFile jarFile = null;
            try {
                ProjectManager.IProjectDescriptor projectDescriptor;
                jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    return null;
                }
                String project = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (project == null) break block32;
                int indexOf = project.indexOf(59);
                if (indexOf > 0) {
                    project = project.substring(0, indexOf);
                }
                if ((projectDescriptor = this.project2descriptor.get(project)) != null) {
                    ProjectManager.IProjectDescriptor iProjectDescriptor2 = projectDescriptor;
                    return iProjectDescriptor2;
                }
                String path = "archive:" + file.toURI() + "!/";
                @NonNull URI locationURI = URI.createURI((String)path);
                assert (project != null);
                projectDescriptor = this.createProjectDescriptor(project, locationURI);
                this.project2descriptor.put(project, projectDescriptor);
                ZipEntry entry = jarFile.getEntry("plugin.xml");
                if (entry != null) {
                    try (InputStream inputStream = jarFile.getInputStream(entry);){
                        PluginReader pluginReader = new PluginReader(jarFile, projectDescriptor);
                        saxParser.parse(inputStream, (DefaultHandler)pluginReader);
                        pluginReader.scanContents(saxParser);
                    }
                }
                iProjectDescriptor = projectDescriptor;
            }
            catch (ZipException e) {
                this.logException("Could not open Jar file '" + file.getAbsolutePath() + "'", e);
                break block32;
            }
            catch (Exception e) {
                this.logException("Failed to read '" + file.getAbsolutePath() + "'", e);
                break block32;
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return iProjectDescriptor;
        }
        return null;
    }

    protected @Nullable ProjectManager.IProjectDescriptor registerProject(@NonNull File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            String project = document.getDocumentElement().getElementsByTagName("name").item(0).getTextContent();
            if (project != null) {
                @NonNull URI locationURI = URI.createFileURI((String)(String.valueOf(file.getParentFile().getCanonicalPath()) + File.separator));
                ProjectManager.IProjectDescriptor projectDescriptor = this.createProjectDescriptor(project, locationURI);
                this.project2descriptor.put(project, projectDescriptor);
                ProjectManager.IProjectDescriptor iProjectDescriptor = projectDescriptor;
                return iProjectDescriptor;
            }
        }
        catch (Exception e) {
            this.logException("Couldn't read '" + file + "'", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Override
    public void removeResourceDescriptor(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor) {
        Map<@NonNull URI, @NonNull ProjectManager.IResourceDescriptor> uri2resource2 = this.uri2resource;
        if (uri2resource2 != null) {
            uri2resource2.remove(resourceDescriptor.getPlatformPluginURI());
            uri2resource2.remove(resourceDescriptor.getPlatformResourceURI());
        }
    }

    protected void scanClassPath(@NonNull Map<@NonNull String, @NonNull ProjectManager.IProjectDescriptor> projectDescriptors, @NonNull SAXParser saxParser) {
        String[] entries;
        String[] stringArray = entries = this.getClassPathEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String entry = stringArray[n2];
                File fileEntry = new File(entry);
                try {
                    File f = fileEntry.getCanonicalFile();
                    if (f.getPath().endsWith(".jar")) {
                        this.registerBundle(f, saxParser);
                        break block6;
                    }
                    if (this.scanFolder(f, saxParser, new HashSet<String>(), 0)) break block6;
                    while ((f = f.getParentFile()) != null) {
                        File plugIn;
                        File dotProject = new File(f, ".project");
                        if (!dotProject.exists()) continue;
                        ProjectManager.IProjectDescriptor projectDescriptor = this.registerProject(dotProject);
                        if (projectDescriptor != null && (plugIn = new File(f, "plugin.xml")).exists()) {
                            PluginReader pluginReader = new PluginReader(projectDescriptor);
                            saxParser.parse(plugIn, (DefaultHandler)pluginReader);
                            pluginReader.scanContents(saxParser);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    this.logException("Failed to read '" + fileEntry + "'", e);
                }
            }
            ++n2;
        }
    }

    protected boolean scanFolder(@NonNull File f, @NonNull SAXParser saxParser, @NonNull Set<String> alreadyVisited, int depth) {
        try {
            if (!alreadyVisited.add(f.getCanonicalPath())) {
                return true;
            }
        }
        catch (Exception e) {
            this.logException("Failed to scan '" + f + "'", e);
            return true;
        }
        File[] files = f.listFiles();
        boolean containsProject = false;
        File dotProject = null;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists() && file.isDirectory() && depth < 2 && !file.getName().startsWith(".")) {
                    containsProject |= this.scanFolder(file, saxParser, alreadyVisited, depth + 1);
                } else if (".project".equals(file.getName())) {
                    dotProject = file;
                } else if (file.getName().endsWith(".jar")) {
                    this.registerBundle(file, saxParser);
                }
                ++n2;
            }
        }
        if (!containsProject && dotProject != null) {
            this.registerProject(dotProject);
        }
        return containsProject || dotProject != null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.project2descriptor != null) {
            ArrayList<@NonNull String> projectNames = new ArrayList<String>(this.project2descriptor.keySet());
            Collections.sort(projectNames);
            for (String projectName : projectNames) {
                if (s.length() > 0) {
                    s.append("\n");
                }
                s.append(projectName);
                s.append(" => ");
                ProjectManager.IProjectDescriptor projectDescriptor = this.project2descriptor.get(projectName);
                assert (projectDescriptor != null);
                s.append(projectDescriptor.getLocationURI());
            }
        }
        return s.toString();
    }

    @Override
    public void unload(@NonNull ResourceSet resourceSet) {
        resourceSet.eAdapters().remove((Object)this);
        if (this.project2descriptor != null) {
            for (ProjectManager.IProjectDescriptor projectDescriptor : this.project2descriptor.values()) {
                projectDescriptor.unload(resourceSet);
            }
        }
    }

    @Override
    public void useGeneratedResource(@NonNull Resource resource, @NonNull ResourceSet resourceSet) {
        ProjectManager.IPackageDescriptor packageDescriptor;
        URI uri = resource.getURI();
        if (uri != null && (packageDescriptor = this.getPackageDescriptor(uri)) != null) {
            ProjectManager.IResourceDescriptor resourceDescriptor = packageDescriptor.getResourceDescriptor();
            ProjectManager.IResourceLoadStatus resourceLoadStatus = resourceDescriptor.getResourceLoadStatus(resourceSet);
            ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
            if (PROJECT_MAP_GET.isActive()) {
                PROJECT_MAP_GET.println("Use " + uri + " with " + resourceLoadStrategy + " in " + NameUtil.debugSimpleName(resourceLoadStatus.getPackageRegistry()));
            }
            resourceLoadStrategy.useGeneratedResource(resourceLoadStatus, resource);
        }
    }

    public static abstract class AbstractResourceDescriptor
    implements ProjectManager.IResourceDescriptor {
        protected final @NonNull ProjectManager.IProjectDescriptor projectDescriptor;
        protected final @NonNull URI genModelURI;
        private @Nullable URI locationURI = null;
        private @Nullable URI platformResourceURI = null;
        private @Nullable URI platformPluginURI = null;
        protected final @NonNull List<@NonNull ProjectManager.IPackageDescriptor> packageDescriptors = new ArrayList<ProjectManager.IPackageDescriptor>();
        private boolean hasEcoreModel = false;
        private final @NonNull WeakHashMap<@Nullable ResourceSet, @NonNull ProjectManager.IResourceLoadStatus> resourceSet2resourceLoadStatus = new WeakHashMap();

        protected AbstractResourceDescriptor(@NonNull ProjectManager.IProjectDescriptor projectDescriptor, @NonNull URI genModelURI, @NonNull Map<@NonNull URI, @NonNull String> nsURI2className) {
            this.projectDescriptor = projectDescriptor;
            this.genModelURI = genModelURI;
            for (URI nsURI : nsURI2className.keySet()) {
                String className = nsURI2className.get(nsURI);
                ProjectManager.IPackageDescriptor packageDescriptor = projectDescriptor.getPackageDescriptor(nsURI);
                if (packageDescriptor != null) continue;
                if (PROJECT_MAP_ADD_GENERATED_PACKAGE.isActive()) {
                    PROJECT_MAP_ADD_GENERATED_PACKAGE.println(nsURI + " : " + genModelURI + " : " + className);
                }
                packageDescriptor = new PackageDescriptor(this, nsURI, className);
                projectDescriptor.addPackageDescriptor(packageDescriptor);
                this.packageDescriptors.add(packageDescriptor);
            }
            projectDescriptor.addResourceDescriptor(this);
        }

        @Override
        public void addedDynamicResource(@NonNull ResourceSet resourceSet, @NonNull Resource resource) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.resourceSet2resourceLoadStatus.get(resourceSet);
            if (resourceLoadStatus != null) {
                Map tracedURI2traces2;
                ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
                if (PROJECT_MAP_GET.isActive()) {
                    PROJECT_MAP_GET.println("Add " + resource.getURI() + " with " + resourceLoadStrategy + " in " + NameUtil.debugSimpleName(resourceSet.getPackageRegistry()));
                }
                if ((tracedURI2traces2 = tracedURI2traces) != null) {
                    StandaloneProjectMap projectMap = (StandaloneProjectMap)this.getProjectDescriptor().getProjectManager();
                    for (URI uri : ((AbstractResourceLoadStatus)resourceLoadStatus).nsURI2packageLoadStatus.keySet()) {
                        String nsURI = uri.toString();
                        Integer mask = (Integer)tracedURI2traces2.get(nsURI);
                        if (mask == null) continue;
                        System.out.println(String.valueOf(projectMap.getClass().getSimpleName()) + "-" + projectMap.instanceCount + ": addedDynamicResource '" + resource.getURI() + "' containing '" + nsURI + "'");
                    }
                }
                resourceLoadStrategy.addedDynamicResource(resourceLoadStatus, resource);
            }
        }

        @Override
        public void addedGeneratedPackage(@NonNull ResourceSet resourceSet, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.resourceSet2resourceLoadStatus.get(resourceSet);
            if (resourceLoadStatus != null) {
                ProjectManager.IPackageLoadStatus packageLoadStatus;
                @NonNull URI uri = URI.createURI((String)ePackage.getNsURI());
                ProjectManager.IPackageDescriptor packageDescriptor = this.getProjectDescriptor().getPackageDescriptor(uri);
                if (packageDescriptor != null && (packageLoadStatus = resourceLoadStatus.getPackageLoadStatus(packageDescriptor)) != null) {
                    resourceLoadStatus.getResourceLoadStrategy().addedGeneratedPackage(packageLoadStatus, ePackage);
                }
            }
        }

        @Override
        public void configure(@Nullable ResourceSet resourceSet, @NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            if (this.hasEcoreModel) {
                ProjectManager.IResourceLoadStatus resourceLoadStatus = this.getResourceLoadStatus(resourceSet);
                resourceLoadStrategy.configure(resourceLoadStatus, conflictHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void configureResourceSetURIResourceMap(@NonNull ResourceSet resourceSet, @NonNull Resource resource) {
            HashMap<URI, Resource> uriResourceMap;
            ResourceSet resourceSet2 = resourceSet;
            synchronized (resourceSet2) {
                uriResourceMap = ((ResourceSetImpl)resourceSet).getURIResourceMap();
                if (uriResourceMap == null) {
                    uriResourceMap = new HashMap<URI, Resource>();
                    ((ResourceSetImpl)resourceSet).setURIResourceMap(uriResourceMap);
                }
            }
            URI platformPluginURI = this.getPlatformPluginURI();
            URI platformResourceURI = this.getPlatformResourceURI();
            HashMap<URI, Resource> hashMap = uriResourceMap;
            synchronized (hashMap) {
                uriResourceMap.put(platformPluginURI, resource);
                uriResourceMap.put(platformResourceURI, resource);
            }
            if (PROJECT_MAP_RESOLVE.isActive()) {
                URI uri = resource.getURI();
                PROJECT_MAP_RESOLVE.println("ResourceSet.uriResourceMap[" + platformPluginURI + "] => " + uri);
                PROJECT_MAP_RESOLVE.println("ResourceSet.uriResourceMap[" + platformResourceURI + "] => " + uri);
            }
        }

        protected abstract @NonNull ProjectManager.IResourceLoadStatus createResourceLoadStatus(@Nullable ResourceSet var1);

        @Override
        public @NonNull URI getGenModelURI() {
            return this.genModelURI;
        }

        @Override
        public @NonNull URI getLocationURI() {
            return ClassUtil.nonNullState(this.locationURI);
        }

        public @NonNull List<@NonNull ? extends ProjectManager.IPackageDescriptor> getPackageDescriptors() {
            return this.packageDescriptors;
        }

        @Override
        public @NonNull URI getPlatformPluginURI() {
            return ClassUtil.nonNullState(this.platformPluginURI);
        }

        @Override
        public @NonNull URI getPlatformResourceURI() {
            return ClassUtil.nonNullState(this.platformResourceURI);
        }

        @Override
        public @NonNull ProjectManager.IProjectDescriptor getProjectDescriptor() {
            return this.projectDescriptor;
        }

        @Override
        public @NonNull URI getProjectRelativeEcorePackageURI(@NonNull URI genModelRelativeEcorePackageURI) {
            URI projectLocationURI = this.projectDescriptor.getLocationURI();
            URI absoluteGenModelURI = this.genModelURI.resolve(projectLocationURI);
            URI absolutePackageURI = genModelRelativeEcorePackageURI.resolve(absoluteGenModelURI);
            @NonNull URI projectRelativeEcorePackageURI = URIUtil.deresolve(absolutePackageURI, projectLocationURI, true, true, true);
            return projectRelativeEcorePackageURI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @NonNull ProjectManager.IResourceLoadStatus getResourceLoadStatus(@Nullable ResourceSet resourceSet) {
            assert (this.hasEcoreModel);
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.resourceSet2resourceLoadStatus.get(resourceSet);
            if (resourceLoadStatus == null) {
                WeakHashMap<ResourceSet, ProjectManager.IResourceLoadStatus> weakHashMap = this.resourceSet2resourceLoadStatus;
                synchronized (weakHashMap) {
                    resourceLoadStatus = this.resourceSet2resourceLoadStatus.get(resourceSet);
                    if (resourceLoadStatus == null) {
                        resourceLoadStatus = this.createResourceLoadStatus(resourceSet);
                        this.resourceSet2resourceLoadStatus.put(resourceSet, resourceLoadStatus);
                    }
                }
            }
            return resourceLoadStatus;
        }

        @Override
        public boolean hasEcoreModel() {
            return this.hasEcoreModel;
        }

        @Override
        public void setEcoreModel(@NonNull List<@NonNull String> genModelRelativeEcorePackageUris, @NonNull Map<@NonNull String, @NonNull ProjectManager.IPackageDescriptor> nsURI2packageDescriptor) {
            int size = genModelRelativeEcorePackageUris.size();
            if (size > 0) {
                @NonNull String firstGenModelRelativeEcorePackageUri = genModelRelativeEcorePackageUris.get(0);
                URI firstGenModelRelativeEcorePackageURI = URI.createURI((String)firstGenModelRelativeEcorePackageUri);
                @NonNull URI genModelRelativeEcoreModelURI = firstGenModelRelativeEcorePackageURI.trimFragment();
                URI projectLocationURI = this.projectDescriptor.getLocationURI();
                URI absoluteGenModelURI = this.genModelURI.resolve(projectLocationURI);
                URI absolutePackageURI = genModelRelativeEcoreModelURI.resolve(absoluteGenModelURI);
                URI relativePackageURI = URIUtil.deresolve(absolutePackageURI, projectLocationURI, true, true, true);
                @NonNull URI relativeEcoreModelURI = relativePackageURI.trimFragment();
                URI resourceURI = this.projectDescriptor.getPlatformResourceURI();
                URI pluginURI = this.projectDescriptor.getPlatformPluginURI();
                this.platformResourceURI = relativeEcoreModelURI.resolve(resourceURI);
                this.platformPluginURI = relativeEcoreModelURI.resolve(pluginURI);
                this.locationURI = relativeEcoreModelURI.resolve(projectLocationURI);
                this.projectDescriptor.getProjectManager().addResourceDescriptor(this);
            }
            this.hasEcoreModel = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unload(@NonNull ResourceSet resourceSet) {
            if (this.hasEcoreModel()) {
                WeakHashMap<ResourceSet, ProjectManager.IResourceLoadStatus> weakHashMap = this.resourceSet2resourceLoadStatus;
                synchronized (weakHashMap) {
                    ProjectManager.IResourceLoadStatus resourceLoadStatus = this.resourceSet2resourceLoadStatus.remove(resourceSet);
                    if (resourceLoadStatus != null) {
                        resourceLoadStatus.dispose();
                    }
                }
            }
        }
    }

    public static abstract class AbstractResourceLoadStatus
    implements ProjectManager.IResourceLoadStatus,
    Adapter {
        protected final @NonNull ProjectManager.IResourceDescriptor resourceDescriptor;
        protected @Nullable ResourceSet resourceSet;
        private final @NonNull Map<@NonNull URI, @NonNull PackageLoadStatus> nsURI2packageLoadStatus = new HashMap<URI, PackageLoadStatus>();
        protected final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull EPackage.Registry packageRegistry;
        protected @Nullable ProjectManager.IConflictHandler conflictHandler = MapToFirstConflictHandlerWithLog.INSTANCE;
        protected @NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy = LoadFirstStrategy.INSTANCE;
        private @Nullable Notifier target = null;
        protected @Nullable Resource eModel = null;
        protected boolean generativeLoadInProgress = false;
        protected boolean recursiveLoadInProgress = false;

        protected AbstractResourceLoadStatus(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor, @Nullable ResourceSet resourceSet) {
            this.resourceDescriptor = resourceDescriptor;
            this.resourceSet = resourceSet;
            this.packageRegistry = StandaloneProjectMap.getPackageRegistry(resourceSet);
            for (ProjectManager.IPackageDescriptor iPackageDescriptor : resourceDescriptor.getPackageDescriptors()) {
                this.nsURI2packageLoadStatus.put(iPackageDescriptor.getNsURI(), new PackageLoadStatus(this, iPackageDescriptor));
            }
        }

        @Override
        public void configureEPackageRegistry(@NonNull Resource resource) {
            ResourceSet resourceSet2 = this.resourceSet;
            if (resourceSet2 != null) {
                for (ProjectManager.IPackageLoadStatus iPackageLoadStatus : this.nsURI2packageLoadStatus.values()) {
                    EPackage ePackage = iPackageLoadStatus.getEPackage();
                    if (ePackage == null) continue;
                    iPackageLoadStatus.configureEPackageRegistry(resourceSet2);
                }
            }
        }

        @Override
        public void configureDelegatingResource() {
            ResourceSet resourceSet2 = this.resourceSet;
            if (resourceSet2 != null) {
                ResourceImpl resource;
                Collection<PackageLoadStatus> packageLoadStatuses = this.nsURI2packageLoadStatus.values();
                @NonNull URI uri = this.resourceDescriptor.getGenModelURI().appendFileExtension("ecore");
                if (packageLoadStatuses.size() == 1) {
                    @NonNull PackageLoadStatus packageLoadStatus = packageLoadStatuses.iterator().next();
                    resource = new DelegatedSinglePackageResource(uri, packageLoadStatus);
                } else {
                    resource = new DelegatedMultiplePackageResource(uri, this, packageLoadStatuses);
                }
                this.resourceDescriptor.configureResourceSetURIResourceMap(resourceSet2, (Resource)resource);
            }
        }

        @Override
        public void configureResourceSetURIResourceMap(@NonNull Resource resource) {
            ResourceSet resourceSet2 = this.resourceSet;
            if (resourceSet2 != null) {
                this.resourceDescriptor.configureResourceSetURIResourceMap(resourceSet2, resource);
            }
        }

        @Override
        public void dispose() {
            this.resourceSet = null;
            if (this.target != null) {
                this.target.eAdapters().remove((Object)this);
                this.target = null;
            }
            for (PackageLoadStatus packageLoadStatus : this.nsURI2packageLoadStatus.values()) {
                packageLoadStatus.unloadedResource();
            }
        }

        @Override
        public @Nullable EPackage getConflictingDynamicResource(@NonNull EPackage ePackage) {
            if (this.conflictHandler != null) {
                return this.conflictHandler.handleConflictingDynamicResource(this, ePackage);
            }
            return null;
        }

        @Override
        public @Nullable EPackage getFirstEPackage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable ProjectManager.IPackageLoadStatus getPackageLoadStatus(@NonNull ProjectManager.IPackageDescriptor packageDescriptor) {
            return this.nsURI2packageLoadStatus.get(packageDescriptor.getNsURI());
        }

        @Override
        public @NonNull ProjectManager.IResourceLoadStrategy getResourceLoadStrategy() {
            return this.resourceLoadStrategy;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull EPackage.Registry getPackageRegistry() {
            return this.packageRegistry;
        }

        @Override
        public @NonNull ProjectManager.IResourceDescriptor getResourceDescriptor() {
            return this.resourceDescriptor;
        }

        public @Nullable Resource getResource() {
            Resource eModel2 = this.eModel;
            if (eModel2 == null) {
                try {
                    this.recursiveLoadInProgress = true;
                    ProjectManager.IResourceDescriptor resourceDescriptor2 = this.getResourceDescriptor();
                    if (resourceDescriptor2.hasEcoreModel()) {
                        URI platformResourceURI = resourceDescriptor2.getPlatformResourceURI();
                        ResourceSet resourceSet = this.resourceSet != null ? this.resourceSet : new ResourceSetImpl();
                        resourceSet.createResource(platformResourceURI);
                    }
                }
                finally {
                    this.recursiveLoadInProgress = false;
                }
            }
            return this.eModel;
        }

        @Override
        public @Nullable ResourceSet getResourceSet() {
            return this.resourceSet;
        }

        public @Nullable Notifier getTarget() {
            return this.target;
        }

        public @Nullable EPackage handleConflictingGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            if (this.conflictHandler != null && this.eModel != null) {
                return this.conflictHandler.handleConflictingGeneratedPackage(packageLoadStatus, this.eModel);
            }
            EPackage ePackage = packageLoadStatus.getEPackage();
            if (ePackage == null) {
                ePackage = packageLoadStatus.getEPackageInstance();
            }
            return ePackage;
        }

        protected void handleLoadException(Resource resource, @NonNull String location, Exception exception) throws RuntimeException {
            Exception cause = exception instanceof Resource.IOWrappedException ? (Exception)exception.getCause() : exception;
            class DiagnosticWrappedException
            extends WrappedException
            implements Resource.Diagnostic {
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ String val$location;

                public DiagnosticWrappedException(Exception exception, String string) {
                    this.val$location = string;
                    super(exception);
                }

                public String getLocation() {
                    return this.val$location;
                }

                public int getColumn() {
                    return 0;
                }

                public int getLine() {
                    return 0;
                }
            }
            DiagnosticWrappedException wrappedException = new DiagnosticWrappedException(cause, location);
            if (resource != null && resource.getErrors().isEmpty()) {
                resource.getErrors().add(exception instanceof Resource.Diagnostic ? (Resource.Diagnostic)exception : wrappedException);
            }
            throw wrappedException;
        }

        protected void install() {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        @Override
        public void loadGeneratedPackages() {
            for (ProjectManager.IPackageLoadStatus iPackageLoadStatus : this.nsURI2packageLoadStatus.values()) {
                iPackageLoadStatus.loadEPackage();
            }
        }

        @Override
        public synchronized @Nullable Resource loadDynamicResource(@NonNull URI nsURI) {
            if (this.recursiveLoadInProgress) {
                logger.error((Object)("Attempt to load self-referential '" + nsURI + "' as model replaced by registered EPackage"));
                return this.eModel;
            }
            return this.getResource();
        }

        private void loadedDynamicResource(@NonNull ResourceSet resourceSet, @NonNull EPackage ePackage) {
            ProjectManager.IPackageLoadStatus packageLoadStatus;
            URI uri;
            ProjectManager projectMap;
            ProjectManager.IPackageDescriptor packageDescriptor;
            String nsURI = ePackage.getNsURI();
            if (nsURI != null && (packageDescriptor = (projectMap = this.resourceDescriptor.getProjectDescriptor().getProjectManager()).getPackageDescriptor(uri = URI.createURI((String)nsURI))) != null && (packageLoadStatus = this.getPackageLoadStatus(packageDescriptor)) != null) {
                packageLoadStatus.setModel(ePackage);
                if (PROJECT_MAP_RESOLVE.isActive()) {
                    PROJECT_MAP_RESOLVE.println(String.valueOf(nsURI) + " => " + ePackage.eResource().getURI() + " : " + NameUtil.debugSimpleName(ePackage));
                }
            }
            for (EPackage eSubPackage : ePackage.getESubpackages()) {
                if (eSubPackage == null) continue;
                this.loadedDynamicResource(resourceSet, eSubPackage);
            }
        }

        private void loadedDynamicResource(@NonNull Resource newResource) {
            ResourceSet resourceSet = newResource.getResourceSet();
            if (resourceSet != null) {
                for (EObject eObject : newResource.getContents()) {
                    if (!(eObject instanceof EPackage)) continue;
                    EPackage ePackage = (EPackage)eObject;
                    this.loadedDynamicResource(resourceSet, ePackage);
                }
            }
            this.resourceLoadStrategy.loadedDynamicResource(this, newResource);
        }

        public void notifyChanged(Notification notification) {
            int eventType;
            int id;
            if (notification.getNotifier() == this.target && (id = notification.getFeatureID(Resource.class)) == 4 && (eventType = notification.getEventType()) == 1) {
                boolean wasLoaded = notification.getOldBooleanValue();
                boolean isLoaded = notification.getNewBooleanValue();
                if (isLoaded && !wasLoaded) {
                    if (this.target instanceof Resource) {
                        this.loadedDynamicResource((Resource)this.target);
                    }
                } else if (!isLoaded && wasLoaded) {
                    this.resourceLoadStrategy.unloadedResource(this);
                }
            }
        }

        @Override
        public void setConflictHandler(@Nullable ProjectManager.IConflictHandler conflictHandler) {
            this.conflictHandler = conflictHandler;
        }

        @Override
        public void setGenerationInProgress(boolean isGenerating) {
            assert (!this.recursiveLoadInProgress);
            this.generativeLoadInProgress = isGenerating;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void setResource(@NonNull Resource resource) {
            assert (this.eModel == null);
            this.eModel = resource;
            @NonNull @NonNull Map tracedURI2traces2 = tracedURI2traces;
            if (tracedURI2traces2 != null) {
                StandaloneProjectMap projectMap = (StandaloneProjectMap)this.getResourceDescriptor().getProjectDescriptor().getProjectManager();
                for (URI uri : this.nsURI2packageLoadStatus.keySet()) {
                    String nsURI = uri.toString();
                    Integer mask = (Integer)tracedURI2traces2.get(nsURI);
                    if (mask == null) continue;
                    System.out.println(String.valueOf(projectMap.getClass().getSimpleName()) + "-" + projectMap.instanceCount + ": setResource '" + nsURI + "' => '" + resource.getURI() + "'");
                }
            }
            if (!resource.isLoaded() && !this.generativeLoadInProgress) {
                try {
                    InputStream inputStream = resource.getResourceSet().getURIConverter().createInputStream(resource.getURI());
                    EList eAdapters = resource.eAdapters();
                    if (!eAdapters.contains(this)) {
                        eAdapters.add(this);
                    }
                    resource.load(inputStream, null);
                }
                catch (Exception exception) {
                    this.handleLoadException(resource, ClassUtil.nonNullEMF(resource.getURI().toString()), exception);
                }
            }
        }

        @Override
        public void setResourceLoadStrategy(@NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy) {
            this.resourceLoadStrategy = resourceLoadStrategy;
            if (PROJECT_MAP_CONFIGURE.isActive()) {
                PROJECT_MAP_CONFIGURE.println(this.toString());
            }
        }

        public void setTarget(Notifier newTarget) {
            this.target = newTarget;
        }

        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.resourceLoadStrategy + " for " + this.resourceDescriptor.getGenModelURI());
            if (this.packageRegistry == EPackage.Registry.INSTANCE) {
                s.append(" in global ");
            } else {
                s.append(" in ");
            }
            s.append(NameUtil.debugSimpleName(this.packageRegistry));
            return s.toString();
        }

        @Override
        public void unloadedResource() {
            for (ProjectManager.IPackageLoadStatus iPackageLoadStatus : this.nsURI2packageLoadStatus.values()) {
                iPackageLoadStatus.unloadedResource();
            }
        }
    }

    protected static abstract class AbstractResourceLoadStrategy
    implements ProjectManager.IResourceLoadStrategy {
        protected AbstractResourceLoadStrategy() {
        }

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable EPackage basicGetEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return null;
        }

        @Override
        public void configure(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            resourceLoadStatus.setConflictHandler(conflictHandler);
            resourceLoadStatus.setResourceLoadStrategy(this);
        }

        @Override
        public void handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            throw new UnsupportedOperationException();
        }

        protected @Nullable EPackage loadEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, boolean configureURImap) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            resourceLoadStatus.loadGeneratedPackages();
            EPackage ePackage = packageLoadStatus.getEPackage();
            if (ePackage == null) {
                ePackage = packageLoadStatus.getEPackageInstance();
            }
            if (configureURImap) {
                resourceLoadStatus.configureDelegatingResource();
            }
            return this.returnEPackage(packageLoadStatus, ePackage);
        }

        protected @Nullable EPackage loadModel(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            packageLoadStatus.getResourceLoadStatus().loadDynamicResource(packageLoadStatus.getPackageDescriptor().getNsURI());
            EPackage ePackage = packageLoadStatus.getModel();
            if (ePackage == null) {
                ePackage = packageLoadStatus.getEPackageInstance();
            }
            return this.returnEPackage(packageLoadStatus, ePackage);
        }

        @Override
        public void loadedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus, @NonNull Resource resource) {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        protected @Nullable EPackage returnEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @Nullable EPackage ePackage) {
            if (ePackage != null && PROJECT_MAP_RESOLVE.isActive()) {
                URI uri = EcoreUtil.getURI((EObject)ePackage);
                PROJECT_MAP_RESOLVE.println("EPackage.Registry[" + packageLoadStatus.getPackageDescriptor().getNsURI() + "] => " + uri);
            }
            return ePackage;
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class CreateStrategy
    extends AbstractResourceLoadStrategy {
        public static final @NonNull ProjectManager.IResourceLoadStrategy INSTANCE = new CreateStrategy();

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            Resource eResource = ePackage.eResource();
            if (eResource != null) {
                resourceLoadStatus.configureResourceSetURIResourceMap(eResource);
            }
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        public void handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            resourceLoadStatus.getConflictingDynamicResource(ePackage);
        }

        @Override
        public @Nullable EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.loadEPackage(packageLoadStatus, false);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }
    }

    public static class DelegatedMultiplePackageResource
    extends ResourceImpl {
        protected final @NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus;
        protected final @NonNull Iterable<PackageLoadStatus> packageLoadStatuses;
        private final @NonNull Map<@NonNull String, @NonNull EPackage> fragment2ePackage = new HashMap<String, EPackage>();

        public DelegatedMultiplePackageResource(@NonNull URI uri, @NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Iterable<PackageLoadStatus> packageLoadStatuses) {
            super(uri);
            this.resourceLoadStatus = resourceLoadStatus;
            this.packageLoadStatuses = packageLoadStatuses;
            for (ProjectManager.IPackageLoadStatus iPackageLoadStatus : packageLoadStatuses) {
                EPackage ePackage = iPackageLoadStatus.loadEPackage();
                if (ePackage == null) continue;
                StringBuilder s = new StringBuilder();
                this.computeFragment(s, ePackage);
                this.fragment2ePackage.put(s.toString(), ePackage);
            }
            this.setLoaded(true);
        }

        public EObject getEObject(String uriFragment) {
            if (uriFragment == null) {
                return null;
            }
            EPackage ePackage = this.fragment2ePackage.get(uriFragment);
            EPackage eObject = ePackage;
            if (eObject == null) {
                for (String uri : this.fragment2ePackage.keySet()) {
                    if (!uriFragment.startsWith(uri)) continue;
                    ePackage = this.fragment2ePackage.get(uri);
                    assert (ePackage != null);
                    Resource resource = ePackage.eResource();
                    eObject = resource.getEObject(uriFragment);
                    if (eObject != null) break;
                }
            }
            if (ePackage != null) {
                ProjectManager.IResourceLoadStrategy resourceLoadStrategy = this.resourceLoadStatus.getResourceLoadStrategy();
                resourceLoadStrategy.handleConflictingDynamicResource(this.resourceLoadStatus, ePackage);
                return eObject;
            }
            return null;
        }

        private void computeFragment(@NonNull StringBuilder s, @NonNull EPackage ePackage) {
            EPackage eSuperPackage = ePackage.getESuperPackage();
            if (eSuperPackage == null) {
                s.append("/");
            } else {
                this.computeFragment(s, eSuperPackage);
                s.append("/");
                s.append(ePackage.getName());
            }
        }
    }

    public static class DelegatedSinglePackageResource
    extends ResourceImpl {
        private static @NonNull EList<@NonNull EObject> EMPTY_LIST = new BasicEList.UnmodifiableEList(0, new Object[0]);
        protected final @NonNull ProjectManager.IPackageLoadStatus packageLoadStatus;
        private final @Nullable EPackage ePackage;
        private final @Nullable Resource eResource;

        public DelegatedSinglePackageResource(@NonNull URI uri, @NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            super(uri);
            this.packageLoadStatus = packageLoadStatus;
            this.ePackage = packageLoadStatus.loadEPackage();
            this.eResource = this.ePackage != null ? this.ePackage.eResource() : null;
            this.setLoaded(true);
        }

        public @NonNull EList<@NonNull EObject> getContents() {
            return this.eResource != null ? this.eResource.getContents() : EMPTY_LIST;
        }

        public EObject getEObject(String uriFragment) {
            if (uriFragment == null) {
                return null;
            }
            EPackage ePackage2 = this.ePackage;
            if (ePackage2 == null) {
                return null;
            }
            Resource resource = ePackage2.eResource();
            EObject eObject = resource.getEObject(uriFragment);
            if (eObject != null) {
                ProjectManager.IResourceLoadStatus resourceLoadStatus = this.packageLoadStatus.getResourceLoadStatus();
                ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
                resourceLoadStrategy.handleConflictingDynamicResource(resourceLoadStatus, ePackage2);
            }
            return eObject;
        }

        public @NonNull Resource getResource() {
            return this.eResource != null ? this.eResource : this;
        }
    }

    protected static class EPackageDescriptor
    implements EPackage.Descriptor {
        private static int instanceCounter = 0;
        private int instanceCount = ++instanceCounter;
        protected final @NonNull ProjectManager.IPackageLoadStatus packageLoadStatus;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected EPackageDescriptor(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull EPackage.Registry packageRegistry) {
            Integer mask;
            this.packageLoadStatus = packageLoadStatus;
            URI uri = this.getURI();
            @NonNull @NonNull Map tracedURI2traces2 = tracedURI2traces;
            if (tracedURI2traces2 != null && (mask = (Integer)tracedURI2traces2.get(uri.toString())) != null) {
                StandaloneProjectMap projectMap = (StandaloneProjectMap)packageLoadStatus.getPackageDescriptor().getResourceDescriptor().getProjectDescriptor().getProjectManager();
                System.out.println(String.valueOf(projectMap.getClass().getSimpleName()) + "-" + projectMap.instanceCount + ": install EPackageDescriptor-" + this.instanceCount + " for '" + uri + "'");
            }
            packageRegistry.put((Object)uri.toString(), (Object)this);
            if (PROJECT_MAP_INSTALL.isActive()) {
                PROJECT_MAP_INSTALL.println(this.toString());
            }
        }

        public @Nullable EPackage basicGetEPackage() {
            URI uri = this.getURI();
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.packageLoadStatus.getResourceLoadStatus();
            ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
            if (PROJECT_MAP_GET.isActive()) {
                PROJECT_MAP_GET.println("BasicGet " + uri + " with " + resourceLoadStrategy + " in " + NameUtil.debugSimpleName(resourceLoadStatus.getPackageRegistry()));
            }
            return resourceLoadStrategy.basicGetEPackage(this.packageLoadStatus);
        }

        public EFactory getEFactory() {
            EPackage ePackage = this.basicGetEPackage();
            if (ePackage != null) {
                return ePackage.getEFactoryInstance();
            }
            return null;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable EPackage getEPackage() {
            Integer mask;
            URI uri = this.getURI();
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.packageLoadStatus.getResourceLoadStatus();
            ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
            if (PROJECT_MAP_GET.isActive()) {
                PROJECT_MAP_GET.println("Get " + uri + " with " + resourceLoadStrategy + " in " + NameUtil.debugSimpleName(resourceLoadStatus.getPackageRegistry()));
            }
            EPackage ePackage = resourceLoadStrategy.getEPackage(this.packageLoadStatus);
            @NonNull @NonNull Map tracedURI2traces2 = tracedURI2traces;
            if (tracedURI2traces2 != null && (mask = (Integer)tracedURI2traces2.get(uri.toString())) != null) {
                StandaloneProjectMap projectMap = (StandaloneProjectMap)this.packageLoadStatus.getPackageDescriptor().getResourceDescriptor().getProjectDescriptor().getProjectManager();
                System.out.println(String.valueOf(projectMap.getClass().getSimpleName()) + "-" + projectMap.instanceCount + ": getEPackage from EPackageDescriptor-" + this.instanceCount + " for '" + uri + "' => " + NameUtil.debugFullName(ePackage));
            }
            return ePackage;
        }

        public @NonNull URI getURI() {
            return this.packageLoadStatus.getPackageDescriptor().getNsURI();
        }

        public @NonNull String toString() {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.packageLoadStatus.getResourceLoadStatus();
            ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
            return this.getURI() + " with " + resourceLoadStrategy;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void uninstall(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull EPackage.Registry packageRegistry) {
            Integer mask;
            URI uri = this.getURI();
            @NonNull @NonNull Map tracedURI2traces2 = tracedURI2traces;
            if (tracedURI2traces2 != null && (mask = (Integer)tracedURI2traces2.get(uri.toString())) != null) {
                StandaloneProjectMap projectMap = (StandaloneProjectMap)this.packageLoadStatus.getPackageDescriptor().getResourceDescriptor().getProjectDescriptor().getProjectManager();
                System.out.println(String.valueOf(projectMap.getClass().getSimpleName()) + "-" + projectMap.instanceCount + ": uninstall EPackageDescriptor-" + this.instanceCount + " for '" + uri + "'");
            }
            if (PROJECT_MAP_INSTALL.isActive()) {
                PROJECT_MAP_INSTALL.println(this.toString());
            }
            packageRegistry.put((Object)uri.toString(), null);
        }
    }

    protected static class GenModelReader
    extends DefaultHandler {
        public static final @NonNull String genmodelTag = "genmodel:GenModel";
        public static final @NonNull String genPackagesTag = "genPackages";
        public static final @NonNull String nestedGenPackagesTag = "nestedGenPackages";
        public static final @NonNull String ecorePackageTag = "ecorePackage";
        public static final @NonNull String ecorePackageAttribute = "ecorePackage";
        public static final @NonNull String hrefAttribute = "href";
        protected final @NonNull ProjectManager.IResourceDescriptor resourceDescriptor;
        protected final @NonNull ProjectManager.IProjectDescriptor projectDescriptor;
        protected final @NonNull Map<@NonNull String, @NonNull ProjectManager.IPackageDescriptor> nsURI2packageDescriptor = new HashMap<String, ProjectManager.IPackageDescriptor>();
        protected final @NonNull URI genModelURI;
        protected final @NonNull List<@NonNull String> ecorePackages = new ArrayList<String>();
        private @NonNull Stack<String> elements = new Stack();

        public static void initStatics() {
        }

        public GenModelReader(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor) {
            this.resourceDescriptor = resourceDescriptor;
            this.projectDescriptor = resourceDescriptor.getProjectDescriptor();
            this.genModelURI = resourceDescriptor.getGenModelURI();
            for (ProjectManager.IPackageDescriptor iPackageDescriptor : resourceDescriptor.getPackageDescriptors()) {
                this.add(iPackageDescriptor);
            }
        }

        private void add(@NonNull ProjectManager.IPackageDescriptor packageDescriptor) {
            this.nsURI2packageDescriptor.put(String.valueOf(packageDescriptor.getNsURI()), packageDescriptor);
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            try {
                this.resourceDescriptor.setEcoreModel(this.ecorePackages, this.nsURI2packageDescriptor);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read " + this.genModelURI), (Throwable)e);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.elements.pop();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String ecorePackage;
            String topElement;
            int size = this.elements.size();
            if (genPackagesTag.equals(qName)) {
                String ecorePackage2;
                if (size == 1 && genmodelTag.equals(this.elements.elementAt(0)) && (ecorePackage2 = attributes.getValue("ecorePackage")) != null) {
                    this.ecorePackages.add(ecorePackage2);
                }
            } else if (nestedGenPackagesTag.equals(qName)) {
                String ecorePackage3;
                if (size > 1 && genPackagesTag.equals(this.elements.elementAt(1)) && genmodelTag.equals(this.elements.elementAt(0)) && (ecorePackage3 = attributes.getValue("ecorePackage")) != null) {
                    this.ecorePackages.add(ecorePackage3);
                }
            } else if ("ecorePackage".equals(qName) && size >= 2 && genPackagesTag.equals(this.elements.elementAt(1)) && genmodelTag.equals(this.elements.elementAt(0)) && (genPackagesTag.equals(topElement = (String)this.elements.elementAt(size - 1)) || nestedGenPackagesTag.equals(topElement)) && (ecorePackage = attributes.getValue(hrefAttribute)) != null) {
                this.ecorePackages.add(ecorePackage);
            }
            this.elements.push(qName);
        }
    }

    public static final class LoadBothStrategy
    extends AbstractResourceLoadStrategy {
        public static final @NonNull ProjectManager.IResourceLoadStrategy INSTANCE = new LoadBothStrategy();

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.setResource(resource);
            resourceLoadStatus.configureResourceSetURIResourceMap(resource);
            resourceLoadStatus.setResourceLoadStrategy(LoadingBothLoadedDynamicResourceStrategy.INSTANCE);
        }

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            Resource eResource = ePackage.eResource();
            if (eResource != null) {
                resourceLoadStatus.configureResourceSetURIResourceMap(eResource);
            }
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        public @Nullable EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.loadEPackage(packageLoadStatus, false);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
            packageLoadStatus.unloadedResource();
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }
    }

    public static final class LoadDynamicResourceStrategy
    extends AbstractResourceLoadStrategy {
        public static final @NonNull ProjectManager.IResourceLoadStrategy INSTANCE = new LoadDynamicResourceStrategy();

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.setResource(resource);
            resourceLoadStatus.configureResourceSetURIResourceMap(resource);
            resourceLoadStatus.configureEPackageRegistry(resource);
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        public @Nullable EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.loadModel(packageLoadStatus);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }
    }

    public static final class LoadFirstStrategy
    extends AbstractResourceLoadStrategy {
        public static final @NonNull ProjectManager.IResourceLoadStrategy INSTANCE = new LoadFirstStrategy();

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.configureResourceSetURIResourceMap(resource);
            resourceLoadStatus.setResourceLoadStrategy(LoadedFirstAsDynamicResourceStrategy.INSTANCE);
            resourceLoadStatus.setResource(resource);
        }

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            Resource eResource = ePackage.eResource();
            if (eResource != null) {
                resourceLoadStatus.configureResourceSetURIResourceMap(eResource);
            }
            resourceLoadStatus.setResourceLoadStrategy(LoadedAsGeneratedPackageStrategy.INSTANCE);
        }

        @Override
        public @Nullable EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            EPackage loadEPackage = this.loadEPackage(packageLoadStatus, true);
            packageLoadStatus.getResourceLoadStatus().setResourceLoadStrategy(LoadedAsGeneratedPackageStrategy.INSTANCE);
            return loadEPackage;
        }

        @Override
        public void handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            resourceLoadStatus.getConflictingDynamicResource(ePackage);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.configureResourceSetURIResourceMap(resource);
            resourceLoadStatus.setResourceLoadStrategy(LoadedAsGeneratedPackageStrategy.INSTANCE);
        }
    }

    public static final class LoadGeneratedPackageStrategy
    extends AbstractResourceLoadStrategy {
        public static final @NonNull ProjectManager.IResourceLoadStrategy INSTANCE = new LoadGeneratedPackageStrategy();

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            Resource eResource = ePackage.eResource();
            if (eResource != null) {
                resourceLoadStatus.configureResourceSetURIResourceMap(eResource);
            }
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        public void configure(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            super.configure(resourceLoadStatus, conflictHandler);
            resourceLoadStatus.configureDelegatingResource();
        }

        @Override
        public void handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            resourceLoadStatus.getConflictingDynamicResource(ePackage);
        }

        @Override
        public @Nullable EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.loadEPackage(packageLoadStatus, false);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }
    }

    private static final class LoadedAsGeneratedPackageStrategy
    extends AbstractResourceLoadStrategy {
        public static final @NonNull ProjectManager.IResourceLoadStrategy INSTANCE = new LoadedAsGeneratedPackageStrategy();

        private LoadedAsGeneratedPackageStrategy() {
        }

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }

        @Override
        public @Nullable EPackage basicGetEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.getEPackage(packageLoadStatus);
        }

        @Override
        public @Nullable EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            EPackage ePackage = packageLoadStatus.getFirstEPackage();
            return this.returnEPackage(packageLoadStatus, ePackage);
        }

        @Override
        public void handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            resourceLoadStatus.getConflictingDynamicResource(ePackage);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }
    }

    private static final class LoadedFirstAsDynamicResourceStrategy
    extends AbstractResourceLoadStrategy {
        public static final @NonNull ProjectManager.IResourceLoadStrategy INSTANCE = new LoadedFirstAsDynamicResourceStrategy();

        private LoadedFirstAsDynamicResourceStrategy() {
        }

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }

        @Override
        public @Nullable EPackage basicGetEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.getEPackage(packageLoadStatus);
        }

        @Override
        public @Nullable EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            EPackage ePackage = packageLoadStatus.getConflictingGeneratedPackage();
            return this.returnEPackage(packageLoadStatus, ePackage);
        }

        @Override
        public void loadedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
            packageLoadStatus.unloadedResource();
            packageLoadStatus.setResourceLoadStrategy(LoadFirstStrategy.INSTANCE);
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }
    }

    private static final class LoadedStrategy
    extends AbstractResourceLoadStrategy {
        public static final @NonNull ProjectManager.IResourceLoadStrategy INSTANCE = new LoadedStrategy();

        private LoadedStrategy() {
        }

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.setResource(resource);
            resourceLoadStatus.setResourceLoadStrategy(INSTANCE);
        }

        @Override
        public @Nullable EPackage basicGetEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.getEPackage(packageLoadStatus);
        }

        @Override
        public @Nullable EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return packageLoadStatus.getFirstEPackage();
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }
    }

    public static final class LoadingBothLoadedDynamicResourceStrategy
    extends AbstractResourceLoadStrategy {
        public static final @NonNull ProjectManager.IResourceLoadStrategy INSTANCE = new LoadingBothLoadedDynamicResourceStrategy();

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            Resource eResource = ePackage.eResource();
            if (eResource != null) {
                resourceLoadStatus.configureResourceSetURIResourceMap(eResource);
            }
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        public @Nullable EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.loadEPackage(packageLoadStatus, false);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
            packageLoadStatus.unloadedResource();
        }
    }

    public static class MapToFirstConflictHandler
    implements ProjectManager.IConflictHandler {
        public static final @NonNull ProjectManager.IConflictHandler INSTANCE = new MapToFirstConflictHandler();

        @Override
        public @Nullable EPackage handleConflictingGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull Resource resource) {
            return packageLoadStatus.getFirstEPackage();
        }

        @Override
        public @Nullable EPackage handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            return ePackage;
        }
    }

    public static class MapToFirstConflictHandlerWithLog
    implements ProjectManager.IConflictHandler {
        public static final @NonNull ProjectManager.IConflictHandler INSTANCE = new MapToFirstConflictHandlerWithLog();

        @Override
        public @Nullable EPackage handleConflictingGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull Resource resource) {
            EPackage firstEPackage = packageLoadStatus.getFirstEPackage();
            ProjectManager.IPackageDescriptor packageDescriptor = packageLoadStatus.getPackageDescriptor();
            logger.error((Object)("Conflicting access to '" + packageDescriptor.getNsURI() + "' already accessed as '" + resource.getURI() + "'"));
            packageLoadStatus.getResourceLoadStatus().setConflictHandler(MapToFirstConflictHandler.INSTANCE);
            return firstEPackage;
        }

        @Override
        public @Nullable EPackage handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceDescriptor resourceDescriptor = resourceLoadStatus.getResourceDescriptor();
            logger.error((Object)("Conflicting access to '" + resourceDescriptor.getPlatformResourceURI() + "' or '" + resourceDescriptor.getPlatformPluginURI() + "' already accessed as '" + ePackage.getNsURI() + "'"));
            resourceLoadStatus.setConflictHandler(MapToFirstConflictHandler.INSTANCE);
            return ePackage;
        }
    }

    public static final class MultiplePackageResourceDescriptor
    extends AbstractResourceDescriptor {
        public MultiplePackageResourceDescriptor(@NonNull ProjectDescriptor projectDescriptor, @NonNull URI genModelURI, @NonNull Map<@NonNull URI, @NonNull String> nsURI2className) {
            super(projectDescriptor, genModelURI, nsURI2className);
        }

        @Override
        protected @NonNull ProjectManager.IResourceLoadStatus createResourceLoadStatus(@Nullable ResourceSet resourceSet) {
            return new MultiplePackageResourceLoadStatus(this, resourceSet);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("{");
            boolean isFirst = true;
            for (ProjectManager.IPackageDescriptor packageDescriptor : this.packageDescriptors) {
                if (!isFirst) {
                    s.append(",");
                }
                s.append(packageDescriptor.getNsURI());
                isFirst = false;
            }
            s.append("} => ");
            s.append(this.genModelURI);
            return s.toString();
        }
    }

    public static class MultiplePackageResourceLoadStatus
    extends AbstractResourceLoadStatus {
        public MultiplePackageResourceLoadStatus(@NonNull MultiplePackageResourceDescriptor resourceDescriptor, @Nullable ResourceSet resourceSet) {
            super(resourceDescriptor, resourceSet);
            this.install();
        }
    }

    public static final class PackageDescriptor
    implements ProjectManager.IPackageDescriptor {
        protected final @NonNull ProjectManager.IResourceDescriptor resourceDescriptor;
        protected final @NonNull URI namespaceURI;
        protected final @Nullable String className;

        public PackageDescriptor(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor, @NonNull URI nsURI, @Nullable String className) {
            this.resourceDescriptor = resourceDescriptor;
            this.namespaceURI = nsURI;
            this.className = className;
        }

        @Override
        public void configure(@Nullable ResourceSet resourceSet, @NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            this.resourceDescriptor.configure(resourceSet, resourceLoadStrategy, conflictHandler);
        }

        @Override
        public @Nullable String getClassName() {
            return this.className;
        }

        public @Nullable EFactory getEFactory() {
            return null;
        }

        @Override
        public @NonNull URI getNsURI() {
            return this.namespaceURI;
        }

        public @NonNull List<? extends ProjectManager.IPackageDescriptor> getPackageDescriptors() {
            return Collections.singletonList(this);
        }

        @Override
        public @NonNull ProjectManager.IResourceDescriptor getResourceDescriptor() {
            return this.resourceDescriptor;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.namespaceURI);
            s.append(" => ");
            s.append(this.className);
            return s.toString();
        }
    }

    public static final class PackageLoadStatus
    implements ProjectManager.IPackageLoadStatus {
        protected final @NonNull AbstractResourceLoadStatus resourceLoadStatus;
        protected final @NonNull ProjectManager.IPackageDescriptor packageDescriptor;
        protected final @NonNull EPackageDescriptor namespaceURIDescriptor;
        private @Nullable EPackage firstEPackage;
        private @Nullable EPackage ePackage = null;
        private @Nullable EPackage eModel = null;

        public PackageLoadStatus(@NonNull AbstractResourceLoadStatus resourceLoadStatus, @NonNull ProjectManager.IPackageDescriptor packageDescriptor) {
            this.resourceLoadStatus = resourceLoadStatus;
            this.packageDescriptor = packageDescriptor;
            this.namespaceURIDescriptor = new EPackageDescriptor(this, resourceLoadStatus.getPackageRegistry());
        }

        @Override
        public void configureEPackageRegistry(@NonNull ResourceSet resourceSet) {
            URI nsURI = this.packageDescriptor.getNsURI();
            ProjectManager.IPackageLoadStatus packageLoadStatus = this.resourceLoadStatus.getPackageLoadStatus(this.packageDescriptor);
            if (packageLoadStatus != null) {
                EPackage modelEPackage = packageLoadStatus.getModel();
                resourceSet.getPackageRegistry().put((Object)nsURI.toString(), (Object)modelEPackage);
                if (PROJECT_MAP_RESOLVE.isActive()) {
                    PROJECT_MAP_RESOLVE.println("EPackage.Registry[" + nsURI + "] => " + EcoreUtil.getURI((EObject)modelEPackage));
                }
            }
        }

        @Override
        public void dispose() {
            this.namespaceURIDescriptor.uninstall(this.resourceLoadStatus.getPackageRegistry());
            this.firstEPackage = null;
            this.ePackage = null;
            this.eModel = null;
        }

        @Override
        public @Nullable EPackage getConflictingGeneratedPackage() {
            return this.resourceLoadStatus.handleConflictingGeneratedPackage(this);
        }

        @Override
        public @Nullable EPackage getEPackage() {
            if (this.ePackage == null) {
                this.ePackage = this.getEPackageInstance();
            }
            return this.ePackage;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @Nullable EPackage getEPackageInstance() {
            String className = this.packageDescriptor.getClassName();
            if (className != null) {
                try {
                    Class<?> javaClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                    Field field = javaClass.getField("eINSTANCE");
                    return (EPackage)field.get(null);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                catch (IllegalAccessException e) {
                    throw new WrappedException((Exception)e);
                }
                catch (NoSuchFieldException e) {
                    throw new WrappedException((Exception)e);
                }
            }
            Object object = EPackage.Registry.INSTANCE.get((Object)this.packageDescriptor.getNsURI().toString());
            EPackage ePackage = null;
            if (object instanceof EPackage) {
                ePackage = (EPackage)object;
            } else if (object instanceof EPackage.Descriptor) {
                try {
                    ePackage = ((EPackage.Descriptor)object).getEPackage();
                }
                catch (WrappedException e) {
                    return null;
                }
            }
            if (ePackage != null) {
                Integer mask;
                String nsURI = ePackage.getNsURI();
                @NonNull @NonNull Map tracedURI2traces2 = tracedURI2traces;
                if (tracedURI2traces2 != null && (mask = (Integer)tracedURI2traces2.get(nsURI)) != null) {
                    StandaloneProjectMap projectMap = (StandaloneProjectMap)this.getPackageDescriptor().getResourceDescriptor().getProjectDescriptor().getProjectManager();
                    System.out.println(String.valueOf(projectMap.getClass().getSimpleName()) + "-" + projectMap.instanceCount + ": getEPackageInstance for " + nsURI);
                }
                return ePackage;
            }
            return null;
        }

        @Override
        public @Nullable EPackage getFirstEPackage() {
            if (this.firstEPackage != null) {
                return this.firstEPackage;
            }
            return this.getEPackageInstance();
        }

        @Override
        public @Nullable EPackage getModel() {
            return this.eModel;
        }

        @Override
        public @NonNull ProjectManager.IPackageDescriptor getPackageDescriptor() {
            return this.packageDescriptor;
        }

        public @NonNull ProjectManager.IResourceLoadStrategy getResourceLoadStrategy() {
            return this.resourceLoadStatus.getResourceLoadStrategy();
        }

        @Override
        public @NonNull ProjectManager.IResourceLoadStatus getResourceLoadStatus() {
            return this.resourceLoadStatus;
        }

        @Override
        public @Nullable EPackage loadEPackage() {
            if (this.ePackage == null) {
                this.ePackage = this.getEPackageInstance();
            }
            if (this.firstEPackage == null) {
                this.firstEPackage = this.ePackage;
            }
            return this.ePackage;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void setEPackage(@NonNull EPackage ePackage) {
            Integer mask;
            assert (this.ePackage == null);
            String nsURI = ePackage.getNsURI();
            @NonNull @NonNull Map tracedURI2traces2 = tracedURI2traces;
            if (tracedURI2traces2 != null && (mask = (Integer)tracedURI2traces2.get(nsURI)) != null) {
                StandaloneProjectMap projectMap = (StandaloneProjectMap)this.getPackageDescriptor().getResourceDescriptor().getProjectDescriptor().getProjectManager();
                System.out.println(String.valueOf(projectMap.getClass().getSimpleName()) + "-" + projectMap.instanceCount + ": setEPackage for " + nsURI);
            }
            if (this.firstEPackage == null) {
                this.firstEPackage = ePackage;
            }
            this.ePackage = ePackage;
        }

        @Override
        public void setModel(@NonNull EPackage ePackage) {
            assert (this.eModel == null);
            if (this.firstEPackage == null) {
                this.firstEPackage = ePackage;
            }
            this.eModel = ePackage;
        }

        public String toString() {
            return this.packageDescriptor.toString();
        }

        @Override
        public void unloadedResource() {
            this.eModel = null;
        }
    }

    protected static class PluginReader
    extends DefaultHandler {
        public static final @NonNull String pluginTag = "plugin";
        public static final @NonNull String extensionTag = "extension";
        public static final @NonNull String pointTag = "point";
        public static final @NonNull String packageTag = "package";
        public static final @NonNull String extensionPointAttribute = "org.eclipse.emf.ecore.generated_package";
        public static final @NonNull String uriAttribute = "uri";
        public static final @NonNull String classAttribute = "class";
        public static final @NonNull String genModelAttribute = "genModel";
        protected final JarFile jarFile;
        protected final ProjectManager.IProjectDescriptor projectDescriptor;
        private int pluginCount = 0;
        private int extensionCount = 0;
        private boolean inPoint = false;
        private int packageCount = 0;
        private @NonNull Map<@NonNull String, @NonNull GenModelReader> genModelReaders = new HashMap<String, GenModelReader>();
        private @Nullable Map<@NonNull String, @NonNull Map<@NonNull URI, @NonNull String>> genModelURI2nsURI2className = null;

        private PluginReader(@Nullable ProjectManager.IProjectDescriptor projectDescriptor) {
            this.jarFile = null;
            this.projectDescriptor = projectDescriptor;
        }

        public PluginReader(@NonNull JarFile jarFile, @NonNull ProjectManager.IProjectDescriptor projectDescriptor) {
            this.jarFile = jarFile;
            this.projectDescriptor = projectDescriptor;
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            Map<@NonNull String, @NonNull Map<@NonNull URI, @NonNull String>> genModelURI2nsURI2className2 = this.genModelURI2nsURI2className;
            if (genModelURI2nsURI2className2 != null) {
                for (String genModel : genModelURI2nsURI2className2.keySet()) {
                    Map<@NonNull URI, @NonNull String> nsURI2className = genModelURI2nsURI2className2.get(genModel);
                    assert (nsURI2className != null);
                    ProjectManager.IResourceDescriptor resourceDescriptor = this.projectDescriptor.createResourceDescriptor(genModel, nsURI2className);
                    GenModelReader genModelReader = new GenModelReader(resourceDescriptor);
                    this.genModelReaders.put(genModel, genModelReader);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.pluginCount == 1) {
                if (pluginTag.equals(qName)) {
                    --this.pluginCount;
                }
                if (this.extensionCount == 1) {
                    if (extensionTag.equals(qName)) {
                        --this.extensionCount;
                    }
                    if (this.packageCount == 1 && packageTag.equals(qName)) {
                        --this.packageCount;
                    }
                }
            }
        }

        public void scanContents(SAXParser saxParser) {
            for (String genModel : this.genModelReaders.keySet()) {
                GenModelReader genModelReader = this.genModelReaders.get(genModel);
                URI locationURI = this.projectDescriptor.getLocationURI();
                URI genModelURI = URI.createURI((String)genModel).resolve(locationURI);
                InputStream inputStream = null;
                try {
                    try {
                        if (this.jarFile != null) {
                            ZipEntry entry = this.jarFile.getEntry(genModel);
                            if (entry != null) {
                                inputStream = this.jarFile.getInputStream(entry);
                            }
                        } else {
                            inputStream = new FileInputStream(genModelURI.isFile() ? genModelURI.toFileString() : genModelURI.toString());
                        }
                        if (inputStream != null) {
                            saxParser.parse(inputStream, (DefaultHandler)genModelReader);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to scanContents of '" + locationURI + "' in " + this.getClass().getName() + "\n  " + e);
                        try {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.pluginCount == 0) {
                if (pluginTag.equals(qName)) {
                    ++this.pluginCount;
                }
            } else if (this.pluginCount == 1) {
                if (this.extensionCount == 0 && extensionTag.equals(qName)) {
                    ++this.extensionCount;
                    this.inPoint = extensionPointAttribute.equals(attributes.getValue(pointTag));
                } else if (this.extensionCount == 1 && this.inPoint && this.packageCount == 0 && packageTag.equals(qName)) {
                    ++this.packageCount;
                    String className = attributes.getValue(classAttribute);
                    @NonNull URI nsURI = URI.createURI((String)attributes.getValue(uriAttribute));
                    String genModel = attributes.getValue(genModelAttribute);
                    if (genModel != null && className != null) {
                        Map<URI, String> nsURI2className;
                        Map<@NonNull String, @NonNull Map<@NonNull URI, @NonNull String>> genModelURI2nsURI2className2 = this.genModelURI2nsURI2className;
                        if (genModelURI2nsURI2className2 == null) {
                            this.genModelURI2nsURI2className = genModelURI2nsURI2className2 = new HashMap<String, Map<URI, String>>();
                        }
                        if ((nsURI2className = genModelURI2nsURI2className2.get(genModel)) == null) {
                            nsURI2className = new HashMap<URI, String>();
                            genModelURI2nsURI2className2.put(genModel, nsURI2className);
                        }
                        nsURI2className.put(nsURI, className);
                    }
                }
            }
        }
    }

    public static class ProjectDescriptor
    implements ProjectManager.IProjectDescriptor.IProjectDescriptorExtension {
        protected final @NonNull StandaloneProjectMap projectMap;
        protected final @NonNull String name;
        protected final @NonNull URI locationURI;
        private @Nullable Map<@NonNull URI, @NonNull ProjectManager.IPackageDescriptor> nsURI2packageDescriptor = null;
        private @Nullable Map<@NonNull URI, @NonNull ProjectManager.IResourceDescriptor> genModelURI2resourceDescriptor = null;

        public ProjectDescriptor(@NonNull StandaloneProjectMap projectMap, @NonNull String name, @NonNull URI locationURI) {
            this.projectMap = projectMap;
            this.name = name;
            this.locationURI = locationURI;
        }

        @Override
        public void addPackageDescriptor(@NonNull ProjectManager.IPackageDescriptor packageDescriptor) {
            Map<@NonNull URI, @NonNull ProjectManager.IPackageDescriptor> nsURI2packageDescriptor2 = this.nsURI2packageDescriptor;
            if (nsURI2packageDescriptor2 == null) {
                this.nsURI2packageDescriptor = nsURI2packageDescriptor2 = new HashMap<URI, ProjectManager.IPackageDescriptor>();
            }
            nsURI2packageDescriptor2.put(packageDescriptor.getNsURI(), packageDescriptor);
        }

        @Override
        public void addResourceDescriptor(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor) {
            Map<@NonNull URI, @NonNull ProjectManager.IResourceDescriptor> genModelURI2resourceDescriptor2 = this.genModelURI2resourceDescriptor;
            if (genModelURI2resourceDescriptor2 == null) {
                this.genModelURI2resourceDescriptor = genModelURI2resourceDescriptor2 = new HashMap<URI, ProjectManager.IResourceDescriptor>();
            }
            genModelURI2resourceDescriptor2.put(resourceDescriptor.getGenModelURI(), resourceDescriptor);
        }

        @Override
        public void configure(@Nullable ResourceSet resourceSet, @NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            if (this.genModelURI2resourceDescriptor != null) {
                for (ProjectManager.IResourceDescriptor resourceDescriptor : this.genModelURI2resourceDescriptor.values()) {
                    try {
                        resourceDescriptor.configure(resourceSet, resourceLoadStrategy, conflictHandler);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
        }

        @Override
        public @NonNull ProjectManager.IResourceDescriptor createResourceDescriptor(@NonNull String genModel, @NonNull Map<@NonNull URI, @NonNull String> nsURI2className) {
            URI absoluteGenModelURI = URI.createURI((String)genModel).resolve(this.locationURI);
            @NonNull URI projectGenModelURI = URIUtil.deresolve(absoluteGenModelURI, this.locationURI, true, true, true);
            if (nsURI2className.size() <= 1) {
                return new SinglePackageResourceDescriptor(this, projectGenModelURI, nsURI2className);
            }
            return new MultiplePackageResourceDescriptor(this, projectGenModelURI, nsURI2className);
        }

        @Override
        public @NonNull URI getLocationURI() {
            return this.locationURI;
        }

        @Override
        public @NonNull URI getLocationURI(@NonNull String projectRelativeFileName) {
            return URI.createURI((String)projectRelativeFileName).resolve(this.locationURI);
        }

        @Override
        public @NonNull File getLocationFile(@NonNull String projectRelativeFileName) {
            return new File(this.getLocationURI(projectRelativeFileName).toFileString());
        }

        @Override
        public @NonNull String getName() {
            return this.name;
        }

        @Override
        public @Nullable ProjectManager.IPackageDescriptor getPackageDescriptor(@NonNull URI nsURI) {
            return this.nsURI2packageDescriptor != null ? this.nsURI2packageDescriptor.get(nsURI) : null;
        }

        protected @NonNull URI getResolvedGenModelURI(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor) {
            URI genModelURI = resourceDescriptor.getGenModelURI();
            return genModelURI.resolve(this.getPlatformResourceURI());
        }

        @Override
        public @Nullable Collection<@NonNull ProjectManager.IResourceDescriptor> getResourceDescriptors() {
            return this.genModelURI2resourceDescriptor != null ? this.genModelURI2resourceDescriptor.values() : null;
        }

        @Override
        public @NonNull URI getPlatformPluginURI() {
            return URI.createPlatformPluginURI((String)("/" + this.name + "/"), (boolean)true);
        }

        @Override
        public @NonNull URI getPlatformPluginURI(@NonNull String projectRelativeFileName) {
            return URI.createURI((String)projectRelativeFileName).resolve(this.getPlatformPluginURI());
        }

        @Override
        public @NonNull URI getPlatformResourceURI() {
            return URI.createPlatformResourceURI((String)("/" + this.name + "/"), (boolean)true);
        }

        @Override
        public @NonNull URI getPlatformResourceURI(@NonNull String projectRelativeFileName) {
            return URI.createURI((String)projectRelativeFileName).resolve(this.getPlatformResourceURI());
        }

        @Override
        public @Nullable Iterable<@NonNull ProjectManager.IPackageDescriptor> getPackageDescriptors() {
            return this.nsURI2packageDescriptor != null ? this.nsURI2packageDescriptor.values() : null;
        }

        @Override
        public @NonNull StandaloneProjectMap getProjectManager() {
            return this.projectMap;
        }

        @Override
        public void initializeGenModelLocationMap(@NonNull Map<@NonNull URI, @NonNull ProjectManager.IPackageDescriptor> nsURI2package) {
            Collection<@NonNull ProjectManager.IResourceDescriptor> resourceDescriptors = this.getResourceDescriptors();
            if (resourceDescriptors != null) {
                Map<String, URI> ePackageNsURIToGenModelLocationMap = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap(false);
                for (ProjectManager.IResourceDescriptor resourceDescriptor : resourceDescriptors) {
                    URI resolvedGenModelURI = this.getResolvedGenModelURI(resourceDescriptor);
                    for (ProjectManager.IPackageDescriptor iPackageDescriptor : resourceDescriptor.getPackageDescriptors()) {
                        URI nsURI = iPackageDescriptor.getNsURI();
                        String nsURIstring = nsURI.toString();
                        ePackageNsURIToGenModelLocationMap.put(nsURIstring, resolvedGenModelURI);
                        nsURI2package.put(nsURI, iPackageDescriptor);
                        if (!PROJECT_MAP_ADD_GEN_MODEL.isActive()) continue;
                        PROJECT_MAP_ADD_GEN_MODEL.println(nsURI + " => " + resolvedGenModelURI);
                    }
                }
            }
        }

        @Override
        public void initializePlatformResourceMap() {
            Map platformResourceMap = EcorePlugin.getPlatformResourceMap();
            platformResourceMap.put(this.name, this.locationURI);
        }

        @Override
        public void initializeURIMap(@NonNull Map<URI, URI> uriMap) {
            URI resourceURI = this.getPlatformResourceURI();
            URI pluginURI = this.getPlatformPluginURI();
            uriMap.put(resourceURI, this.locationURI);
            uriMap.put(pluginURI, this.locationURI);
            if (PROJECT_MAP_ADD_URI_MAP.isActive()) {
                PROJECT_MAP_ADD_URI_MAP.println(resourceURI + " => " + this.locationURI);
                PROJECT_MAP_ADD_URI_MAP.println(pluginURI + " => " + this.locationURI);
            }
        }

        @Override
        public void unload(@NonNull ResourceSet resourceSet) {
            Collection<@NonNull ProjectManager.IResourceDescriptor> resourceDescriptors = this.getResourceDescriptors();
            if (resourceDescriptors != null) {
                for (ProjectManager.IResourceDescriptor resourceDescriptor : resourceDescriptors) {
                    assert (resourceDescriptor != null);
                    resourceDescriptor.unload(resourceSet);
                }
                Map<@NonNull URI, @NonNull ProjectManager.IPackageDescriptor> nsURI2packageDescriptor2 = this.nsURI2packageDescriptor;
                EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                if (nsURI2packageDescriptor2 != null) {
                    for (URI nsURI : nsURI2packageDescriptor2.keySet()) {
                        packageRegistry.remove((Object)nsURI.toString());
                    }
                }
            }
        }

        public String toString() {
            return String.valueOf(this.name) + " => " + this.locationURI.toString();
        }
    }

    public static final class SinglePackageResourceDescriptor
    extends AbstractResourceDescriptor {
        public SinglePackageResourceDescriptor(@NonNull ProjectManager.IProjectDescriptor projectDescriptor, @NonNull URI genModelURI, @NonNull Map<@NonNull URI, @NonNull String> nsURI2className) {
            super(projectDescriptor, genModelURI, nsURI2className);
        }

        @Override
        protected @NonNull ProjectManager.IResourceLoadStatus createResourceLoadStatus(@Nullable ResourceSet resourceSet) {
            return new SinglePackageResourceLoadStatus(this, resourceSet);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.genModelURI);
            return s.toString();
        }
    }

    public static final class SinglePackageResourceLoadStatus
    extends AbstractResourceLoadStatus {
        public SinglePackageResourceLoadStatus(@NonNull SinglePackageResourceDescriptor packageDescriptor, @Nullable ResourceSet resourceSet) {
            super(packageDescriptor, resourceSet);
            this.install();
        }
    }
}

