/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.ThresholdList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.swt.BeanItemFormat;
import ca.odell.glazedlists.impl.swt.BoundedRangeControlFactory;
import ca.odell.glazedlists.impl.swt.LowerThresholdViewer;
import ca.odell.glazedlists.impl.swt.SWTThreadProxyEventList;
import ca.odell.glazedlists.impl.swt.UpperThresholdViewer;
import ca.odell.glazedlists.swt.DefaultEventComboViewer;
import ca.odell.glazedlists.swt.DefaultEventListViewer;
import ca.odell.glazedlists.swt.DefaultEventTableViewer;
import ca.odell.glazedlists.swt.DefaultItemFormat;
import ca.odell.glazedlists.swt.ItemFormat;
import ca.odell.glazedlists.swt.TableItemConfigurer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlazedListsSWT {
    private GlazedListsSWT() {
        throw new UnsupportedOperationException();
    }

    public static <E> TransformedList<E, E> swtThreadProxyList(EventList<E> source, Display display) {
        return new SWTThreadProxyEventList<E>(source, display);
    }

    public static boolean isSWTThreadProxyList(EventList list) {
        return list instanceof SWTThreadProxyEventList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <E> EventList<E> createProxyListIfNecessary(EventList<E> source, Display display) {
        EventList<E> result = source;
        source.getReadWriteLock().readLock().lock();
        try {
            TransformedList<E, E> decorated = GlazedListsSWT.createSwtThreadProxyListIfNecessary(source, display);
            if (decorated != null && decorated != source) {
                result = decorated;
            }
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
        return result;
    }

    private static <E> TransformedList<E, E> createSwtThreadProxyListIfNecessary(EventList<E> source, Display display) {
        return GlazedListsSWT.isSWTThreadProxyList(source) ? null : GlazedListsSWT.swtThreadProxyList(source, display);
    }

    public static <E> ItemFormat<E> beanItemFormat(String property) {
        return new BeanItemFormat(property);
    }

    public static <E> ItemFormat<E> beanItemFormat(String property, String valueForNullElement) {
        return new BeanItemFormat(property, valueForNullElement);
    }

    public static SelectionListener lowerThresholdViewer(ThresholdList thresholdList, Slider slider) {
        return new LowerThresholdViewer(thresholdList, BoundedRangeControlFactory.slider(slider));
    }

    public static SelectionListener lowerThresholdViewer(ThresholdList thresholdList, Scale scale) {
        return new LowerThresholdViewer(thresholdList, BoundedRangeControlFactory.scale(scale));
    }

    public static SelectionListener upperThresholdViewer(ThresholdList thresholdList, Slider slider) {
        return new UpperThresholdViewer(thresholdList, BoundedRangeControlFactory.slider(slider));
    }

    public static SelectionListener upperThresholdViewer(ThresholdList thresholdList, Scale scale) {
        return new UpperThresholdViewer(thresholdList, BoundedRangeControlFactory.scale(scale));
    }

    public static <E> DefaultEventTableViewer<E> eventTableViewer(EventList<E> source, Table table, TableFormat<? super E> tableFormat) {
        return new DefaultEventTableViewer<E>(source, table, tableFormat, TableItemConfigurer.DEFAULT);
    }

    public static <E> DefaultEventTableViewer<E> eventTableViewer(EventList<E> source, Table table, TableFormat<? super E> tableFormat, TableItemConfigurer<? super E> tableItemConfigurer) {
        return new DefaultEventTableViewer<E>(source, table, tableFormat, tableItemConfigurer);
    }

    public static <E> DefaultEventTableViewer<E> eventTableViewerWithThreadProxyList(EventList<E> source, Table table, TableFormat<? super E> tableFormat) {
        EventList<E> proxySource = GlazedListsSWT.createSwtThreadProxyListWithLock(source, table.getDisplay());
        return new DefaultEventTableViewer<E>(proxySource, table, tableFormat, TableItemConfigurer.DEFAULT, true);
    }

    public static <E> DefaultEventTableViewer<E> eventTableViewerWithThreadProxyList(EventList<E> source, Table table, TableFormat<? super E> tableFormat, TableItemConfigurer<? super E> tableItemConfigurer) {
        EventList<E> proxySource = GlazedListsSWT.createSwtThreadProxyListWithLock(source, table.getDisplay());
        return new DefaultEventTableViewer<E>(proxySource, table, tableFormat, tableItemConfigurer, true);
    }

    public static <E> DefaultEventListViewer<E> eventListViewer(EventList<E> source, List list) {
        return new DefaultEventListViewer<E>(source, list);
    }

    public static <E> DefaultEventListViewer<E> eventListViewer(EventList<E> source, List list, ItemFormat<? super E> itemFormat) {
        return new DefaultEventListViewer<E>(source, list, itemFormat);
    }

    public static <E> DefaultEventListViewer<E> eventListViewerWithThreadProxyList(EventList<E> source, List list) {
        EventList<E> proxySource = GlazedListsSWT.createSwtThreadProxyListWithLock(source, list.getDisplay());
        return new DefaultEventListViewer<E>(proxySource, list, new DefaultItemFormat(), true);
    }

    public static <E> DefaultEventListViewer<E> eventListViewerWithThreadProxyList(EventList<E> source, List list, ItemFormat<? super E> itemFormat) {
        EventList<E> proxySource = GlazedListsSWT.createSwtThreadProxyListWithLock(source, list.getDisplay());
        return new DefaultEventListViewer<E>(proxySource, list, itemFormat, true);
    }

    public static <E> DefaultEventComboViewer<E> eventComboViewer(EventList<E> source, Combo combo) {
        return new DefaultEventComboViewer<E>(source, combo);
    }

    public static <E> DefaultEventComboViewer<E> eventComboViewer(EventList<E> source, Combo combo, ItemFormat<? super E> itemFormat) {
        return new DefaultEventComboViewer<E>(source, combo, itemFormat);
    }

    public static <E> DefaultEventComboViewer<E> eventComboViewerWithThreadProxyList(EventList<E> source, Combo combo) {
        EventList<E> proxySource = GlazedListsSWT.createSwtThreadProxyListWithLock(source, combo.getDisplay());
        return new DefaultEventComboViewer<E>(proxySource, combo, new DefaultItemFormat(), true);
    }

    public static <E> DefaultEventComboViewer<E> eventComboViewerWithThreadProxyList(EventList<E> source, Combo combo, ItemFormat<? super E> itemFormat) {
        EventList<E> proxySource = GlazedListsSWT.createSwtThreadProxyListWithLock(source, combo.getDisplay());
        return new DefaultEventComboViewer<E>(proxySource, combo, itemFormat, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <E> EventList<E> createSwtThreadProxyListWithLock(EventList<E> source, Display display) {
        TransformedList<E, E> result;
        source.getReadWriteLock().readLock().lock();
        try {
            result = GlazedListsSWT.swtThreadProxyList(source, display);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
        return result;
    }
}

