/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.locator;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class LabelCellEditorLocator
implements CellEditorLocator {
    private Label label;

    public LabelCellEditorLocator(Label label) {
        this.label = label;
    }

    public Label getLabel() {
        return this.label;
    }

    public void relocate(CellEditor celleditor) {
        Text text = (Text)celleditor.getControl();
        Rectangle rect = this.getLabel().getTextBounds().getCopy();
        this.getLabel().translateToAbsolute((Translatable)rect);
        if (!text.getFont().isDisposed()) {
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
        }
        if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }
}

