/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.commands.utlis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.uml.diagram.common.groups.Messages;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.ChangeGraphicalParentCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.ChangeModelParentCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.ChooseChildrenNotificationCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.ChooseParentNotificationCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.SetUpReferencesCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.UpdateReferencesCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.core.groupcontainment.GroupContainmentRegistry;
import org.eclipse.papyrus.uml.diagram.common.groups.core.utils.DefaultModelParent;
import org.eclipse.papyrus.uml.diagram.common.groups.core.utils.Utils;
import org.eclipse.papyrus.uml.diagram.common.groups.groupcontainment.AbstractContainerNodeDescriptor;

public class CommandsUtils {
    public static final String NEW_PARENT_HOST = "New_parent_host";
    public static final String GRAPHICAL_PARENT = "Graphical_parent";

    public static CompositeCommand getSemanticCommand(CreateElementRequestAdapter requestAdapter, TransactionalEditingDomain editingDomain, CreateElementRequest createElementRequest, Command createElementCommand, List<IGraphicalEditPart> graphicalParents) {
        SemanticCreateCommand semanticContainerParentCommand = new SemanticCreateCommand(requestAdapter, createElementCommand);
        SetUpReferencesCommand setUpReferences = new SetUpReferencesCommand(editingDomain, semanticContainerParentCommand.getLabel(), (IAdaptable)requestAdapter, graphicalParents);
        CompositeCommand semanticCommand = new CompositeCommand(semanticContainerParentCommand.getLabel());
        if (semanticCommand != null) {
            semanticCommand.compose((IUndoableOperation)semanticContainerParentCommand);
        }
        if (setUpReferences != null) {
            semanticCommand.compose((IUndoableOperation)setUpReferences);
        }
        return semanticCommand;
    }

    public static CompositeCommand getChooseParentNotification(TransactionalEditingDomain editingDomain, CreateViewAndElementRequest request, List<IGraphicalEditPart> graphicalParents, List<IGraphicalEditPart> modelParents, IGraphicalEditPart getHost) {
        CompositeCommand choiceCommand = null;
        if (graphicalParents != null && modelParents != null && (modelParents.size() > 1 || graphicalParents.size() > 1)) {
            String chooseCommandLabel = "Print choice notifications";
            choiceCommand = new CompositeCommand(chooseCommandLabel);
            if (modelParents.size() > 1) {
                ChooseParentNotificationCommand modelNotificationCommand = new ChooseParentNotificationCommand(editingDomain, chooseCommandLabel + " : Model ", modelParents, (Request)request, false, getHost);
                choiceCommand.compose((IUndoableOperation)modelNotificationCommand);
            } else if (graphicalParents.size() > 1) {
                ChooseParentNotificationCommand graphicalNotificationCommand = new ChooseParentNotificationCommand(editingDomain, chooseCommandLabel + " : Graphical ", graphicalParents, (Request)request, true, getHost);
                choiceCommand.compose((IUndoableOperation)graphicalNotificationCommand);
            }
        }
        return choiceCommand;
    }

    public static CompositeCommand getChooseParentNotification(TransactionalEditingDomain editingDomain, ChangeBoundsRequest request, List<IGraphicalEditPart> graphicalParents, List<IGraphicalEditPart> modelParents, IGraphicalEditPart getHost) {
        CompositeCommand choiceCommand = null;
        if (graphicalParents != null && modelParents != null && (modelParents.size() > 1 || graphicalParents.size() > 1)) {
            String chooseCommandLabel = "Print choice notifications";
            choiceCommand = new CompositeCommand(chooseCommandLabel);
            if (modelParents.size() > 1) {
                ChooseParentNotificationCommand modelNotificationCommand = new ChooseParentNotificationCommand(editingDomain, chooseCommandLabel + " : Model ", modelParents, (Request)request, false, getHost);
                choiceCommand.compose((IUndoableOperation)modelNotificationCommand);
            } else if (graphicalParents.size() > 1) {
                ChooseParentNotificationCommand graphicalNotificationCommand = new ChooseParentNotificationCommand(editingDomain, chooseCommandLabel + " : Graphical ", graphicalParents, (Request)request, true, getHost);
                choiceCommand.compose((IUndoableOperation)graphicalNotificationCommand);
            }
        }
        return choiceCommand;
    }

    public static boolean alreadyHaveGroupGraphicalParent(IGraphicalEditPart element, List<IGraphicalEditPart> modelParents) {
        IGraphicalEditPart parent = (IGraphicalEditPart)element.getParent();
        return GroupContainmentRegistry.isContainerConcerned(parent) && !element.getParent().getChildren().contains(parent);
    }

    public static int getDepth(IGraphicalEditPart part) {
        int depth = 0;
        IGraphicalEditPart parentPart = part;
        while (parentPart != null) {
            parentPart = parentPart.getParent();
            ++depth;
        }
        return depth;
    }

    public static IGraphicalEditPart selectBestModelContainer(List<IGraphicalEditPart> parents) {
        IGraphicalEditPart container = null;
        int containerDepth = 0;
        for (IGraphicalEditPart parent : parents) {
            int depth;
            if (!GroupContainmentRegistry.isContainerModel(parent) || (depth = CommandsUtils.getDepth(parent)) <= containerDepth) continue;
            container = parent;
        }
        return container;
    }

    public static Command getCommandFromDefaultModelParent(CreateViewAndElementRequest request, CreateElementRequest createElementRequest, IGraphicalEditPart getHost) {
        EClass typeToCreate = createElementRequest.getElementType().getEClass();
        IGraphicalEditPart hostParent = getHost;
        while (hostParent != null) {
            EObject hostParentElement = hostParent.resolveSemanticElement();
            if (GroupContainmentRegistry.getDescriptorsWithContainerEClass(hostParentElement.eClass()).isEmpty()) {
                for (EReference containmentRelation : hostParentElement.eClass().getEAllContainments()) {
                    if (!containmentRelation.getEReferenceType().isSuperTypeOf(typeToCreate)) continue;
                    if (getHost.equals(hostParent)) {
                        request.getExtendedData().put(NEW_PARENT_HOST, hostParent);
                        createElementRequest.setContainer(hostParentElement);
                        return null;
                    }
                    request.getExtendedData().put(NEW_PARENT_HOST, hostParent);
                    Command cmd = hostParent.getCommand((Request)request);
                    return cmd;
                }
            }
            hostParent = (IGraphicalEditPart)hostParent.getParent();
        }
        return null;
    }

    public static Command getCommandFromDefaultModelParent(ChangeBoundsRequest request, IGraphicalEditPart currentEditPart, IGraphicalEditPart getHost) {
        EClass typeToCreate = currentEditPart.resolveSemanticElement().eClass();
        IGraphicalEditPart hostParent = getHost;
        while (hostParent != null) {
            EObject hostParentElement = hostParent.resolveSemanticElement();
            if (GroupContainmentRegistry.getDescriptorsWithContainerEClass(hostParentElement.eClass()).isEmpty()) {
                for (EReference containmentRelation : hostParentElement.eClass().getEAllContainments()) {
                    if (!containmentRelation.getEReferenceType().isSuperTypeOf(typeToCreate)) continue;
                    if (getHost.equals(hostParent)) {
                        return null;
                    }
                    request.getExtendedData().put(NEW_PARENT_HOST, hostParent);
                    Command cmd = hostParent.getCommand((Request)request);
                    return cmd;
                }
            }
            hostParent = (IGraphicalEditPart)hostParent.getParent();
        }
        return null;
    }

    public static ChangeModelParentCommand getUpdateChildrenModel(List<IGraphicalEditPart> directChildsToComplete, AbstractContainerNodeDescriptor descriptor, TransactionalEditingDomain editingDomain, IAdaptable parent, IGraphicalEditPart anyPart) {
        ChangeModelParentCommand cmd = null;
        HashMap<EObject, EReference> elementToMove = new HashMap<EObject, EReference>();
        if (!directChildsToComplete.isEmpty()) {
            for (IGraphicalEditPart child : directChildsToComplete) {
                EObject childEObject = child.resolveSemanticElement();
                EClass childEClass = childEObject.eClass();
                if (!descriptor.canIBeModelParentOf(childEClass)) continue;
                elementToMove.put(childEObject, descriptor.getContainmentReferenceFor(childEClass));
            }
        }
        if (!elementToMove.isEmpty()) {
            cmd = new ChangeModelParentCommand(editingDomain, parent, elementToMove, anyPart);
        }
        return cmd;
    }

    public static void updateGraphicalChildren(List<IGraphicalEditPart> automaticChildren, Request request) {
        if (!automaticChildren.isEmpty()) {
            request.getExtendedData().put("ALL_AUTOMATIC_GRAPHICAL_CHILDREN", automaticChildren);
        }
    }

    public static CompositeCommand getChooseGraphicalChildrenNotificationCommand(List<IGraphicalEditPart> allChildren, List<IGraphicalEditPart> automaticChildren, CreateViewAndElementRequest request, TransactionalEditingDomain domain, String label, IGraphicalEditPart getHost, DiagramEditPart diagramPart) {
        if (allChildren.size() > automaticChildren.size()) {
            Iterator descriptors = request.getViewDescriptors().iterator();
            CompositeCommand compositeCommand = new CompositeCommand(label);
            while (descriptors.hasNext()) {
                CreateViewRequest.ViewDescriptor descriptor = (CreateViewRequest.ViewDescriptor)descriptors.next();
                ChooseChildrenNotificationCommand cmd = new ChooseChildrenNotificationCommand(domain, label, allChildren, automaticChildren, (IAdaptable)descriptor, getHost, diagramPart);
                if (cmd == null) continue;
                compositeCommand.compose((IUndoableOperation)cmd);
            }
            return compositeCommand;
        }
        return null;
    }

    public static CompositeCommand getChooseGraphicalChildrenNotificationCommand(List<IGraphicalEditPart> allChildren, List<IGraphicalEditPart> automaticChildren, IAdaptable adapter, TransactionalEditingDomain domain, String label, IGraphicalEditPart getHost, DiagramEditPart diagramPart) {
        CompositeCommand result = null;
        ChooseChildrenNotificationCommand cmd = new ChooseChildrenNotificationCommand(domain, label, allChildren, automaticChildren, adapter, getHost, diagramPart);
        if (cmd != null) {
            result = new CompositeCommand(label);
            result.compose((IUndoableOperation)cmd);
        }
        return result;
    }

    public static CompositeCommand getHandleChildrenCommand(Set<AbstractContainerNodeDescriptor> descriptors, Request request, DiagramEditPart diagramPart, TransactionalEditingDomain editingDomain, IAdaptable parentAdapter, List<IGraphicalEditPart> modelParents, IGraphicalEditPart getHost) {
        CompositeCommand cc = null;
        if (!descriptors.isEmpty()) {
            String handleChildrenLabel = "Handle Children command ";
            for (AbstractContainerNodeDescriptor descriptor : descriptors) {
                ChangeModelParentCommand updateChildrenModel;
                ArrayList<IGraphicalEditPart> directChildsToComplete = new ArrayList<IGraphicalEditPart>();
                List<IGraphicalEditPart> oldDirectChildsToComplete = null;
                oldDirectChildsToComplete = CommandsUtils.initDirectChildLists(request, (IGraphicalEditPart)diagramPart, parentAdapter, descriptor, directChildsToComplete, oldDirectChildsToComplete);
                if ((directChildsToComplete == null || directChildsToComplete.isEmpty()) && (oldDirectChildsToComplete == null || oldDirectChildsToComplete.isEmpty())) continue;
                cc = new CompositeCommand(handleChildrenLabel);
                ArrayList<IGraphicalEditPart> newGraphicalChildren = new ArrayList<IGraphicalEditPart>();
                ArrayList<IGraphicalEditPart> choiceToMakeChildren = new ArrayList<IGraphicalEditPart>();
                for (IGraphicalEditPart part : directChildsToComplete) {
                    if (CommandsUtils.alreadyHaveGroupGraphicalParent(part, modelParents)) {
                        if (!CommandsUtils.isNotAlreadyAGraphicalSon(part, request, parentAdapter)) continue;
                        choiceToMakeChildren.add(part);
                        continue;
                    }
                    newGraphicalChildren.add(part);
                }
                if (!directChildsToComplete.isEmpty() && (updateChildrenModel = CommandsUtils.getUpdateChildrenModel(directChildsToComplete, descriptor, editingDomain, parentAdapter, (IGraphicalEditPart)directChildsToComplete.get(0))) != null) {
                    cc.compose((IUndoableOperation)updateChildrenModel);
                }
                if (!newGraphicalChildren.isEmpty()) {
                    CommandsUtils.updateGraphicalChildren(newGraphicalChildren, request);
                }
                String updateCommandeLabel = "Update children references";
                CommandsUtils.updateReferencesAndModelOfGraphicalChildren(request, editingDomain, parentAdapter, cc, directChildsToComplete, oldDirectChildsToComplete, handleChildrenLabel + ":" + updateCommandeLabel + " -> update reference graphical child", getHost, descriptor);
                UpdateReferencesCommand updateRefCommand = new UpdateReferencesCommand(editingDomain, handleChildrenLabel + ":" + updateCommandeLabel + " -> update reference new child", directChildsToComplete, descriptor, parentAdapter);
                if (updateRefCommand != null) {
                    cc.compose((IUndoableOperation)updateRefCommand);
                }
                CommandsUtils.withdrawOldChildrenReferences(editingDomain, parentAdapter, cc, handleChildrenLabel + ":" + updateCommandeLabel + " -> remove reference from of child", descriptor, directChildsToComplete, oldDirectChildsToComplete);
                String chooseGraphicalChildrenLabel = "Notification for choosing graphical children";
                CompositeCommand chooseGraphicalChildrenCommand = null;
                if (request instanceof CreateViewAndElementRequest) {
                    chooseGraphicalChildrenCommand = CommandsUtils.getChooseGraphicalChildrenNotificationCommand(directChildsToComplete, newGraphicalChildren, (CreateViewAndElementRequest)request, editingDomain, chooseGraphicalChildrenLabel, getHost, diagramPart);
                } else if (request instanceof ChangeBoundsRequest) {
                    chooseGraphicalChildrenCommand = CommandsUtils.getChooseGraphicalChildrenNotificationCommand(directChildsToComplete, newGraphicalChildren, parentAdapter, editingDomain, chooseGraphicalChildrenLabel, getHost, diagramPart);
                }
                if (chooseGraphicalChildrenCommand != null) {
                    cc.compose(chooseGraphicalChildrenCommand);
                }
                cc.reduce();
                if (!cc.isEmpty()) continue;
                cc = null;
            }
        }
        return cc;
    }

    private static boolean isMovingRequest(ChangeBoundsRequest request) {
        return request.getSizeDelta() == null || request.getSizeDelta().equals(0, 0);
    }

    private static void updateReferencesAndModelOfGraphicalChildren(Request request, TransactionalEditingDomain editingDomain, IAdaptable parentAdapter, CompositeCommand cc, List<IGraphicalEditPart> childList, List<IGraphicalEditPart> oldChildsList, String updateCommandeLabel, IGraphicalEditPart getHost, AbstractContainerNodeDescriptor descriptor) {
        Object _movingPart;
        if (request instanceof ChangeBoundsRequest && (_movingPart = parentAdapter.getAdapter(EditPart.class)) instanceof IGraphicalEditPart) {
            List<Object> graphicalChilds = new ArrayList();
            IGraphicalEditPart movingEditPart = (IGraphicalEditPart)_movingPart;
            graphicalChilds = CommandsUtils.getGraphicalChild(movingEditPart);
            ChangeBoundsRequest changeBoundRequest = (ChangeBoundsRequest)request;
            for (IGraphicalEditPart iGraphicalEditPart : graphicalChilds) {
                List<IGraphicalEditPart> oldGroupContainer = Utils.createComputeListsOfAllGroupContainerVisually(iGraphicalEditPart, changeBoundRequest, false, movingEditPart);
                List<IGraphicalEditPart> newGroupContainer = Utils.createComputeListsOfAllGroupContainerVisually(iGraphicalEditPart, changeBoundRequest, true, movingEditPart);
                IGraphicalEditPart compartmentEditPart = (IGraphicalEditPart)Utils.getCompartementEditPartFromMainEditPart(movingEditPart.getViewer().getEditPartRegistry(), (EditPart)movingEditPart);
                if (CommandsUtils.isMovingRequest(changeBoundRequest)) {
                    CommandsUtils.handleMovingRequestForGraphicalChildren(editingDomain, cc, updateCommandeLabel, getHost, iGraphicalEditPart, oldGroupContainer, newGroupContainer, compartmentEditPart);
                    continue;
                }
                cc = CommandsUtils.handleResizingRequestForGraphicalChildren(editingDomain, parentAdapter, cc, childList, getHost, descriptor, movingEditPart, iGraphicalEditPart, changeBoundRequest, newGroupContainer);
            }
            childList.removeAll(graphicalChilds);
            oldChildsList.removeAll(graphicalChilds);
        }
    }

    private static CompositeCommand handleResizingRequestForGraphicalChildren(TransactionalEditingDomain editingDomain, IAdaptable parentAdapter, CompositeCommand cc, List<IGraphicalEditPart> childList, IGraphicalEditPart getHost, AbstractContainerNodeDescriptor descriptor, IGraphicalEditPart movingEditPart, IGraphicalEditPart graphicalChild, ChangeBoundsRequest changeBoundRequest, List<IGraphicalEditPart> newGroupContainer) {
        SetBoundsCommand sbc;
        int direction = changeBoundRequest.getResizeDirection();
        Point previousnLocation = graphicalChild.getFigure().getBounds().getLocation().getCopy();
        Point negatedMoeDelta = changeBoundRequest.getMoveDelta().getNegated().getCopy();
        boolean correctLocation = false;
        switch (direction) {
            case 8: {
                previousnLocation.translate(negatedMoeDelta.x, 0);
                correctLocation = true;
                break;
            }
            case 1: {
                previousnLocation.translate(0, negatedMoeDelta.y);
                correctLocation = true;
                break;
            }
            case 9: {
                previousnLocation.translate(negatedMoeDelta);
                correctLocation = true;
                break;
            }
        }
        if (!childList.contains(graphicalChild)) {
            if (correctLocation) {
                newGroupContainer.remove(movingEditPart);
                newGroupContainer.remove(Utils.getCompartementEditPartFromMainEditPart(movingEditPart.getViewer().getEditPartRegistry(), (EditPart)movingEditPart));
                correctLocation = false;
            }
            cc = CommandsUtils.handleGraphicalChildrenMovingOut(editingDomain, parentAdapter, cc, getHost, descriptor, movingEditPart, graphicalChild, newGroupContainer);
        }
        if (correctLocation && (sbc = new SetBoundsCommand(editingDomain, "West or North resizing correcting relative coordiante", (IAdaptable)graphicalChild, previousnLocation)) != null) {
            cc.compose((IUndoableOperation)sbc);
        }
        return cc;
    }

    private static void handleMovingRequestForGraphicalChildren(TransactionalEditingDomain editingDomain, CompositeCommand cc, String updateCommandeLabel, IGraphicalEditPart getHost, IGraphicalEditPart graphicalChild, List<IGraphicalEditPart> oldGroupContainer, List<IGraphicalEditPart> newGroupContainer, IGraphicalEditPart compartmentEditPart) {
        for (IGraphicalEditPart parentGroup : oldGroupContainer) {
            UpdateReferencesCommand cmd1;
            if (newGroupContainer.contains(parentGroup) || parentGroup.equals(compartmentEditPart) || (cmd1 = new UpdateReferencesCommand(editingDomain, updateCommandeLabel, Collections.singletonList(graphicalChild), GroupContainmentRegistry.getContainerDescriptor(parentGroup), (IAdaptable)parentGroup, false)) == null) continue;
            cc.compose((IUndoableOperation)cmd1);
        }
        ArrayList<IGraphicalEditPart> modelParents = new ArrayList<IGraphicalEditPart>();
        EObject childEObject = graphicalChild.resolveSemanticElement();
        boolean alreadyHaveValideModelParent = false;
        AbstractContainerNodeDescriptor containerDescriptor = GroupContainmentRegistry.getContainerDescriptor(compartmentEditPart);
        if (containerDescriptor != null) {
            alreadyHaveValideModelParent = containerDescriptor.canIBeModelParentOf(childEObject.eClass());
        }
        for (IGraphicalEditPart newParentGroup : newGroupContainer) {
            AbstractContainerNodeDescriptor desc;
            UpdateReferencesCommand cmd2 = new UpdateReferencesCommand(editingDomain, updateCommandeLabel, Collections.singletonList(graphicalChild), GroupContainmentRegistry.getContainerDescriptor(newParentGroup), (IAdaptable)newParentGroup, true);
            if (cmd2 != null) {
                cc.compose((IUndoableOperation)cmd2);
            }
            if ((desc = GroupContainmentRegistry.getContainerDescriptor(newParentGroup)) == null || !desc.canIBeModelParentOf(childEObject.eClass())) continue;
            modelParents.add(newParentGroup);
        }
        if (!alreadyHaveValideModelParent) {
            ChangeModelParentCommand changeModelParent;
            Map<EObject, EReference> child = null;
            IGraphicalEditPart newModelParent = null;
            if (!modelParents.isEmpty()) {
                newModelParent = (IGraphicalEditPart)modelParents.get(0);
                AbstractContainerNodeDescriptor newDesc = GroupContainmentRegistry.getContainerDescriptor(newModelParent);
                if (newDesc != null && newModelParent != null) {
                    EReference ref = newDesc.getContainmentReferenceFor(childEObject.eClass());
                    child = Collections.singletonMap(childEObject, ref);
                }
            } else {
                DefaultModelParent parent = Utils.getDefaultModelParent(childEObject.eClass(), getHost);
                child = Collections.singletonMap(childEObject, parent.geteReference());
                newModelParent = parent.getiGraphicalEditPart();
            }
            if (child != null && newModelParent != null && (changeModelParent = new ChangeModelParentCommand(editingDomain, (IAdaptable)newModelParent, child, newModelParent)) != null) {
                cc.compose((IUndoableOperation)changeModelParent);
            }
        }
    }

    private static CompositeCommand handleGraphicalChildrenMovingOut(TransactionalEditingDomain editingDomain, IAdaptable parentAdapter, CompositeCommand cc, IGraphicalEditPart getHost, AbstractContainerNodeDescriptor descriptor, IGraphicalEditPart movingEditPart, IGraphicalEditPart graphicalChild, List<IGraphicalEditPart> newGroupContainer) {
        UpdateReferencesCommand updateRefCommand;
        String label = Messages.CommandsUtils_HandleGraphicalChildrenMovingOut_Label;
        if (cc == null) {
            cc = new CompositeCommand(label);
        }
        if ((updateRefCommand = new UpdateReferencesCommand(editingDomain, label, Collections.singletonList(graphicalChild), descriptor, parentAdapter, false)) != null) {
            cc.compose((IUndoableOperation)updateRefCommand);
        }
        IGraphicalEditPart newParent = null;
        newParent = !newGroupContainer.isEmpty() ? newGroupContainer.get(0) : (IGraphicalEditPart)movingEditPart.getParent();
        ChangeGraphicalParentCommand changeParentCmd = new ChangeGraphicalParentCommand(editingDomain, label + ": Changing graphical parent", (EditPart)newParent, (EditPart)graphicalChild, getHost);
        if (changeParentCmd != null) {
            cc.compose((IUndoableOperation)changeParentCmd);
        }
        return cc;
    }

    private static List<IGraphicalEditPart> getGraphicalChild(IGraphicalEditPart parentEditPart) {
        EditPartViewer viewer = null;
        ArrayList<IGraphicalEditPart> result = null;
        if (parentEditPart != null && (viewer = parentEditPart.getViewer()) != null) {
            IGraphicalEditPart compartmentEditPart = (IGraphicalEditPart)Utils.getCompartementEditPartFromMainEditPart(viewer.getEditPartRegistry(), (EditPart)parentEditPart);
            result = new ArrayList<IGraphicalEditPart>();
            for (Object child : compartmentEditPart.getChildren()) {
                if (!(child instanceof IGraphicalEditPart) || !GroupContainmentRegistry.isNodeConcerned((IGraphicalEditPart)child)) continue;
                result.add((IGraphicalEditPart)child);
            }
        }
        return result;
    }

    private static List<IGraphicalEditPart> initDirectChildLists(Request request, IGraphicalEditPart diagramPart, IAdaptable parentAdapter, AbstractContainerNodeDescriptor descriptor, List<IGraphicalEditPart> directChildsToComplete, List<IGraphicalEditPart> oldDirectChildsToComplete) {
        Object _parentEditPart;
        if (request instanceof CreateViewAndElementRequest) {
            Utils.createComputedListsOfVisualYRelatedElements(directChildsToComplete, (CreateViewAndElementRequest)request, diagramPart, descriptor);
        } else if (request instanceof ChangeBoundsRequest && (_parentEditPart = parentAdapter.getAdapter(IGraphicalEditPart.class)) instanceof IGraphicalEditPart) {
            oldDirectChildsToComplete = new ArrayList<IGraphicalEditPart>();
            Utils.createComputedListsOfVisuallyRelatedElements(directChildsToComplete, (ChangeBoundsRequest)request, (IGraphicalEditPart)_parentEditPart, descriptor, true);
            Utils.createComputedListsOfVisuallyRelatedElements(oldDirectChildsToComplete, (ChangeBoundsRequest)request, (IGraphicalEditPart)_parentEditPart, descriptor, false);
        }
        return oldDirectChildsToComplete;
    }

    private static CompositeCommand withdrawOldChildrenReferences(TransactionalEditingDomain editingDomain, IAdaptable parentAdapter, CompositeCommand cc, String handleChildrenLabel, AbstractContainerNodeDescriptor descriptor, List<IGraphicalEditPart> directChildsToComplete, List<IGraphicalEditPart> oldDirectChildsToComplete) {
        if (oldDirectChildsToComplete != null && !oldDirectChildsToComplete.isEmpty()) {
            ArrayList<IGraphicalEditPart> childToWithdraw = new ArrayList<IGraphicalEditPart>();
            for (IGraphicalEditPart child : oldDirectChildsToComplete) {
                if (directChildsToComplete.contains(child)) continue;
                childToWithdraw.add(child);
            }
            if (!childToWithdraw.isEmpty()) {
                UpdateReferencesCommand updateRefCommand;
                String unreferencinComandLabel = "Unset Reference";
                if (cc == null) {
                    cc = new CompositeCommand(handleChildrenLabel + ":" + unreferencinComandLabel);
                }
                if ((updateRefCommand = new UpdateReferencesCommand(editingDomain, handleChildrenLabel + ":" + unreferencinComandLabel, childToWithdraw, descriptor, parentAdapter, false)) != null) {
                    cc.compose((IUndoableOperation)updateRefCommand);
                }
            }
            cc.reduce();
            if (cc.isEmpty()) {
                cc = null;
            }
        }
        return cc;
    }

    private static boolean isNotAlreadyAGraphicalSon(IGraphicalEditPart childPart, Request request, IAdaptable parentAdapter) {
        Object _editPart;
        if (request instanceof ChangeBoundsRequest && (_editPart = parentAdapter.getAdapter(EditPart.class)) instanceof IGraphicalEditPart) {
            IGraphicalEditPart parentPart = (IGraphicalEditPart)_editPart;
            return !parentPart.getChildren().contains(childPart);
        }
        return true;
    }

    public static IGraphicalEditPart setRequestParentsParameters(Request request, List<IGraphicalEditPart> _graphicalParents, List<IGraphicalEditPart> _modelParents, EditPart getHost) {
        IGraphicalEditPart graphicalParent = null;
        if (!_graphicalParents.isEmpty()) {
            graphicalParent = _graphicalParents.get(0);
            request.getExtendedData().put("GROUP_GRAPHICAL_CONTAINERS", _graphicalParents);
        }
        if (_modelParents != null) {
            request.getExtendedData().put("GROUP_MODEL_CONTAINERS", _modelParents);
        }
        return graphicalParent;
    }

    public static Command sendRequestSuitableHost(CreateViewAndElementRequest request, CreateElementRequest createElementRequest, IGraphicalEditPart getHost, List<IGraphicalEditPart> _modelParents) {
        EObject modelContainer = null;
        if (!_modelParents.isEmpty()) {
            IGraphicalEditPart defaultGraphicalEditPart = _modelParents.get(0);
            if (!getHost.equals(defaultGraphicalEditPart)) {
                request.getExtendedData().put(NEW_PARENT_HOST, defaultGraphicalEditPart);
                return defaultGraphicalEditPart.getCommand((Request)request);
            }
            modelContainer = getHost.resolveSemanticElement();
            createElementRequest.setContainer(modelContainer);
        } else {
            Command cmd = CommandsUtils.getCommandFromDefaultModelParent(request, createElementRequest, getHost);
            if (cmd != null) {
                return cmd;
            }
        }
        return null;
    }

    public static Command sendRequestSuitableHost(ChangeBoundsRequest request, IGraphicalEditPart getHost, List<IGraphicalEditPart> _modelParents, IGraphicalEditPart movingEditPart) {
        if (!_modelParents.isEmpty()) {
            IGraphicalEditPart defaultModelParentEditPart = _modelParents.contains(movingEditPart.getParent()) ? (IGraphicalEditPart)movingEditPart.getParent() : _modelParents.get(0);
            if (!getHost.equals(defaultModelParentEditPart)) {
                return defaultModelParentEditPart.getCommand((Request)request);
            }
        } else {
            Command cmd = CommandsUtils.getCommandFromDefaultModelParent(request, movingEditPart, getHost);
            if (cmd != null) {
                return cmd;
            }
        }
        return null;
    }

    public static Command requestEditPartMultiplexor(ChangeBoundsRequest request, String label, IGraphicalEditPart getHost) {
        CompositeCommand result = new CompositeCommand(label);
        if (request.getEditParts().size() > 1) {
            for (EditPart part : request.getEditParts()) {
                ChangeBoundsRequest req = new ChangeBoundsRequest();
                req.setEditParts(Collections.singletonList(part));
                req.setMoveDelta(request.getMoveDelta());
                req.setSizeDelta(request.getSizeDelta());
                req.setLocation(request.getLocation());
                req.setResizeDirection(request.getResizeDirection());
                req.setCenteredResize(request.isCenteredResize());
                req.setConstrainedMove(request.isConstrainedMove());
                req.setConstrainedResize(request.isConstrainedResize());
                req.setSnapToEnabled(request.isSnapToEnabled());
                req.setType((Object)"resize children");
                HashMap extendedData = new HashMap(request.getExtendedData());
                req.setExtendedData(extendedData);
                Command cmd = getHost.getEditPolicy((Object)"LayoutEditPolicy").getCommand((Request)req);
                if (cmd == null) continue;
                result.compose((IUndoableOperation)new CommandProxy(cmd));
            }
            if (!result.isEmpty()) {
                return new ICommandProxy((ICommand)result);
            }
        }
        return null;
    }

    public static void getChangeGraphicalParentCommand(String label, CompositeCommand result, IGraphicalEditPart movingEditPart, TransactionalEditingDomain editingDomain, IGraphicalEditPart graphicalParent, IGraphicalEditPart getHost, ChangeBoundsRequest request) {
        if (graphicalParent != null) {
            ChangeGraphicalParentCommand changeGraphicalParent = new ChangeGraphicalParentCommand(editingDomain, label + ": change graphical parent", (EditPart)graphicalParent, (EditPart)movingEditPart, getHost, (Request)request);
            if (changeGraphicalParent != null) {
                changeGraphicalParent.setMode(ChangeGraphicalParentCommand.Mode.MOVE_CHILD);
                result.compose((IUndoableOperation)changeGraphicalParent);
            }
        } else {
            ChangeGraphicalParentCommand changeGraphicalParent = new ChangeGraphicalParentCommand(editingDomain, label + ": change graphical parent", (EditPart)getHost, (EditPart)movingEditPart, getHost, (Request)request);
            if (changeGraphicalParent != null) {
                changeGraphicalParent.setMode(ChangeGraphicalParentCommand.Mode.MOVE_CHILD);
                result.compose((IUndoableOperation)changeGraphicalParent);
            }
        }
    }
}

