/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractGraphicalCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.menu.utils.DeleteActionUtil;

public class HeterogeneousDeleteCommandHandler
extends AbstractGraphicalCommandHandler
implements IHandler {
    private static final String COMMAND_LABEL = "Heterogeneous Delete From Model";

    @Override
    protected Command getCommand() {
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        CompoundCommand command = new CompoundCommand(COMMAND_LABEL);
        for (IGraphicalEditPart editPart : editParts) {
            Command deleteCommand = null;
            if (DeleteActionUtil.isSemanticDeletion(editPart)) {
                deleteCommand = DeleteActionUtil.getDeleteFromModelCommand(editPart, editingDomain);
            } else if (DeleteActionUtil.isSupportView(editPart) || !DeleteActionUtil.isCanonicalView(editPart) && !DeleteActionUtil.isCanonical((EditPart)editPart)) {
                deleteCommand = DeleteActionUtil.getDeleteFromDiagramCommand(editPart);
            }
            if (deleteCommand == null) continue;
            command.add(deleteCommand);
        }
        return command;
    }
}

