/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.nattable.hyperlink;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.action.AbstractMouseSelectionAction;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.editor.welcome.nattable.ServiceConfigAttributes;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.swt.events.MouseEvent;

public class HyperlinkNavigationAction
extends AbstractMouseSelectionAction {
    <T> T getService(NatTable natTable, Class<T> serviceType) {
        return ServiceConfigAttributes.getService(serviceType, natTable.getConfigRegistry(), DisplayMode.NORMAL, new String[0]);
    }

    public void run(NatTable natTable, MouseEvent event) {
        IPageManager pages;
        super.run(natTable, event);
        Object data = natTable.getDataValueByPosition(this.getGridColumnPosition(), this.getGridRowPosition());
        if (data instanceof IObservableValue) {
            data = ((IObservableValue)data).getValue();
        }
        if ((pages = this.getService(natTable, IPageManager.class)).allPages().contains(data)) {
            if (pages.isOpen(data)) {
                pages.selectPage(data);
            } else {
                pages.openPage(data);
            }
        } else if (data != null) {
            this.getService(natTable, NavigationService.class).navigate(data);
            this.getService(natTable, ISelectionProvider.class).setSelection((ISelection)new StructuredSelection(data));
        }
    }
}

