/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;

public class DownloadAttachmentJob
extends Job {
    private final ITaskAttachment attachment;
    private final File targetFile;

    public DownloadAttachmentJob(ITaskAttachment attachment, File targetFile) {
        super(Messages.DownloadAttachmentJob_Downloading_Attachment);
        this.attachment = attachment;
        this.targetFile = targetFile;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                boolean exceptionThrown = true;
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.targetFile));){
                        AttachmentUtil.downloadAttachment(this.attachment, out, monitor);
                        exceptionThrown = false;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (exceptionThrown) {
                        this.targetFile.delete();
                    }
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new RepositoryStatus(this.attachment.getTaskRepository(), 4, "org.eclipse.mylyn.tasks.ui", 5, "IO error writing attachment: " + e.getMessage(), (Throwable)e));
            }
        }
        catch (CoreException e) {
            TasksUiInternal.asyncDisplayStatus(Messages.DownloadAttachmentJob_Copy_Attachment_to_Clipboard, e.getStatus());
            return Status.OK_STATUS;
        }
        return Status.OK_STATUS;
    }
}

