/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.reconnect;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.edges.ElementDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ActivityEdgeHelper;
import org.eclipse.papyrus.uml.domain.services.labels.ElementDefaultNameProvider;
import org.eclipse.papyrus.uml.domain.services.reconnect.IDomainBasedEdgeReconnectSourceBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DeployedArtifact;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDomainBasedEdgeReconnectSourceBehaviorProvider
implements IDomainBasedEdgeReconnectSourceBehaviorProvider {
    private final IEditableChecker editableChecker;
    private final IViewQuerier representationQuery;

    public ElementDomainBasedEdgeReconnectSourceBehaviorProvider(IEditableChecker editableChecker, IViewQuerier representationQuery) {
        this.editableChecker = Objects.requireNonNull(editableChecker);
        this.representationQuery = Objects.requireNonNull(representationQuery);
    }

    @Override
    public CheckStatus reconnectSource(EObject elementToReconnect, EObject oldSource, EObject newSource, Object newSourceView) {
        if (elementToReconnect == null || oldSource == null || newSource == null) {
            return CheckStatus.no(MessageFormat.format("Invalid input for reconnexion (element ={0} oldSource ={1} newSource = {2})", elementToReconnect, oldSource, newSource));
        }
        return (CheckStatus)new ReconnectSourceBehaviorProviderSwitch(oldSource, newSource, newSourceView, this.editableChecker, this.representationQuery).doSwitch(elementToReconnect);
    }

    static class ReconnectSourceBehaviorProviderSwitch
    extends UMLSwitch<CheckStatus> {
        private final EObject oldSource;
        private final EObject newSource;
        private final IEditableChecker editableChecker;
        private final IViewQuerier representationQuery;
        private final Object newSourceView;

        ReconnectSourceBehaviorProviderSwitch(EObject oldSource, EObject newSource, Object newSourceView, IEditableChecker editableChecker, IViewQuerier representationQuery) {
            this.oldSource = oldSource;
            this.newSource = newSource;
            this.newSourceView = newSourceView;
            this.editableChecker = editableChecker;
            this.representationQuery = representationQuery;
        }

        public CheckStatus caseActivityEdge(ActivityEdge activityEdge) {
            activityEdge.setSource((ActivityNode)this.newSource);
            ActivityEdgeHelper activityEdgeHelper = new ActivityEdgeHelper();
            activityEdgeHelper.updateActivityEdgeContainer(activityEdge);
            activityEdgeHelper.setInPartition(activityEdge);
            return CheckStatus.YES;
        }

        public CheckStatus caseAssociation(Association association) {
            Classifier newType = (Classifier)this.newSource;
            Property targetProperty = (Property)association.getMemberEnds().get(1);
            targetProperty.setType((Type)newType);
            Property sourceProperty = (Property)association.getMemberEnds().get(0);
            if (!association.getOwnedEnds().contains((Object)sourceProperty) && this.newSource instanceof StructuredClassifier) {
                ((StructuredClassifier)this.newSource).getOwnedAttributes().add((Object)sourceProperty);
            }
            return CheckStatus.YES;
        }

        public CheckStatus caseComponentRealization(ComponentRealization componentRealization) {
            componentRealization.getClients().remove((Object)this.oldSource);
            Classifier newClassifier = (Classifier)this.newSource;
            componentRealization.getRealizingClassifiers().add((Object)newClassifier);
            return CheckStatus.YES;
        }

        public CheckStatus caseConnector(Connector connector) {
            Object sourceVisualParent = this.representationQuery.getVisualParent(this.newSourceView);
            if (sourceVisualParent != null) {
                EObject visualSourceSementicParent = this.representationQuery.getSemanticElement(sourceVisualParent);
                ConnectorEnd connectorEnd = (ConnectorEnd)connector.getEnds().get(0);
                connectorEnd.setRole((ConnectableElement)this.newSource);
                if (visualSourceSementicParent instanceof Property) {
                    Property sourceProperty = (Property)visualSourceSementicParent;
                    connectorEnd.setPartWithPort(sourceProperty);
                } else {
                    connectorEnd.setPartWithPort(null);
                }
                return CheckStatus.YES;
            }
            return (CheckStatus)super.caseConnector(connector);
        }

        public CheckStatus caseDependency(Dependency dependency) {
            dependency.getClients().remove((Object)this.oldSource);
            dependency.getClients().add((Object)((NamedElement)this.newSource));
            ElementDomainBasedEdgeContainerProvider containerProvider = new ElementDomainBasedEdgeContainerProvider(this.editableChecker);
            EObject newOwner = containerProvider.getContainer(this.newSource, (EObject)dependency.getSuppliers().get(0), (EObject)dependency, null, null, null);
            Element oldOwner = dependency.getOwner();
            if (oldOwner != newOwner && oldOwner instanceof Package && newOwner instanceof Package) {
                ((Package)newOwner).getPackagedElements().add((Object)dependency);
            }
            return CheckStatus.YES;
        }

        public CheckStatus caseDeployment(Deployment deployment) {
            deployment.getSuppliers().remove((Object)this.oldSource);
            DeployedArtifact newDeployedArtifact = (DeployedArtifact)this.newSource;
            deployment.getDeployedArtifacts().add((Object)newDeployedArtifact);
            return CheckStatus.YES;
        }

        public CheckStatus caseExtend(Extend extend) {
            extend.setExtension((UseCase)this.newSource);
            return CheckStatus.YES;
        }

        public CheckStatus caseExtension(Extension extension) {
            String oldName = extension.getName();
            try {
                Property property2;
                extension.setName(null);
                ElementDefaultNameProvider elementDefaultNameProvider = new ElementDefaultNameProvider();
                String deducedName = elementDefaultNameProvider.getDefaultName((NamedElement)extension, extension.eContainer());
                Class targetType = extension.getMetaclass();
                if (this.oldSource instanceof Stereotype) {
                    EList attributes = ((Stereotype)this.oldSource).getOwnedAttributes();
                    for (Property property2 : attributes) {
                        if (property2.getAssociation() != extension) continue;
                        ((Stereotype)this.oldSource).getOwnedAttributes().remove((Object)property2);
                        extension.getMemberEnds().remove((Object)property2);
                        break;
                    }
                }
                EList ends = extension.getOwnedEnds();
                for (Property endSource : ends) {
                    if (!(endSource instanceof ExtensionEnd)) continue;
                    endSource.setName("extension_" + ((NamedElement)this.newSource).getName());
                    endSource.setType((Type)this.newSource);
                    break;
                }
                property2 = UMLFactory.eINSTANCE.createProperty();
                property2.setName("base_" + targetType.getName());
                property2.setType((Type)targetType);
                property2.setAssociation((Association)extension);
                property2.setAggregation(AggregationKind.NONE_LITERAL);
                extension.getMemberEnds().add((Object)property2);
                ((StructuredClassifier)this.newSource).getOwnedAttributes().add((Object)property2);
                if (oldName.contains(deducedName) && oldName.indexOf(deducedName) == 0) {
                    oldName = oldName.substring(deducedName.length());
                    try {
                        extension.setName(elementDefaultNameProvider.getDefaultName((NamedElement)extension, extension.eContainer()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            finally {
                if (extension.getName() == null) {
                    extension.setName(oldName);
                }
            }
            return CheckStatus.YES;
        }

        public CheckStatus caseGeneralization(Generalization generalization) {
            generalization.setSpecific((Classifier)this.newSource);
            return CheckStatus.YES;
        }

        public CheckStatus caseInclude(Include include) {
            include.setIncludingCase((UseCase)this.newSource);
            return CheckStatus.YES;
        }

        public CheckStatus caseInformationFlow(InformationFlow informationFlow) {
            informationFlow.getInformationSources().remove((Object)this.oldSource);
            informationFlow.getInformationSources().add((Object)((NamedElement)this.newSource));
            return CheckStatus.YES;
        }

        public CheckStatus caseInterfaceRealization(InterfaceRealization interfaceRealization) {
            BehavioredClassifier newBehaviorSource = (BehavioredClassifier)this.newSource;
            interfaceRealization.setImplementingClassifier(newBehaviorSource);
            return CheckStatus.YES;
        }

        public CheckStatus caseMessage(Message message) {
            MessageEnd sendEvent = message.getSendEvent();
            if (sendEvent instanceof MessageOccurrenceSpecification && this.newSource instanceof Lifeline && this.oldSource instanceof Lifeline) {
                MessageOccurrenceSpecification os = (MessageOccurrenceSpecification)sendEvent;
                os.getCovereds().clear();
                os.getCovereds().add((Object)((Lifeline)this.newSource));
            }
            return CheckStatus.YES;
        }

        public CheckStatus casePackageImport(PackageImport packImport) {
            packImport.setImportingNamespace((Namespace)this.newSource);
            return CheckStatus.YES;
        }

        public CheckStatus casePackageMerge(PackageMerge object) {
            object.setReceivingPackage((Package)this.newSource);
            return CheckStatus.YES;
        }

        public CheckStatus caseSubstitution(Substitution substitution) {
            substitution.setSubstitutingClassifier((Classifier)this.newSource);
            return CheckStatus.YES;
        }

        public CheckStatus caseTransition(Transition transition) {
            transition.setSource((Vertex)this.newSource);
            return CheckStatus.YES;
        }
    }
}

