/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class CustomSetConnectionAnchorsCommand
extends AbstractTransactionalCommand {
    private IAdaptable edgeAdaptor;
    private INodeEditPart node;
    private ReconnectRequest sourceReconnectRequest;
    private boolean isSourceSet;
    private ReconnectRequest targetReconnectRequest;
    private boolean isTargetSet;

    public CustomSetConnectionAnchorsCommand(TransactionalEditingDomain editingDomain, String label) {
        super(editingDomain, label, null);
    }

    public List<?> getAffectedFiles() {
        View view = (View)this.edgeAdaptor.getAdapter(View.class);
        if (view != null) {
            return CustomSetConnectionAnchorsCommand.getWorkspaceFiles((EObject)view);
        }
        return super.getAffectedFiles();
    }

    public IAdaptable getEdgeAdaptor() {
        return this.edgeAdaptor;
    }

    public void setEdgeAdaptor(IAdaptable edgeAdaptor) {
        this.edgeAdaptor = edgeAdaptor;
    }

    public INodeEditPart getNode() {
        return this.node;
    }

    public void setNode(INodeEditPart node) {
        this.node = node;
    }

    public ReconnectRequest getSourceReconnectRequest() {
        return this.sourceReconnectRequest;
    }

    public void setSourceReconnectRequest(ReconnectRequest sourceReconnectRequest) {
        this.sourceReconnectRequest = sourceReconnectRequest;
    }

    public ReconnectRequest getTargetReconnectRequest() {
        return this.targetReconnectRequest;
    }

    public void setTargetReconnectRequest(ReconnectRequest targetReconnectRequest) {
        this.targetReconnectRequest = targetReconnectRequest;
    }

    public boolean isSourceSet() {
        return this.isSourceSet;
    }

    public void setSourceSet(boolean isSourceSet) {
        this.isSourceSet = isSourceSet;
    }

    public boolean isTargetSet() {
        return this.isTargetSet;
    }

    public void setTargetSet(boolean isTargetSet) {
        this.isTargetSet = isTargetSet;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IdentityAnchor a;
        assert (this.edgeAdaptor != null) : "Null child in CustomSetConnectionAnchorsCommand";
        Edge edge = (Edge)this.getEdgeAdaptor().getAdapter(Edge.class);
        assert (edge != null) : "Null edge in CustomSetConnectionAnchorsCommand";
        if (this.isSourceSet()) {
            ConnectionAnchor sourceAnchor = this.getNode().getSourceConnectionAnchor((Request)this.getSourceReconnectRequest());
            String newSourceTerminal = this.getNode().mapConnectionAnchorToTerminal(sourceAnchor);
            if (newSourceTerminal.length() == 0) {
                edge.setSourceAnchor(null);
            } else {
                a = (IdentityAnchor)edge.getSourceAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(newSourceTerminal);
                edge.setSourceAnchor((Anchor)a);
            }
        }
        if (this.isTargetSet()) {
            ConnectionAnchor targetAnchor = this.getNode().getTargetConnectionAnchor((Request)this.getTargetReconnectRequest());
            String newTargetTerminal = this.getNode().mapConnectionAnchorToTerminal(targetAnchor);
            if (newTargetTerminal.length() == 0) {
                edge.setTargetAnchor(null);
            } else {
                a = (IdentityAnchor)edge.getTargetAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(newTargetTerminal);
                edge.setTargetAnchor((Anchor)a);
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

