/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.modelexplorer.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableNamedElement;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractGenericCommandHandler
extends AbstractHandler {
    private List<?> selection = Collections.EMPTY_LIST;

    protected abstract Command getCommand(ExecutionEvent var1);

    protected List<EObject> getSelectedElements() {
        LinkedList<EObject> result = new LinkedList<EObject>();
        for (Object element : this.getSelection()) {
            EObject elementi = EMFHelper.getEObject(element);
            if (!(elementi instanceof TableNamedElement)) continue;
            result.add(elementi);
        }
        return result;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            this.selection = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.EMPTY_LIST;
            this.getEditingDomain(event).getCommandStack().execute(this.getCommand(event));
        }
        finally {
            this.selection = Collections.EMPTY_LIST;
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain(ExecutionEvent event) {
        try {
            return ServiceUtilsForHandlers.getInstance().getTransactionalEditingDomain((Object)event);
        }
        catch (ServiceException ex) {
            return null;
        }
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            Object selection = ((IEvaluationContext)evaluationContext).getVariable("selection");
            if (selection instanceof Collection) {
                this.selection = selection instanceof List ? (List)selection : new ArrayList((Collection)selection);
            } else if (selection instanceof IStructuredSelection) {
                this.selection = ((IStructuredSelection)selection).toList();
            }
            this.setBaseEnabled(this.computeEnabled());
            this.selection = Collections.EMPTY_LIST;
        }
        super.setEnabled(evaluationContext);
    }

    protected boolean computeEnabled() {
        boolean result = true;
        List<EObject> elts = this.getSelectedElements();
        if (elts.size() == 0) {
            result = false;
        }
        return result;
    }

    protected List<?> getSelection() {
        return this.selection;
    }
}

