/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.EasingFunctionBase;

public class SineEase
extends EasingFunctionBase {
    @Override
    public double ease(double normalizedTime) {
        switch (this.getEasingMode()) {
            case EaseIn: {
                return this.easeValue(normalizedTime);
            }
            case EaseOut: {
                return 1.0 - this.easeValue(1.0 - normalizedTime);
            }
            case EaseInOut: {
                normalizedTime /= 0.5;
                if (normalizedTime < 1.0) {
                    return this.easeValue(normalizedTime) / 2.0;
                }
                return (2.0 - this.easeValue(2.0 - normalizedTime)) / 2.0;
            }
        }
        throw new XWTException(this.getEasingMode().name() + " is supported.");
    }

    protected double easeValue(double normalizedTime) {
        return 1.0 - Math.sin((1.0 - normalizedTime) * Math.PI / 2.0);
    }
}

