/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator.iterators;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitorImpl;
import org.eclipse.m2m.internal.qvt.oml.evaluator.iterators.QvtIterationTemplate;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.VoidType;

public abstract class QvtImperativeIteratorTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends QvtIterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    protected QvtImperativeIteratorTemplate(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> v) {
        super(v);
    }

    protected abstract Object evaluateResult(List<Variable<C, PM>> var1, String var2, OCLExpression<EClassifier> var3, Object var4, boolean var5);

    @Override
    protected Object evaluateResultTemplate(List<Variable<C, PM>> iterators, Variable<EClassifier, EParameter> target, String resultName, OCLExpression<C> condition, OCLExpression<C> body, boolean isOne) {
        Object bodyVal = null;
        if (body != null) {
            bodyVal = this.getEvaluationVisitor().visitExpression(body);
        } else if (iterators.size() == 1) {
            bodyVal = this.getEvalEnvironment().getValueOf(iterators.get(0).getName());
        }
        if (bodyVal instanceof QvtOperationalEvaluationVisitorImpl.BreakingResult) {
            return bodyVal;
        }
        this.advanceTarget(target, bodyVal);
        Object resultVal = this.evaluateResult(iterators, resultName, condition, bodyVal, isOne);
        return resultVal;
    }

    protected Boolean isConditionOk(OCLExpression<EClassifier> conditionExp, Object bodyVal) {
        Object conditionVal = conditionExp.accept(this.getEvaluationVisitor());
        if (conditionVal instanceof Boolean) {
            return (Boolean)conditionVal;
        }
        if (conditionVal instanceof EClassifier) {
            QvtOperationalEvaluationEnv env = (QvtOperationalEvaluationEnv)this.getEvalEnvironment();
            return this.oclIsKindOf(bodyVal, (EClassifier)conditionVal, env);
        }
        this.setDone(true);
        return null;
    }

    protected Object returnCheckedEvaluationResult(Object addedElement, boolean isOne, String resultName) {
        if (addedElement == this.getInvalid()) {
            this.setDone(true);
            return this.getInvalid();
        }
        if (isOne) {
            this.setDone(true);
            return addedElement;
        }
        Collection resultingCollection = (Collection)this.getEvalEnvironment().getValueOf(resultName);
        resultingCollection.add(addedElement);
        return resultingCollection;
    }

    private Boolean oclIsKindOf(Object value, EClassifier type, QvtOperationalEvaluationEnv env) {
        if (type == null) {
            return null;
        }
        if (this.isUndefined(value)) {
            return this.oclIsTypeOf(value, type);
        }
        return env.isKindOf(value, type);
    }

    private boolean isUndefined(Object value) {
        return QvtOperationalUtil.isUndefined(value, this.getEvalEnvironment());
    }

    private Boolean oclIsTypeOf(Object value, EClassifier type) {
        if (type == null) {
            return null;
        }
        if (value == null) {
            return type instanceof VoidType;
        }
        if (QvtOperationalUtil.isInvalid(value, this.getEvalEnvironment())) {
            return type instanceof InvalidType;
        }
        EvaluationEnvironment evalEnv = this.getEvalEnvironment();
        return evalEnv.isTypeOf(value, (Object)type);
    }
}

