/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelexplorer.directeditor;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class NamedElementDirectEditorParser
implements IParser {
    private String textToEdit;
    private boolean labelModification;

    public NamedElementDirectEditorParser(String textToEdit) {
        this(textToEdit, false);
    }

    public NamedElementDirectEditorParser(String textToEdit, boolean labelModification) {
        this.textToEdit = textToEdit;
        this.labelModification = labelModification;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.textToEdit;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        CompositeCommand compositeCommand = new CompositeCommand("Rename");
        EObject eObjectElement = (EObject)element.getAdapter(EObject.class);
        if (eObjectElement instanceof NamedElement && newString != null && !newString.isEmpty()) {
            if (this.labelModification) {
                compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper(UMLLabelInternationalization.getInstance().getSetLabelCommand((EditingDomain)((ModelSet)eObjectElement.eResource().getResourceSet()).getTransactionalEditingDomain(), (NamedElement)eObjectElement, newString, null)));
            } else {
                SetRequest setRequest = new SetRequest(eObjectElement, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newString);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)eObjectElement);
                ICommand editCommand = provider.getEditCommand((IEditCommandRequest)setRequest);
                compositeCommand.add((IUndoableOperation)editCommand);
            }
        }
        return compositeCommand;
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.textToEdit;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return null;
    }
}

