/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.core.io.Messages;

public class PollingOutputStream
extends FilterOutputStream {
    private static final boolean DEBUG = false;
    private final int numAttempts;
    private final IProgressMonitor monitor;
    private boolean cancellable;

    public PollingOutputStream(OutputStream out, int numAttempts, IProgressMonitor monitor) {
        super(out);
        this.numAttempts = numAttempts;
        this.monitor = monitor;
        this.cancellable = true;
    }

    @Override
    public void write(int b) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                this.out.write(b);
                return;
            }
            catch (InterruptedIOException e) {
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(Messages.PollingOutputStream_writeTimeout);
            }
            break;
        }
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        int count = 0;
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                this.out.write(buffer, off, len);
                return;
            }
            catch (InterruptedIOException e) {
                int amount = e.bytesTransferred;
                if (amount == 0) continue;
                if ((len -= amount) <= 0) {
                    return;
                }
                off += amount;
                count += amount;
                attempts = 0;
                if (++attempts != this.numAttempts) continue;
                e = new InterruptedIOException(Messages.PollingOutputStream_writeTimeout);
                e.bytesTransferred = count;
                throw e;
            }
            break;
        }
    }

    @Override
    public void flush() throws IOException {
        int count = 0;
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                this.out.flush();
                return;
            }
            catch (InterruptedIOException e) {
                int amount = e.bytesTransferred;
                if (amount == 0) continue;
                count += amount;
                attempts = 0;
                if (++attempts != this.numAttempts) continue;
                e = new InterruptedIOException(Messages.PollingOutputStream_writeTimeout);
                e.bytesTransferred = count;
                throw e;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void close() throws IOException {
        attempts = this.numAttempts - 1;
        try {
            this.out.flush();
            attempts = 0;
        }
        finally {
            stop = false;
            ** while (!stop)
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.out.close();
                stop = true;
                continue;
            }
            catch (InterruptedIOException e) {
                if (this.checkCancellation()) {
                    throw new OperationCanceledException();
                }
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(Messages.PollingOutputStream_closeTimeout);
            }
        }
lbl18:
        // 1 sources

    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private boolean checkCancellation() {
        if (this.cancellable) {
            return this.monitor.isCanceled();
        }
        return false;
    }
}

