/*****************************************************************************
 * Copyright (c) 2020 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *  Matteo MORELLI      matteo.morelli@cea.fr - Bug #566899
 *
 *****************************************************************************/

package org.eclipse.papyrus.robotics.ros2.codegen.utils

import java.util.List
import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.MessageUtils.*
import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.SkillUtils.*
import java.util.ArrayList
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic
import java.util.Map

class SkillRealizBuildUtils {

	public static String USER = "USER"

	/**
	 * Calculate the service definition dependencies for skills
	 */
	static def List<String> calcDependencies(Map<SkillDefinition, SkillSemantic> skdefToSemanticsMap) {
		val dependencies = new ArrayList<String>
		for (definition : skdefToSemanticsMap.keySet)
			for (param : definition.ins + definition.outs) {
				val pkgName = param.type.messagePackage.name.toLowerCase
				if (!dependencies.contains(pkgName)) {
					dependencies.add(pkgName)
				}
			}
		for (semantics : skdefToSemanticsMap.values)
			for (ops : semantics.operational)
				if (ops.doesConfigAndCoordOfComponents) {
					val pkgName = SkillUtils.getCompInterface(ops).messagePackage.name.toLowerCase
					if (!dependencies.contains(pkgName)) {
						dependencies.add(pkgName)
					}
				}
		return dependencies
	}

}
