/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.component;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.TemplateBinding;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.infra.tools.file.IPFileSystemAccess;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.papyrus.robotics.ros2.codegen.component.CodeSkeleton;
import org.eclipse.papyrus.robotics.ros2.codegen.component.Constructor;
import org.eclipse.papyrus.robotics.ros2.codegen.component.CreateMain;
import org.eclipse.papyrus.robotics.ros2.codegen.component.ParameterTransformations;
import org.eclipse.papyrus.robotics.ros2.codegen.component.RoboticsCppCreator;
import org.eclipse.papyrus.robotics.ros2.codegen.message.CreateMsgPackage;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ApplyProfiles;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ComponentUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.Helpers;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ProjectTools;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ComponentTransformations {
    private IPFileSystemAccess fileAccess;
    private IProject genProject;

    public ComponentTransformations(IPFileSystemAccess fileAccess, IProject genProject) {
        this.fileAccess = fileAccess;
        this.genProject = genProject;
    }

    public static void liftFunctions(Class component) {
        ComponentDefinition cd = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)component, ComponentDefinition.class);
        EList _activities = cd.getActivities();
        for (Activity activity : _activities) {
            ComponentTransformations.liftFunctions(activity, component);
        }
    }

    public static void removeActivities(Class component) {
        Activity[] _clone;
        ComponentDefinition cd = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)component, ComponentDefinition.class);
        Activity[] activityArray = _clone = (Activity[])((Activity[])Conversions.unwrapArray((Object)cd.getActivities(), Activity.class)).clone();
        int n = _clone.length;
        int n2 = 0;
        while (n2 < n) {
            Activity activity = activityArray[n2];
            component.getAttribute(null, (Type)activity.getBase_Class()).destroy();
            activity.getBase_Class().destroy();
            ++n2;
        }
    }

    public static void removeTemplateSig(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            if (InteractionUtils.getServiceDefinition((Port)port) == null || InteractionUtils.getTemplateBinding((Interface)InteractionUtils.getServiceDefinition((Port)port)) == null) continue;
            InteractionUtils.getTemplateBinding((Interface)InteractionUtils.getServiceDefinition((Port)port)).destroy();
        }
    }

    public static void liftFunctions(Activity activity, Class component) {
        EList _attributes = activity.getBase_Class().getAttributes();
        for (Property fct : _attributes) {
            Type _type = fct.getType();
            if (!(_type instanceof Behavior)) continue;
            Type _type_1 = fct.getType();
            Behavior fctType = (Behavior)_type_1;
            Function fctSt = (Function)UMLUtil.getStereotypeApplication((Element)fctType, Function.class);
            if (fctSt != null) {
                Function _copy;
                Function copy = _copy = (Function)EcoreUtil.copy((EObject)fctSt);
                component.getOwnedBehaviors().add((Object)fctType);
                fctSt = (Function)StereotypeUtil.applyApp((Element)fctType, Function.class);
                EList _eStructuralFeatures = fctSt.eClass().getEStructuralFeatures();
                for (EStructuralFeature feature : _eStructuralFeatures) {
                    boolean _isChangeable = feature.isChangeable();
                    if (!_isChangeable) continue;
                    fctSt.eSet(feature, copy.eGet(feature));
                }
            } else {
                component.getOwnedBehaviors().add((Object)fctType);
            }
            Operation specification = component.createOwnedOperation(fctType.getName(), null, null);
            fctType.setSpecification((BehavioralFeature)specification);
        }
    }

    public static void createPubsSubsAttrs(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _greaterThan;
            boolean _isPush = InteractionUtils.isPush((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
            if (!_isPush) continue;
            Property attribute = null;
            int _size = port.getProvideds().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Type rosPublisher = Helpers.getRosType((Element)port, "ros2Library::rclcpp_lifecycle::LifecyclePublisher");
                StringConcatenation _builder = new StringConcatenation();
                String _name = port.getName();
                _builder.append(_name);
                _builder.append("_pub_");
                attribute = component.createOwnedAttribute(_builder.toString(), rosPublisher);
            } else {
                boolean _greaterThan_1;
                int _size_1 = port.getRequireds().size();
                boolean bl2 = _greaterThan_1 = _size_1 > 0;
                if (_greaterThan_1) {
                    Type rosSubscriber = Helpers.getRosType((Element)port, "ros2Library::rclcpp::Subscription");
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _name_1 = port.getName();
                    _builder_1.append(_name_1);
                    _builder_1.append("_sub_");
                    attribute = component.createOwnedAttribute(_builder_1.toString(), rosSubscriber);
                }
            }
            ApplyProfiles.applyCommonProfile(attribute);
            TemplateBinding template = (TemplateBinding)StereotypeUtil.applyApp(attribute, TemplateBinding.class);
            template.getActuals().add((Object)InteractionUtils.getCommObject((Port)port));
            Helpers.useSharedPtr((TypedElement)attribute);
        }
    }

    public static void createSendAttrs(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _greaterThan;
            boolean _isSend = InteractionUtils.isSend((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
            if (!_isSend) continue;
            Property attribute = null;
            int _size = port.getProvideds().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Type rosSubscriber = Helpers.getRosType((Element)port, "ros2Library::rclcpp::Subscription");
                StringConcatenation _builder = new StringConcatenation();
                String _name = port.getName();
                _builder.append(_name);
                _builder.append("_recv_");
                attribute = component.createOwnedAttribute(_builder.toString(), rosSubscriber);
            } else {
                boolean _greaterThan_1;
                int _size_1 = port.getRequireds().size();
                boolean bl2 = _greaterThan_1 = _size_1 > 0;
                if (_greaterThan_1) {
                    Type rosPublisher = Helpers.getRosType((Element)port, "ros2Library::rclcpp_lifecycle::LifecyclePublisher");
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _name_1 = port.getName();
                    _builder_1.append(_name_1);
                    _builder_1.append("_send_");
                    attribute = component.createOwnedAttribute(_builder_1.toString(), rosPublisher);
                }
            }
            ApplyProfiles.applyCommonProfile(attribute);
            TemplateBinding template = (TemplateBinding)StereotypeUtil.applyApp(attribute, TemplateBinding.class);
            template.getActuals().add((Object)InteractionUtils.getCommObject((Port)port));
            Helpers.useSharedPtr((TypedElement)attribute);
        }
    }

    public static void createServiceAttrs(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _greaterThan;
            boolean _isQuery = InteractionUtils.isQuery((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
            if (!_isQuery) continue;
            Property attribute = null;
            int _size = port.getProvideds().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Type rosService = Helpers.getRosType((Element)port, "ros2Library::rclcpp::Service");
                StringConcatenation _builder = new StringConcatenation();
                String _name = port.getName();
                _builder.append(_name);
                _builder.append("_srv_");
                attribute = component.createOwnedAttribute(_builder.toString(), rosService);
            } else {
                boolean _greaterThan_1;
                int _size_1 = port.getRequireds().size();
                boolean bl2 = _greaterThan_1 = _size_1 > 0;
                if (_greaterThan_1) {
                    Type rosClient = Helpers.getRosType((Element)port, "ros2Library::rclcpp::Client");
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _name_1 = port.getName();
                    _builder_1.append(_name_1);
                    _builder_1.append("_client_");
                    attribute = component.createOwnedAttribute(_builder_1.toString(), rosClient);
                }
            }
            TemplateBinding template = (TemplateBinding)StereotypeUtil.applyApp(attribute, TemplateBinding.class);
            if (template == null) {
                ApplyProfiles.applyCommonProfile(attribute);
                template = (TemplateBinding)StereotypeUtil.applyApp(attribute, TemplateBinding.class);
            }
            template.getActuals().add((Object)MessageUtils.getServiceType(port));
            Helpers.useSharedPtr((TypedElement)attribute);
        }
    }

    public static void createActionAttrs(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _greaterThan;
            boolean _isAction = InteractionUtils.isAction((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port));
            if (!_isAction) continue;
            Property attribute = null;
            int _size = port.getProvideds().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Type rosService = Helpers.getRosType((Element)port, "ros2Library::rclcpp_action::Server");
                StringConcatenation _builder = new StringConcatenation();
                String _name = port.getName();
                _builder.append(_name);
                _builder.append("_actsrv_");
                attribute = component.createOwnedAttribute(_builder.toString(), rosService);
            } else {
                boolean _greaterThan_1;
                int _size_1 = port.getRequireds().size();
                boolean bl2 = _greaterThan_1 = _size_1 > 0;
                if (_greaterThan_1) {
                    Type rosClient = Helpers.getRosType((Element)port, "ros2Library::rclcpp_action::Client");
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _name_1 = port.getName();
                    _builder_1.append(_name_1);
                    _builder_1.append("_actcli_");
                    attribute = component.createOwnedAttribute(_builder_1.toString(), rosClient);
                }
            }
            TemplateBinding template = (TemplateBinding)StereotypeUtil.applyApp(attribute, TemplateBinding.class);
            if (template == null) {
                ApplyProfiles.applyCommonProfile(attribute);
                template = (TemplateBinding)StereotypeUtil.applyApp(attribute, TemplateBinding.class);
            }
            template.getActuals().add((Object)MessageUtils.getServiceType(port));
            Helpers.useSharedPtr((TypedElement)attribute);
        }
    }

    public static void removePorts(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            port.getType().destroy();
            port.destroy();
        }
    }

    public void componentTrafo(Class component, CreateMsgPackage msgPkgCreator) {
        try {
            boolean _greaterThan;
            boolean _isRegistered;
            MessageUtils.createMessagesOrServices(msgPkgCreator, component);
            if (this.genProject == null) {
                throw new TransformationException(ExecuteTransformationChain.USER_CANCEL);
            }
            ComponentTransformations.liftFunctions(component);
            Constructor.createConstructor(component);
            Include include = (Include)StereotypeUtil.applyApp((Element)component, Include.class);
            String _header = include.getHeader();
            String _plus = String.valueOf(_header) + "#include <rclcpp/rclcpp.hpp>\n";
            include.setHeader(_plus);
            boolean _hasActions = MessageUtils.hasActions(component);
            if (_hasActions) {
                String _header_1 = include.getHeader();
                String _plus_1 = String.valueOf(_header_1) + "#include <rclcpp_action/rclcpp_action.hpp>\n";
                include.setHeader(_plus_1);
            }
            if (_isRegistered = ComponentUtils.isRegistered(component)) {
                String _body = include.getBody();
                CharSequence _registerComponent = CreateMain.registerComponent(component);
                String _plus_2 = String.valueOf(_body) + _registerComponent;
                include.setBody(_plus_2);
            }
            CreateMain.createMain(component);
            boolean _hasExternalCode = ActivityUtils.hasExternalCode(component);
            if (_hasExternalCode) {
                CodeSkeleton.createSkeleton(component);
            }
            ComponentTransformations.removeActivities(component);
            ComponentTransformations.createPubsSubsAttrs(component);
            ComponentTransformations.createSendAttrs(component);
            ComponentTransformations.createServiceAttrs(component);
            ComponentTransformations.createActionAttrs(component);
            int _size = ParameterUtils.getAllParameters((Class)component).size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                ParameterTransformations.declareParameters(component);
                ParameterTransformations.initParameters(component);
            }
            ParameterTransformations.moveParameters(component);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void componentCodegen(Class component, CreateMsgPackage msgPkgCreator) {
        RoboticsCppCreator codeGen = new RoboticsCppCreator(this.fileAccess, "src-skel/", "src/");
        ComponentTransformations.removeTemplateSig(component);
        ComponentTransformations.removePorts(component);
        TransformationContext.current.project = this.genProject;
        ProjectTools.genCode(codeGen, component);
    }
}

