/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.robotics.assertions.languages.IExpressionLanguage;

public class ExpressionLanguagesHelper {
    public static final String EXPRESSIONLANGUAGES_EXTENSIONPOINT = "org.eclipse.papyrus.robotics.assertions.languages";

    public static List<IExpressionLanguage> getAllExpressionLanguages() {
        IConfigurationElement[] extensionPoints;
        ArrayList<IExpressionLanguage> result = new ArrayList<IExpressionLanguage>();
        IConfigurationElement[] iConfigurationElementArray = extensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPRESSIONLANGUAGES_EXTENSIONPOINT);
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extensionPoint = iConfigurationElementArray[n2];
            try {
                result.add((IExpressionLanguage)extensionPoint.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return result;
    }

    public static IExpressionLanguage getExpressionLanguageByName(String name) {
        for (IExpressionLanguage lang : ExpressionLanguagesHelper.getAllExpressionLanguages()) {
            if (!lang.getName().equals(name)) continue;
            return lang;
        }
        return null;
    }
}

