/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.library.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.commands.CancelCommand;
import org.eclipse.papyrus.robotics.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.robotics.core.menu.MenuHelper;
import org.eclipse.papyrus.robotics.core.provider.EClassGraphicalContentProvider;
import org.eclipse.papyrus.robotics.core.provider.RoboticsContentProvider;
import org.eclipse.papyrus.robotics.library.advice.AdviceUtil;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.CommunicationObject;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AbstractActionPatternAdvice
extends AbstractEditHelperAdvice {
    public static final String ACTION_PATTERN = "robotics::commpatterns::Action";

    public abstract void applyServiceStereotype(Classifier var1);

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        DataType feedback;
        DataType response;
        DataType goal;
        CompositeCommand compositeCommand = new CompositeCommand("Action pattern configuration command");
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Classifier)) {
            return super.getAfterConfigureCommand(request);
        }
        final Classifier classifier = (Classifier)newElement;
        RoboticsContentProvider cp = new RoboticsContentProvider((EObject)classifier, (IStaticContentProvider)new EClassGraphicalContentProvider((EObject)classifier, UMLPackage.eINSTANCE.getDataType()), CommunicationObject.class, ".servicedef.uml");
        EnhancedPopupMenu popupMenuEvent = MenuHelper.createPopupMenu((IStaticContentProvider)cp, (String)"Choose CO for goal", (boolean)false);
        Object menuResult = null;
        if (popupMenuEvent.show((Control)Display.getDefault().getActiveShell())) {
            menuResult = popupMenuEvent.getSubResult();
        }
        DataType dataType = goal = menuResult instanceof DataType ? (DataType)menuResult : null;
        if (goal == null) {
            return new CancelCommand((EObject)classifier);
        }
        EnhancedPopupMenu popupMenuParam = MenuHelper.createPopupMenu((IStaticContentProvider)cp, (String)"Choose CO for response", (boolean)false);
        if (popupMenuParam.show((Control)Display.getDefault().getActiveShell())) {
            menuResult = popupMenuParam.getSubResult();
        }
        DataType dataType2 = response = menuResult instanceof DataType ? (DataType)menuResult : null;
        if (response == null) {
            return new CancelCommand((EObject)classifier);
        }
        EnhancedPopupMenu popupMenuState = MenuHelper.createPopupMenu((IStaticContentProvider)cp, (String)"Choose CO for feedback", (boolean)false);
        if (popupMenuState.show((Control)Display.getDefault().getActiveShell())) {
            menuResult = popupMenuState.getSubResult();
        }
        DataType dataType3 = feedback = menuResult instanceof DataType ? (DataType)menuResult : null;
        if (feedback == null) {
            return new CancelCommand((EObject)classifier);
        }
        RecordingCommand templateBinding = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

            protected void doExecute() {
                Classifier eventCommPattern = AdviceUtil.getPattern((Element)classifier, AbstractActionPatternAdvice.ACTION_PATTERN);
                if (eventCommPattern != null) {
                    TemplateSignature signature = eventCommPattern.getOwnedTemplateSignature();
                    TemplateBinding binding = classifier.createTemplateBinding(signature);
                    String name = "Action";
                    for (TemplateParameter tp : signature.getOwnedParameters()) {
                        TemplateParameterSubstitution substitution = binding.createParameterSubstitution();
                        substitution.setFormal(tp);
                        String formalName = ((NamedElement)tp.getParameteredElement()).getName();
                        if (formalName.equals("Goal")) {
                            substitution.setActual((ParameterableElement)goal);
                            name = String.valueOf(name) + "_" + goal.getName();
                            continue;
                        }
                        if (formalName.equals("Response")) {
                            substitution.setActual((ParameterableElement)response);
                            name = String.valueOf(name) + "_" + response.getName();
                            continue;
                        }
                        if (!formalName.equals("Feedback")) continue;
                        substitution.setActual((ParameterableElement)feedback);
                        name = String.valueOf(name) + "_" + feedback.getName();
                    }
                    classifier.setName(name);
                }
                AbstractActionPatternAdvice.this.applyServiceStereotype(classifier);
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)templateBinding));
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }
}

