/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;

public class FileExtensions {
    public static final String COMPDEF_UML = ".compdef.uml";
    public static final String SERVICEDEF_UML = ".servicedef.uml";
    public static final String SYSTEM_UML = ".system.uml";
    public static final String SKILLS_UML = ".skills.uml";
    public static final String BT_UML = ".bt.uml";
    public static final String THARA_UML = ".thara.uml";
    public static final String COMPDEF_ICON = "platform:/plugin/org.eclipse.papyrus.robotics.profile/icons/ComponentDefinition.png";
    public static final String SYSTEM_ICON = "platform:/plugin/org.eclipse.papyrus.robotics.diagrams/icons/Diagram_Assembly.png";
    public static final String SKILLS_ICON = "platform:/plugin/org.eclipse.papyrus.robotics.diagrams/icons/Diagram_Skill.png";
    public static final String SERVICEDEF_ICON = "platform:/plugin/org.eclipse.papyrus.robotics.profile/icons/ServiceDefinition.png";
    public static final String BT_ICON = "platform:/plugin/org.eclipse.papyrus.robotics.bt.ui/images/subtree.png";
    public static final String THARA_ICON = "platform:/plugin/org.eclipse.papyrus.robotics.safety.riskanalysis.ui/icons/hara.png";
    private static Map<String, String> extPath = new HashMap<String, String>();

    static {
        extPath.put(COMPDEF_UML, COMPDEF_ICON);
        extPath.put(SERVICEDEF_UML, SERVICEDEF_ICON);
        extPath.put(SYSTEM_UML, SYSTEM_ICON);
        extPath.put(SKILLS_UML, SKILLS_ICON);
        extPath.put(BT_UML, BT_ICON);
        extPath.put(THARA_UML, THARA_ICON);
    }

    public static String getExtension(URI path) {
        for (String extension : extPath.keySet()) {
            if (!path.path().endsWith(extension)) continue;
            return extension;
        }
        return null;
    }

    public static String getImagePath(URI path) {
        String extension = FileExtensions.getExtension(path);
        if (extension != null) {
            return extPath.get(extension);
        }
        return null;
    }
}

