/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.robotics.core.provider.RoboticsContentProvider;
import org.eclipse.papyrus.robotics.core.provider.RoboticsLabelProvider;
import org.eclipse.papyrus.robotics.core.utils.ImportUtils;
import org.eclipse.papyrus.robotics.core.utils.ScanUtils;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EnhancedPopupMenu
extends PopupMenu {
    SubSelect subSelection;
    static final boolean DIRECT_SELECTION = true;

    public EnhancedPopupMenu(List<?> aContent, ILabelProvider aLabelProvider) {
        super(aContent, aLabelProvider);
    }

    protected void createMenuItems(Menu parentMenu, PopupMenu rootMenu, final List resultThusFar) {
        Assert.isNotNull((Object)this.getContent());
        Assert.isNotNull((Object)this.getLabelProvider());
        final EnhancedPopupMenu rootMenuWithSeparators = (EnhancedPopupMenu)rootMenu;
        for (Object contentObject : this.getContent()) {
            MenuItem menuItem;
            if (contentObject instanceof PopupMenu.CascadingMenu) {
                EnhancedPopupMenu subMenu = (EnhancedPopupMenu)((PopupMenu.CascadingMenu)contentObject).getSubMenu();
                contentObject = ((PopupMenu.CascadingMenu)contentObject).getParentMenuItem();
                ArrayList thisResult = new ArrayList(resultThusFar);
                thisResult.add(contentObject);
                menuItem = new MenuItem(parentMenu, 64);
                menuItem.setMenu(new Menu(parentMenu));
                subMenu.createMenuItems(menuItem.getMenu(), rootMenu, thisResult);
            } else {
                menuItem = contentObject instanceof Separator ? new MenuItem(parentMenu, 2) : new MenuItem(parentMenu, 0);
            }
            if (contentObject instanceof Disabled) {
                contentObject = ((Disabled)contentObject).content;
                menuItem.setEnabled(false);
            }
            if (contentObject instanceof Separator) continue;
            final Object selection = contentObject;
            if (contentObject instanceof SubSelect) {
                menuItem.setText(((SubSelect)contentObject).text);
            } else {
                menuItem.setText(this.getLabelProvider().getText(selection));
                menuItem.setImage(this.getLabelProvider().getImage(selection));
            }
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    resultThusFar.add(selection);
                    rootMenuWithSeparators.setResult(resultThusFar);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    resultThusFar.add(selection);
                    rootMenuWithSeparators.setResult(resultThusFar);
                }
            });
        }
    }

    public boolean show(Control control) {
        for (Object menuItem : this.getContent()) {
            if (!(menuItem instanceof SubSelect)) continue;
            this.subSelection = (SubSelect)menuItem;
            break;
        }
        if (this.subSelection != null) {
            return this.subSelection.getResult() != null;
        }
        return super.show(control);
    }

    public Object getSubResult() {
        Object result;
        Object object = result = this.subSelection != null ? this.subSelection : this.getResult();
        if (result instanceof SubSelect) {
            SubSelect subSel = (SubSelect)result;
            Object value = subSel.getResult();
            return value;
        }
        ImportUtils.createImportFromObj(result);
        return result;
    }

    public static class Disabled {
        public Object content;

        public Disabled(Object content) {
            this.content = content;
        }
    }

    public static class Separator {
    }

    public static class SubSelect {
        public String text;
        public IStructuredContentProvider contentProvider;
        Object result;

        public SubSelect(String text, IStructuredContentProvider contentProvider) {
            this.text = text;
            this.contentProvider = contentProvider;
        }

        public Object getResult() {
            if (this.result != null) {
                return this.result;
            }
            TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell());
            dialog.setLabelProvider((ILabelProvider)new RoboticsLabelProvider((ILabelProvider)new UMLLabelProvider()));
            dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider(this.contentProvider));
            dialog.setTitle(this.text);
            int code = dialog.open();
            if (code == 0) {
                this.result = dialog.getResult()[0];
                if (this.result instanceof EObject && this.contentProvider instanceof RoboticsContentProvider) {
                    RoboticsContentProvider rcp = (RoboticsContentProvider)this.contentProvider;
                    this.result = ScanUtils.moveIntoRS(rcp.getResourceSet(), (EObject)this.result);
                }
                ImportUtils.createImportFromObj(this.result);
                return this.result;
            }
            return null;
        }
    }
}

