/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.interpreter.console;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.examples.interpreter.OCLExamplePlugin;
import org.eclipse.ocl.examples.interpreter.console.DelegatingPackageRegistry;
import org.eclipse.ocl.examples.interpreter.console.IOCLFactory;
import org.eclipse.ocl.examples.interpreter.console.ModelingLevel;
import org.eclipse.ocl.examples.interpreter.console.OCLConsole;
import org.eclipse.ocl.examples.interpreter.console.OCLResource;
import org.eclipse.ocl.examples.interpreter.console.TargetMetamodel;
import org.eclipse.ocl.examples.interpreter.console.text.ColorManager;
import org.eclipse.ocl.examples.interpreter.console.text.OCLDocument;
import org.eclipse.ocl.examples.interpreter.console.text.OCLSourceViewer;
import org.eclipse.ocl.examples.interpreter.internal.l10n.OCLInterpreterMessages;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.ocl.uml.options.EvaluationMode;
import org.eclipse.ocl.uml.options.UMLEvaluationOptions;
import org.eclipse.ocl.uml.util.OCLUMLUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.osgi.framework.Bundle;

public class OCLConsolePage
extends Page {
    private static int BUNDLE_AVAILABLE = 44;
    private Composite page;
    private ITextViewer output;
    private OCLSourceViewer input;
    private OCLDocument document;
    private ColorManager colorManager;
    private String lastOCLExpression;
    private EObject context;
    private ISelectionService selectionService;
    private ISelectionListener selectionListener;
    private IOCLFactory<Object> oclFactory = new EcoreOCLFactory();
    private OCL<?, Object, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> ocl;
    private ModelingLevel modelingLevel = ModelingLevel.M2;
    private Map<TargetMetamodel, IAction> metamodelActions = new HashMap<TargetMetamodel, IAction>();
    private static final AdapterFactory reflectiveAdapterFactory = new ReflectiveItemProviderAdapterFactory();
    private static final AdapterFactory defaultAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    public IItemLabelProvider tupleTypeLabelProvider = new IItemLabelProvider(){

        public Object getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            Tuple tuple = (Tuple)object;
            TupleType tupleType = tuple.getTupleType();
            StringBuilder result = new StringBuilder();
            result.append("Tuple{");
            Iterator iter = tupleType.oclProperties().iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                result.append(OCLConsolePage.this.oclFactory.getName(next));
                result.append(" = ");
                result.append(OCLConsolePage.this.toString(tuple.getValue(next)));
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
            result.append('}');
            return result.toString();
        }
    };

    OCLConsolePage() {
    }

    public void createControl(Composite parent) {
        this.page = new SashForm(parent, 0x2000200);
        this.output = new TextViewer(this.page, 2818);
        this.output.getTextWidget().setLayoutData((Object)new GridData(1808));
        this.output.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.output.setEditable(false);
        this.output.setDocument((IDocument)new Document());
        this.colorManager = new ColorManager();
        this.document = new OCLDocument();
        this.document.setOCLFactory(this.oclFactory);
        this.document.setModelingLevel(this.modelingLevel);
        this.input = new OCLSourceViewer(this.page, this.colorManager, 2050);
        this.input.setDocument((IDocument)this.document);
        this.input.getTextWidget().addKeyListener((KeyListener)new InputKeyListener());
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                OCLConsolePage.this.selectionChanged(selection);
            }
        };
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionService.addPostSelectionListener(this.selectionListener);
        ISelection selection = this.selectionService.getSelection();
        if (selection == null) {
            selection = this.getActiveSelection();
        }
        this.selectionChanged(selection);
        ((SashForm)this.page).setWeights(new int[]{2, 1});
        ClearOutputAction clear = new ClearOutputAction(this.output);
        CloseAction close = new CloseAction();
        SaveAction save = new SaveAction();
        LoadAction load = new LoadAction();
        IMenuManager menu = this.getSite().getActionBars().getMenuManager();
        menu.add((IAction)load);
        menu.add((IAction)save);
        menu.add((IAction)clear);
        menu.add((IAction)close);
        MenuManager metamodelMenu = new MenuManager(OCLInterpreterMessages.console_metamodelMenu, "org.eclipse.ocl.examples.interpreter.metamodel");
        menu.add((IContributionItem)metamodelMenu);
        DropDownAction metamodelAction = new DropDownAction();
        metamodelAction.setToolTipText(OCLInterpreterMessages.console_metamodelTip);
        this.addMetamodelActions((IMenuManager)metamodelMenu, metamodelAction);
        MenuManager levelMenu = new MenuManager(OCLInterpreterMessages.console_modelingLevel);
        menu.add((IContributionItem)levelMenu);
        DropDownAction levelAction = new DropDownAction();
        levelAction.setToolTipText(OCLInterpreterMessages.console_modelingLevelTip);
        ModelingLevelAction m2 = new ModelingLevelAction(ModelingLevel.M2);
        m2.setChecked(true);
        levelMenu.add((IAction)m2);
        levelAction.addAction((IAction)m2);
        ModelingLevelAction m1 = new ModelingLevelAction(ModelingLevel.M1);
        levelMenu.add((IAction)m1);
        levelAction.addAction((IAction)m1);
        ActionContributionItem metamodelItem = new ActionContributionItem((IAction)metamodelAction);
        metamodelItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        IToolBarManager toolbar = this.getSite().getActionBars().getToolBarManager();
        toolbar.appendToGroup("outputGroup", (IContributionItem)metamodelItem);
        toolbar.appendToGroup("outputGroup", (IAction)levelAction);
        toolbar.appendToGroup("outputGroup", (IAction)load);
        toolbar.appendToGroup("outputGroup", (IAction)save);
        toolbar.appendToGroup("outputGroup", (IAction)clear);
        toolbar.appendToGroup("outputGroup", (IAction)close);
    }

    private void addMetamodelActions(IMenuManager metamodelMenu, DropDownAction metamodelAction) {
        EcoreMetamodelAction ecore = new EcoreMetamodelAction();
        ecore.setChecked(true);
        ImageDescriptor img = this.getImage((EObject)EcoreFactory.eINSTANCE.getEPackage());
        if (img != null) {
            ecore.setImageDescriptor(img);
        }
        metamodelMenu.add((IAction)ecore);
        metamodelAction.addAction((IAction)ecore);
        this.metamodelActions.put(TargetMetamodel.Ecore, (IAction)ecore);
        Bundle umlBundle = Platform.getBundle((String)"org.eclipse.uml2.uml");
        if (umlBundle != null && OCLConsolePage.isAvailable(umlBundle)) {
            UMLMetamodelAction uml = new UMLMetamodelAction();
            img = this.getImage((EObject)UMLFactory.eINSTANCE.createModel());
            if (img != null) {
                uml.setImageDescriptor(img);
            }
            metamodelMenu.add((IAction)uml);
            metamodelAction.addAction((IAction)uml);
            this.metamodelActions.put(TargetMetamodel.UML, (IAction)uml);
        }
    }

    static boolean isAvailable(Bundle bundle) {
        return (bundle.getState() & BUNDLE_AVAILABLE) != 0;
    }

    private ImageDescriptor getImage(EObject element) {
        Object image;
        ImageDescriptor result = null;
        IItemLabelProvider provider = (IItemLabelProvider)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE).adapt((Notifier)element, IItemLabelProvider.class);
        if (provider != null && (image = provider.getImage((Object)element)) != null) {
            result = ExtendedImageRegistry.INSTANCE.getImageDescriptor(image);
        }
        return result;
    }

    public Control getControl() {
        return this.page;
    }

    public void setFocus() {
        this.input.getTextWidget().setFocus();
    }

    public void dispose() {
        this.colorManager.dispose();
        this.selectionService.removePostSelectionListener(this.selectionListener);
        super.dispose();
    }

    public void setTargetMetamodel(TargetMetamodel metamodel) {
        IAction action = this.metamodelActions.get((Object)metamodel);
        if (action != null) {
            this.metamodelActions.get((Object)this.oclFactory.getTargetMetamodel()).setChecked(false);
            action.run();
            action.setChecked(true);
        }
    }

    private ISelection getActiveSelection() {
        ISelectionProvider selectionProvider;
        block13: {
            IEditorSite editorSite;
            block12: {
                IEditorPart activeEditor;
                block11: {
                    IWorkbenchPage activePage;
                    block10: {
                        IWorkbenchWindow workbenchWindow;
                        block9: {
                            IPageSite site;
                            block8: {
                                try {
                                    site = this.getSite();
                                    if (site != null) break block8;
                                    return null;
                                }
                                catch (Exception e) {
                                    return null;
                                }
                            }
                            workbenchWindow = site.getWorkbenchWindow();
                            if (workbenchWindow != null) break block9;
                            return null;
                        }
                        activePage = workbenchWindow.getActivePage();
                        if (activePage != null) break block10;
                        return null;
                    }
                    activeEditor = activePage.getActiveEditor();
                    if (activeEditor != null) break block11;
                    return null;
                }
                editorSite = activeEditor.getEditorSite();
                if (editorSite != null) break block12;
                return null;
            }
            selectionProvider = editorSite.getSelectionProvider();
            if (selectionProvider != null) break block13;
            return null;
        }
        return selectionProvider.getSelection();
    }

    private void selectionChanged(ISelection sel) {
        IStructuredSelection ssel;
        if (sel instanceof IStructuredSelection && !(ssel = (IStructuredSelection)sel).isEmpty()) {
            Object selected = ssel.getFirstElement();
            if (selected instanceof EObject) {
                this.context = (EObject)selected;
            } else if (selected instanceof IAdaptable) {
                EObject adapter;
                this.context = adapter = (EObject)((IAdaptable)selected).getAdapter(EObject.class);
            }
            this.document.setOCLContext(this.context);
        }
    }

    boolean evaluate(String expression) {
        boolean result = true;
        if (this.context == null) {
            result = false;
            this.error(OCLInterpreterMessages.console_noContext);
        } else {
            this.ocl = this.oclFactory.createOCL(this.modelingLevel);
            OCLHelper helper = this.ocl.createOCLHelper();
            try {
                ConstraintKind kind = this.modelingLevel.setContext(helper, this.context, this.oclFactory);
                IDocument doc = this.getDocument();
                Color outputDefault = this.colorManager.getColor(ColorManager.DEFAULT);
                Color outputResults = this.colorManager.getColor(ColorManager.OUTPUT_RESULTS);
                if (doc.getLength() > 0) {
                    this.append("", outputDefault, false);
                }
                this.append(OCLInterpreterMessages.console_evaluating, outputDefault, true);
                this.append(expression, outputDefault, false);
                this.append(OCLInterpreterMessages.console_results, outputDefault, true);
                switch (this.modelingLevel) {
                    case M2: {
                        OCLExpression parsed = helper.createQuery(expression);
                        this.print(this.ocl.evaluate((Object)this.context, parsed), outputResults, false);
                        break;
                    }
                    case M1: {
                        helper.createConstraint(kind, expression);
                        this.print(OCLInterpreterMessages.console_parsed, outputResults, false);
                    }
                }
                this.lastOCLExpression = expression;
            }
            catch (Exception e) {
                result = false;
                this.error(e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage());
            }
        }
        return result;
    }

    private IDocument getDocument() {
        return this.output.getDocument();
    }

    private void print(Object object, Color color, boolean bold) {
        Collection<Object> toPrint = object == null ? Collections.EMPTY_SET : (object instanceof Collection ? (Collection)object : (object.getClass().isArray() ? Arrays.asList((Object[])object) : Collections.singleton(object)));
        Iterator iter = toPrint.iterator();
        while (iter.hasNext()) {
            this.append(this.toString(iter.next()), color, bold);
        }
        this.scrollText();
    }

    String toString(Object object) {
        if (this.ocl.isInvalid(object)) {
            return "OclInvalid";
        }
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object instanceof Tuple) {
            return this.tupleTypeLabelProvider.getText(object);
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            IItemLabelProvider labeler = (IItemLabelProvider)defaultAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            if (labeler == null) {
                labeler = (IItemLabelProvider)reflectiveAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            }
            if (labeler != null) {
                return labeler.getText(object);
            }
        }
        return String.valueOf(object);
    }

    private void error(String message) {
        this.append(message, this.colorManager.getColor(ColorManager.OUTPUT_ERROR), false);
        this.scrollText();
    }

    private void scrollText() {
        this.output.revealRange(this.getDocument().getLength(), 0);
    }

    private void append(String text, Color color, boolean bold) {
        IDocument doc = this.getDocument();
        try {
            int offset = doc.getLength();
            int length = text.length();
            text = String.valueOf(text) + '\n';
            if (offset > 0) {
                doc.replace(offset, 0, text);
            } else {
                doc.set(text);
            }
            StyleRange style = new StyleRange();
            style.start = offset;
            style.length = length;
            style.foreground = color;
            if (bold) {
                style.fontStyle = 1;
            }
            this.output.getTextWidget().setStyleRange(style);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, OCLExamplePlugin.getPluginId(), 1, OCLInterpreterMessages.console_outputExc, (Throwable)e);
            OCLExamplePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private class CloseAction
    extends Action {
        private final String tip;

        CloseAction() {
            super(OCLInterpreterMessages.console_closeAction_label, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
            this.tip = OCLInterpreterMessages.console_closeAction_tip;
        }

        public String getToolTipText() {
            return this.tip;
        }

        public void run() {
            OCLConsole.getInstance().close();
        }
    }

    private class DropDownAction
    extends Action
    implements IMenuCreator {
        private Menu menu;
        private List<IAction> actions = new ArrayList<IAction>();
        private IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty()) && Boolean.TRUE.equals(event.getNewValue())) {
                    DropDownAction.this.actionChecked((IAction)event.getSource());
                }
            }
        };

        DropDownAction() {
            this.setMenuCreator(this);
        }

        public void addAction(IAction action) {
            this.actions.add(action);
            action.addPropertyChangeListener(this.listener);
            if (action.isChecked()) {
                this.actionChecked(action);
            }
        }

        private void actionChecked(IAction action) {
            this.setImageDescriptor(action.getImageDescriptor());
            this.setText(action.getText());
        }

        public Menu getMenu(Control parent) {
            if (this.menu == null) {
                this.menu = new Menu(parent);
                for (IAction action : this.actions) {
                    this.addAction(this.menu, action);
                }
            }
            return this.menu;
        }

        private void addAction(Menu m, IAction action) {
            ActionContributionItem contrib = new ActionContributionItem(action);
            contrib.fill(m, -1);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    private class EcoreMetamodelAction
    extends Action {
        private final String tip;

        EcoreMetamodelAction() {
            super(OCLInterpreterMessages.console_metamodel_ecore);
            this.tip = OCLInterpreterMessages.console_metamodel_ecoreTip;
        }

        public int getStyle() {
            return 8;
        }

        public String getToolTipText() {
            return this.tip;
        }

        public void run() {
            OCLConsolePage.this.oclFactory = new EcoreOCLFactory();
            OCLConsolePage.this.document.setOCLFactory(OCLConsolePage.this.oclFactory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EcoreOCLFactory
    implements IOCLFactory<Object> {
        private EcoreOCLFactory() {
        }

        @Override
        public TargetMetamodel getTargetMetamodel() {
            return TargetMetamodel.Ecore;
        }

        private EcoreEnvironmentFactory createEnvironmentFactory() {
            Resource eResource = OCLConsolePage.this.context.eResource();
            ResourceSet resourceSet = eResource != null ? eResource.getResourceSet() : null;
            EPackage.Registry packageRegistry = resourceSet != null ? resourceSet.getPackageRegistry() : null;
            Object compositeRegistry = packageRegistry != null ? new DelegatingPackageRegistry(packageRegistry, EPackage.Registry.INSTANCE) : EPackage.Registry.INSTANCE;
            return new EcoreEnvironmentFactory(compositeRegistry);
        }

        @Override
        public OCL<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createOCL(ModelingLevel level) {
            EcoreEnvironmentFactory envFactory = this.createEnvironmentFactory();
            return OCL.newInstance((EnvironmentFactory)envFactory);
        }

        @Override
        public OCL<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createOCL(ModelingLevel level, Resource res) {
            EcoreEnvironmentFactory envFactory = this.createEnvironmentFactory();
            return OCL.newInstance((EnvironmentFactory)envFactory, (Resource)res);
        }

        @Override
        public Object getContextClassifier(EObject object) {
            return OCLConsolePage.this.context.eClass();
        }

        @Override
        public String getName(Object modelElement) {
            return ((ENamedElement)modelElement).getName();
        }
    }

    private class InputKeyListener
    implements KeyListener {
        private boolean evaluationSuccess = false;
        private List<String> history = new ArrayList<String>();
        private int currentHistoryPointer = 0;

        private InputKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if (OCLConsolePage.this.input.isContentAssistActive() || (e.stateMask & 0x60000) != 0) break;
                    String text = OCLConsolePage.this.document.get();
                    this.evaluationSuccess = OCLConsolePage.this.evaluate(text.trim());
                    break;
                }
                case 0x1000005: {
                    if (OCLConsolePage.this.input.isContentAssistActive() || (e.stateMask & 0x60000) != 0) break;
                    if (this.currentHistoryPointer == 0 && this.history.size() > 0) {
                        if (this.history.size() > 0 && this.history.get(0).length() == 0) {
                            this.history.remove(0);
                        }
                        this.history.add(0, OCLConsolePage.this.document.get().trim());
                        this.currentHistoryPointer = 1;
                        this.setTextFromHistory();
                        break;
                    }
                    if (this.currentHistoryPointer >= this.history.size() - 1) break;
                    ++this.currentHistoryPointer;
                    this.setTextFromHistory();
                    break;
                }
                case 0x1000006: {
                    if (OCLConsolePage.this.input.isContentAssistActive() || (e.stateMask & 0x60000) != 0 || this.currentHistoryPointer <= 0) break;
                    --this.currentHistoryPointer;
                    this.setTextFromHistory();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x40000) != 0) break;
                    if (this.evaluationSuccess) {
                        OCLConsolePage.this.document.set("");
                        if (this.history.size() > 0 && this.history.get(0).trim().length() == 0) {
                            this.history.remove(0);
                        }
                        if (this.history.size() == 0 || !this.history.get(0).equals(OCLConsolePage.this.lastOCLExpression.trim())) {
                            this.history.add(0, OCLConsolePage.this.lastOCLExpression.trim());
                        }
                        this.currentHistoryPointer = 0;
                    }
                    this.evaluationSuccess = false;
                    break;
                }
                case 32: {
                    if ((e.stateMask & 0x40000) != 262144) break;
                    OCLConsolePage.this.input.getContentAssistant().showPossibleCompletions();
                }
            }
        }

        protected void setTextFromHistory() {
            String newText = this.history.get(this.currentHistoryPointer);
            OCLConsolePage.this.document.set(newText);
            OCLConsolePage.this.input.setSelectedRange(newText.length(), 0);
        }
    }

    private class LoadAction
    extends Action {
        private final String tip;

        LoadAction() {
            super(OCLInterpreterMessages.console_loadAction_label, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            this.tip = OCLInterpreterMessages.console_loadAction_tip;
        }

        public String getToolTipText() {
            return this.tip;
        }

        public void run() {
            Shell shell = OCLConsolePage.this.getControl().getShell();
            FileDialog dlg = new FileDialog(shell, 4096);
            dlg.setFilterExtensions(new String[]{"*.xmi"});
            dlg.setText(OCLInterpreterMessages.console_loadDlg_title);
            String file = dlg.open();
            if (file != null) {
                try {
                    String text = OCLResource.load(file);
                    if (text != null) {
                        OCLConsolePage.this.document.set(text);
                    } else {
                        MessageDialog.openWarning((Shell)shell, (String)OCLInterpreterMessages.console_loadWarn_title, (String)OCLInterpreterMessages.console_loadWarn_noExpr);
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)shell, (String)OCLInterpreterMessages.console_loadError_title, (String)e.getLocalizedMessage());
                }
            }
        }
    }

    private class ModelingLevelAction
    extends Action {
        private final ModelingLevel level;

        ModelingLevelAction(ModelingLevel level) {
            super(level.name());
            this.level = level;
        }

        public int getStyle() {
            return 8;
        }

        public void run() {
            OCLConsolePage.this.modelingLevel = this.level;
            OCLConsolePage.this.document.setModelingLevel(this.level);
        }
    }

    private class SaveAction
    extends Action {
        private final String tip;

        SaveAction() {
            super(OCLInterpreterMessages.console_saveAction_label, ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)OCLExamplePlugin.getDefault().getBundle(), (IPath)new Path("$nl$/icons/elcl16/save.gif"), null)));
            this.tip = OCLInterpreterMessages.console_saveAction_tip;
        }

        public String getToolTipText() {
            return this.tip;
        }

        public void run() {
            Shell shell = OCLConsolePage.this.getControl().getShell();
            if (OCLConsolePage.this.lastOCLExpression != null) {
                FileDialog dlg = new FileDialog(shell, 8192);
                dlg.setFilterExtensions(new String[]{"*.xmi"});
                dlg.setText(OCLInterpreterMessages.console_saveDlg_title);
                String file = dlg.open();
                if (file != null) {
                    try {
                        OCLResource.save(file, OCLConsolePage.this.document, OCLConsolePage.this.lastOCLExpression);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)shell, (String)OCLInterpreterMessages.console_saveError_title, (String)e.getLocalizedMessage());
                    }
                }
            } else {
                MessageDialog.openWarning((Shell)shell, (String)OCLInterpreterMessages.console_saveWarn_title, (String)OCLInterpreterMessages.console_saveWarn_noExpr);
            }
        }
    }

    private class UMLMetamodelAction
    extends Action {
        private final String tip;

        UMLMetamodelAction() {
            super(OCLInterpreterMessages.console_metamodel_uml);
            this.tip = OCLInterpreterMessages.console_metamodel_umlTip;
        }

        public int getStyle() {
            return 8;
        }

        public String getToolTipText() {
            return this.tip;
        }

        public void run() {
            OCLConsolePage.this.oclFactory = new UMLOCLFactory();
            OCLConsolePage.this.document.setOCLFactory(OCLConsolePage.this.oclFactory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UMLOCLFactory
    implements IOCLFactory<Object> {
        private UMLOCLFactory() {
        }

        @Override
        public TargetMetamodel getTargetMetamodel() {
            return TargetMetamodel.UML;
        }

        @Override
        public OCL<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createOCL(ModelingLevel level) {
            UMLEnvironmentFactory factory = new UMLEnvironmentFactory((EPackage.Registry)new DelegatingPackageRegistry(OCLConsolePage.this.context.eResource().getResourceSet().getPackageRegistry(), EPackage.Registry.INSTANCE), OCLConsolePage.this.context.eResource().getResourceSet());
            OCL result = OCL.newInstance((EnvironmentFactory)factory);
            switch (level) {
                case M2: {
                    EvaluationOptions.setOption((EvaluationEnvironment)result.getEvaluationEnvironment(), (Option)UMLEvaluationOptions.EVALUATION_MODE, (Object)EvaluationMode.RUNTIME_OBJECTS);
                    break;
                }
                default: {
                    EvaluationOptions.setOption((EvaluationEnvironment)result.getEvaluationEnvironment(), (Option)UMLEvaluationOptions.EVALUATION_MODE, (Object)EvaluationMode.INSTANCE_MODEL);
                }
            }
            return result;
        }

        @Override
        public OCL<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createOCL(ModelingLevel level, Resource res) {
            UMLEnvironmentFactory factory = new UMLEnvironmentFactory((EPackage.Registry)new DelegatingPackageRegistry(OCLConsolePage.this.context.eResource().getResourceSet().getPackageRegistry(), EPackage.Registry.INSTANCE), OCLConsolePage.this.context.eResource().getResourceSet());
            OCL result = OCL.newInstance((EnvironmentFactory)factory, (Resource)res);
            switch (level) {
                case M2: {
                    EvaluationOptions.setOption((EvaluationEnvironment)result.getEvaluationEnvironment(), (Option)UMLEvaluationOptions.EVALUATION_MODE, (Object)EvaluationMode.RUNTIME_OBJECTS);
                    break;
                }
                default: {
                    EvaluationOptions.setOption((EvaluationEnvironment)result.getEvaluationEnvironment(), (Option)UMLEvaluationOptions.EVALUATION_MODE, (Object)EvaluationMode.INSTANCE_MODEL);
                }
            }
            return result;
        }

        @Override
        public Object getContextClassifier(EObject object) {
            return OCLUMLUtil.getClassifier((EClassifier)OCLConsolePage.this.context.eClass(), (ResourceSet)OCLConsolePage.this.context.eResource().getResourceSet());
        }

        @Override
        public String getName(Object modelElement) {
            return ((NamedElement)modelElement).getName();
        }
    }
}

